#include "gui/gui.h"
#include "gui/image.h"
using namespace VGUI;


Image::Image( Widget* w )
{
	filename = "";
	center = w->GetCenter();
	name = w->GetName();
	text = w->GetText();
	type = w->GetType();
	tip = w->GetTip();
	rel_width = w->GetRelWidth();
	rel_height = w->GetRelHeight();
	enabled = w->GetEnabled();
	selected = w->GetSelected();
	is_default = w->GetDefault();
	is_cancel = w->GetCancel();
	has_icon = w->GetHasIcon();
	width_auto = w->GetWidthAuto();
	height_auto = w->GetHeightAuto();
	font_size = w->GetFontSize();
	color_r = w->GetColorR();
	color_g = w->GetColorG();
	color_b = w->GetColorB();
}

Image::~Image()
{
}

void Image::Load()
{
	int img_width, img_height;
	img_tex.Load( filename.c_str(), false, img_width, img_height );
	if( width_auto )
	{
		rel_width = (float)img_width / 1280.0f;
	}

	if( height_auto )
	{
		rel_height = (float)img_height / 1024.0f;
	}
}

void Image::Draw()
{
	Draw( 1.0 );
}

void Image::Draw( float opacity )
{
	float center_x = center.GetXPercent();
	float center_y = center.GetYPercent();
	float rel_width_half = rel_width / 2.0f;
	float rel_height_half = rel_height / 2.0f;
	utility.Draw2D( center_x - rel_width_half, center_y - rel_height_half, center_x + rel_width_half, center_y + rel_height_half, &img_tex, 0.0, 0, opacity );
}
