#include "gui/gui.h"
#include "gui/toggle.h"
using namespace VGUI;


Toggle::Toggle()
{
}

Toggle::Toggle( Widget* w )
{
	value = default_value = false;
	setting = "";
	spacing = 0.3;
	center = w->GetCenter();
	name = w->GetName();
	text = w->GetText();
	type = w->GetType();
	tip = w->GetTip();
	rel_width = w->GetRelWidth();
	rel_height = w->GetRelHeight();
	enabled = w->GetEnabled();
	selected = w->GetSelected();
	is_default = w->GetDefault();
	is_cancel = w->GetCancel();
	has_icon = w->GetHasIcon();
	width_auto = w->GetWidthAuto();
	height_auto = w->GetHeightAuto();
	down = false;
	font_size = w->GetFontSize();
	color_r = w->GetColorR();
	color_g = w->GetColorG();
	color_b = w->GetColorB();

	string skin_path = settings.GetSkinPath();
	on_up.Load( skin_path + "/textures/widgets/tog_on_up.png", false );
	on_down.Load( skin_path + "/textures/widgets/tog_on_down.png", false );
	off_up.Load( skin_path + "/textures/widgets/tog_off_up.png", false );
	off_down.Load( skin_path + "/textures/widgets/tog_off_down.png", false );

	tex_width = 0.0277;
	tex_height = 0.0370;

	// width = spacing between left of text and left of left arrow + spacing between left of left and right arrow + texture width
	if( width_auto )
	{
		rel_width = spacing + 0.15 + tex_width;
	}

	// height = arrow texture height
	if( height_auto )
	{
		rel_height = tex_height;
	}
}

void Toggle::SetSpacing( float new_spacing )
{
	spacing = new_spacing;
	if( width_auto )
	{
		rel_width = spacing + 0.15 + tex_width;
	}
}

Toggle::~Toggle()
{
}

void Toggle::Draw()
{
	Draw( 1.0 );
}

void Toggle::Draw( float opacity )
{
	float center_x = center.GetXPercent();
	float center_y = center.GetYPercent();
	float rel_width_half = rel_width / 2.0f;
	float rel_height_half = rel_height / 2.0f;
	TEXTURE_HANDLE * t1 = value ? ( down ? &on_down : &on_up ) : ( down ? &off_down : &off_up );
	TEXTURE_HANDLE * t2 = value ? ( down ? &off_down : &off_up ) : ( down ? &on_down : &on_up );
	float opacity_txt = selected ? 0.9 : enabled ? 0.75 : 0.4;
	float l_opacity = selected ? 0.9 : enabled ? 0.75 : 0.4;
	float r_opacity = selected ? 0.9 : enabled ? 0.75 : 0.4;
 
	// draw toggle graphics
	utility.Draw2D( center_x - rel_width_half + spacing,
	                center_y - rel_height_half,
	                center_x - rel_width_half + spacing + tex_width,
	                center_y + rel_height_half,
	                t1, 0.0, 64, l_opacity * opacity );
	utility.Draw2D( center_x - rel_width_half + spacing + 0.1,
	                center_y - rel_height_half,
	                center_x - rel_width_half + spacing + 0.1 + tex_width,
	                center_y + rel_height_half,
	                t2, 0.0, 64, r_opacity * opacity );

	// draw text
	font.Print( center_x - rel_width_half, center_y - ( font.Height( text.c_str(), 1, font_size ) / 2.0f ), text.c_str(), 1, font_size, color_r, color_g, color_b, opacity_txt * opacity );
	font.Print( center_x - rel_width_half + spacing + 0.005 + tex_width, center_y - ( font.Height( true_txt.c_str(), 1, font_size ) / 2.0f ), true_txt.c_str(),  1, font_size, color_r, color_g, color_b, l_opacity * opacity );
	font.Print( center_x - rel_width_half + spacing + 0.105 + tex_width, center_y - ( font.Height( false_txt.c_str(), 1, font_size ) / 2.0f ), false_txt.c_str(),  1, font_size, color_r, color_g, color_b, r_opacity * opacity );

	// draw tip
	if( selected && ( tip != "" ) )
		font.Print( 0.5 - ( font.Width( tip.c_str(), 1, 6 ) / 2.0f ), 0.90, tip.c_str(), 1, 6, 0.7, 0.7, 0.7, 0.9 * opacity );
}

void Toggle::Save()
{
	default_value = value;
	settings.Set( setting, value );
}

void Toggle::ResetValue()
{
	bool default_val;
	settings.Get( setting, default_val );
	SetValue( default_val );
}

bool Toggle::MouseOver( float x, float y )
{
	float min_x, min_y, max_x, max_y;
	min_x = center.GetXPercent() - ( rel_width / 2.0f );
	min_y = center.GetYPercent() - ( rel_height / 2.0f );
	max_x = center.GetXPercent() + ( rel_width / 2.0f );
	max_y = center.GetYPercent() + ( rel_height / 2.0f );

	return ( x > min_x ) && ( x < max_x ) && ( y > min_y ) && ( y < max_y );
}

string Toggle::MousePress( float x, float y )
{
	down = true;
	return "";
}

string Toggle::MouseRelease( float x, float y )
{
	down = false;
	return "";
}

void Toggle::Press()
{
	down = true;
}

void Toggle::Release()
{
	down = false;
}
