//	Vamos - a driving simulator
//  Copyright (C) 2001 Sam Varner
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <vamos/geometry/Two_Point.h>

Vamos_Geometry::Two_Point Vamos_Geometry::
operator + (Two_Point p1, Two_Point p2)
{
  return Two_Point (p1.x + p2.x, p1.y + p2.y);
}
Vamos_Geometry::Two_Point Vamos_Geometry::
operator + (Two_Point p, double scalar)
{
  return Two_Point (p.x + scalar, p.y + scalar);
}
Vamos_Geometry::Two_Point Vamos_Geometry::
operator + (double scalar, Two_Point p)
{
  return p + scalar;
}

Vamos_Geometry::Two_Point Vamos_Geometry::
operator - (Two_Point p1, Two_Point p2)
{
  return Two_Point (p1.x - p2.x, p1.y - p2.y);
}
Vamos_Geometry::Two_Point Vamos_Geometry::
operator - (Two_Point p, double scalar)
{
  return Two_Point (p.x - scalar, p.y - scalar);
}
Vamos_Geometry::Two_Point Vamos_Geometry::
operator - (double scalar, Two_Point p)
{
  return Two_Point (scalar - p.x, scalar - p.y);
}

Vamos_Geometry::Two_Point Vamos_Geometry::
operator * (Two_Point p1, Two_Point p2)
{
  return Two_Point (p1.x * p2.x, p1.y * p2.y);
}
Vamos_Geometry::Two_Point Vamos_Geometry::
operator * (Two_Point p, double scalar)
{
  return Two_Point (p.x * scalar, p.y * scalar);
}
Vamos_Geometry::Two_Point Vamos_Geometry::
operator * (double scalar, Two_Point p)
{
  return p * scalar;
}

Vamos_Geometry::Two_Point Vamos_Geometry::
operator / (Two_Point p1, Two_Point p2)
{
  return Two_Point (p1.x / p2.x, p1.y / p2.y);
}
Vamos_Geometry::Two_Point Vamos_Geometry::
operator / (double scalar, Two_Point p)
{
  return Two_Point (scalar / p.x, scalar / p.y);
}
Vamos_Geometry::Two_Point Vamos_Geometry::
operator / (Two_Point p, double scalar)
{
  return Two_Point (p.x / scalar, p.y / scalar);
}

// Stream Operators
std::ostream& Vamos_Geometry::
operator << (std::ostream& os, const Two_Point& point)
{
  os << "[ " << point.x << ", " << point.y << " ]";
  return os;
}

std::istream& Vamos_Geometry::
operator >> (std::istream& is, Two_Point& point)
{
  char delim;
  is >> delim >> point.x >> delim >> point.y >> delim;
  return is;
}
