# Simulation examples
In this directory you will find a set of examples of a number of simulations.

Run any of the examples with:

`vedo -ir example.py`


|    |    |
|:-------------:|:-----|
| [![aspring](https://user-images.githubusercontent.com/32848391/50738955-7e891800-11d9-11e9-85cd-02bd4f3f13ea.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/aspring.py)<br/> `aspring.py`          |  Simulation of a spring in a viscous medium. |
|    |    |
| [![brownian2d](https://user-images.githubusercontent.com/32848391/50738948-73ce8300-11d9-11e9-8ef6-fc4f64c4a9ce.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/brownian2D.py)<br/> `brownian2D.py` | Simulation of the Brownian motion of a large red particle in a swarm of small particles. <br/>The spheres collide elastically with themselves and with the walls of the box.|
|    |    |
| [![cell_colony](https://user-images.githubusercontent.com/32848391/50738950-73ce8300-11d9-11e9-9d9d-960a032e0aae.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/cell_colony.py)<br/> `cell_clony.py`    |  Simulation of three bacteria types that divide at a specified rate. As they divide they occupy more and more space. |
|    |    |
| [![doubleslit](https://user-images.githubusercontent.com/32848391/50738946-7335ec80-11d9-11e9-93db-f34f853ed759.jpg)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/doubleslit.py)<br/> `doubleslit.py` | Simulation of the classic _double slit experiment_. <br/>Any number of slits of any geometry can be described. Slit sources are placed on the plane shown as a thin grid. <br/>Can simulate the [_Arago spot_](https://en.wikipedia.org/wiki/Arago_spot), the bright point at the center of a circular object shadow.|
|    |    |
| [![gas](https://user-images.githubusercontent.com/32848391/50738954-7e891800-11d9-11e9-95aa-67c92ca6476b.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/gas.py)<br/> `gas.py`                      | A model of an ideal gas with hard-sphere collisions.|
|    |    |
| [![gyro1](https://user-images.githubusercontent.com/32848391/39766016-85c1c1d6-52e3-11e8-8575-d167b7ce5217.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/gyroscope1.py)<br/> `gyroscope1.py`      | Gyroscope hanging from a spring. |
|    |    |
| [![gyro2](https://user-images.githubusercontent.com/32848391/50738942-687b5780-11d9-11e9-97f0-72bbd63f7d6e.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/gyroscope2.py)<br/> `gyroscope2.py`      | Gyroscope sitting on a pedestal at one end. <br/>The analysis is made in terms of Lagrangian mechanics. |
|    |    |
| [![mpend](https://user-images.githubusercontent.com/32848391/50738892-db380300-11d8-11e9-807c-fb320c7b7917.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/multiple_pendulum.py)<br/> `multiple_pendulum.py` | Simulation of an elastic multiple pendulums with viscous friction. |
|    |    |
| [![hanoi](https://user-images.githubusercontent.com/32848391/56989284-58c1bd80-6b92-11e9-8f82-1ce95813f846.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/hanoi3d.py)<br/> `hanoi3d.py`            | Solve the Tower of Hanoi puzzle (contributed by [G. Jacquenot](https://github.com/Gjacquenot)). |
|    |    |
| [![airplanes](https://user-images.githubusercontent.com/32848391/57341963-b8910900-713c-11e9-898a-84b6d3712bce.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/airplanes.py)<br/> `airplanes.py`    | Two acrobatic planes casting shadows and leaving a trail. |
|    |    |
| [![ruth](https://user-images.githubusercontent.com/32848391/50738891-db380300-11d8-11e9-84c2-0f55be7228f1.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/particle_simulator.py)<br/> `particle_simulator.py` | Simulates interacting charged particles in 3D space. |
|    |    |
| [![tunneling1](https://vedo.embl.es/gifs/tunnelling2.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/tunnelling1.py)<br/> `tunnelling1.py`                                                      | Quantum Tunnelling effect using 4th order Runge-Kutta method with arbitrary potential shape. <br>The animation shows the evolution of a particle of relatively well defined momentum (hence undefined position) in a box hitting a potential barrier. The wave function is forced to be zero at the box walls. |
|    |    |
| [![tunneling2](https://user-images.githubusercontent.com/32848391/47751431-06aae880-dc92-11e8-9fcf-6659123edbfa.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/tunnelling2.py)<br/> `tunnelling2.py` |Quantum-tunnelling effect integrating the Schroedinger equation with 4th order Runge-Kutta method. The animation shows the evolution of a particle in a box hitting a sinusoidal potential barrier. |
|    |    |
| [![grayscott](https://user-images.githubusercontent.com/32848391/59788744-aaeaa980-92cc-11e9-825d-58da26ca21ff.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/gray_scott.ipynb)<br/> `gray_scott.ipynb`       | A GPU simulation of system of reaction-diffusion between two species. |
|    |    |
| [![wave](https://user-images.githubusercontent.com/32848391/50738956-7e891800-11d9-11e9-92d7-fa109b1b8551.gif)](https://github.com/marcomusy/vedo/blob/master/vedo/examples/simulations/wave_equation.py)<br/> `wave_equation.py` | Simulate a collection of discrete coupled oscillators. We use this as a model of a vibrating string and compare two methods of integration: Euler and Runge-Kutta4.|
|    |    |
| [![pianoplayer](https://user-images.githubusercontent.com/32848391/44957809-b2c09500-aed6-11e8-9dc5-c2e52b632f94.gif)](https://github.com/marcomusy/pianoplayer) | Finding and animating the optimal fingering to play a piano score with<br />[`pianoplayer 2.0`](https://github.com/marcomusy/pianoplayer)|
