/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.Hashtable;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.messaging.MessageHandler;
import org.xml.sax.Attributes;

public class PropertyListBuilder {
    private static final String FONTSIZEATTR = "font-size";
    private Hashtable propertyListTable = new Hashtable();
    private Hashtable elementTable = new Hashtable();

    public void addElementList(String string, Hashtable hashtable) {
        this.elementTable.put(string, hashtable);
    }

    public void addList(Hashtable hashtable) {
        this.propertyListTable = hashtable;
    }

    public Property computeProperty(PropertyList propertyList, String string, String string2, String string3) {
        Property property = null;
        Property.Maker maker = this.findMaker(string, string2, string3);
        if (maker != null) {
            try {
                property = maker.compute(propertyList);
            }
            catch (FOPException fOPException) {
                MessageHandler.errorln("ERROR: exception occurred while computing value of property '" + string3 + "': " + fOPException.getMessage());
            }
        } else {
            MessageHandler.errorln("WARNING: property " + string3 + " ignored");
        }
        return property;
    }

    protected Property.Maker findMaker(String string, String string2, String string3) {
        return this.findMaker((Hashtable)this.elementTable.get(string2), string3);
    }

    private Property.Maker findMaker(Hashtable hashtable, String string) {
        Property.Maker maker = null;
        if (hashtable != null) {
            maker = (Property.Maker)hashtable.get(string);
        }
        if (maker == null) {
            maker = (Property.Maker)this.propertyListTable.get(string);
        }
        return maker;
    }

    public Property getSubpropValue(String string, String string2, String string3, Property property, String string4) {
        Property.Maker maker = this.findMaker(string, string2, string3);
        if (maker != null) {
            return maker.getSubpropValue(property, string4);
        }
        return null;
    }

    public boolean isCorrespondingForced(PropertyList propertyList, String string, String string2, String string3) {
        Property.Maker maker = this.findMaker(string, string2, string3);
        if (maker != null) {
            return maker.isCorrespondingForced(propertyList);
        }
        MessageHandler.errorln("WARNING: no Maker for " + string3);
        return false;
    }

    public boolean isInherited(String string, String string2, String string3) {
        Property.Maker maker = this.findMaker(string, string2, string3);
        boolean bl = maker != null ? maker.isInherited() : true;
        return bl;
    }

    public PropertyList makeList(String string, Attributes attributes, PropertyList propertyList, FObj fObj) throws FOPException {
        int n = string.indexOf("^");
        String string2 = "http://www.w3.org/TR/1999/XSL/Format";
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        PropertyList propertyList2 = null;
        if (propertyList != null && string2.equals(propertyList.getNameSpace())) {
            propertyList2 = propertyList;
        }
        PropertyList propertyList3 = new PropertyList(propertyList2, string2, string.substring(n + 1));
        propertyList3.setBuilder(this);
        Hashtable hashtable = (Hashtable)this.elementTable.get(string.substring(n + 1));
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(' ');
        String string3 = attributes.getValue(FONTSIZEATTR);
        if (string3 != null) {
            Property.Maker maker = this.findMaker(hashtable, FONTSIZEATTR);
            if (maker != null) {
                try {
                    propertyList3.put(FONTSIZEATTR, maker.make(propertyList3, string3, fObj));
                }
                catch (FOPException fOPException) {}
            }
            stringBuffer.append("font-size ");
        }
        int n2 = 0;
        while (n2 < attributes.getLength()) {
            block18: {
                Property property;
                String string4;
                String string5;
                String string6;
                block20: {
                    block19: {
                        string6 = attributes.getQName(n2);
                        int n3 = string6.indexOf(46);
                        string5 = string6;
                        string4 = null;
                        property = null;
                        if (n3 <= -1) break block19;
                        string5 = string6.substring(0, n3);
                        string4 = string6.substring(n3 + 1);
                        break block20;
                    }
                    if (stringBuffer.toString().indexOf(String.valueOf(' ') + string5 + ' ') != -1) break block18;
                }
                Property.Maker maker = this.findMaker(hashtable, string5);
                if (maker != null) {
                    try {
                        if (string4 != null) {
                            String string7;
                            Property property2 = propertyList3.getExplicit(string5);
                            if (property2 == null && (string7 = attributes.getValue(string5)) != null) {
                                property2 = maker.make(propertyList3, string7, fObj);
                                stringBuffer.append(String.valueOf(string5) + ' ');
                            }
                            property = maker.make(property2, string4, propertyList3, attributes.getValue(n2), fObj);
                        } else {
                            property = maker.make(propertyList3, attributes.getValue(n2), fObj);
                        }
                        if (property != null) {
                            propertyList3.put(string5, property);
                        }
                    }
                    catch (FOPException fOPException) {}
                } else if (!string6.startsWith("xmlns")) {
                    MessageHandler.errorln("WARNING: property '" + string6 + "' ignored");
                }
            }
            ++n2;
        }
        return propertyList3;
    }

    public Property makeProperty(PropertyList propertyList, String string, String string2, String string3) throws FOPException {
        Property property = null;
        Property.Maker maker = this.findMaker(string, string2, string3);
        if (maker != null) {
            property = maker.make(propertyList);
        } else {
            MessageHandler.errorln("WARNING: property " + string3 + " ignored");
        }
        return property;
    }
}

