/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;

public class TableBody
extends FObj {
    FontState fs;
    int spaceBefore;
    int spaceAfter;
    ColorType backgroundColor;
    ColorType borderColor;
    int borderWidth;
    int borderStyle;
    String id;
    Vector columns;
    AreaContainer areaContainer;

    public TableBody(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:table-body";
    }

    public int getHeight() {
        return this.areaContainer.getHeight() + this.spaceBefore + this.spaceAfter;
    }

    public int getYPosition() {
        return this.areaContainer.getCurrentYPosition();
    }

    public Status layout(Area area) throws FOPException {
        int n;
        int n2;
        Object object;
        Vector<String> vector;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            vector = this.properties.get("font-family").getString();
            String string = this.properties.get("font-style").getString();
            object = this.properties.get("font-weight").getString();
            n2 = this.properties.get("font-size").getLength().mvalue();
            n = this.properties.get("font-variant").getEnum();
            this.fs = new FontState(area.getFontInfo(), (String)((Object)vector), string, (String)object, n2, n);
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.backgroundColor = this.properties.get("background-color").getColorType();
            this.borderColor = this.properties.get("border-color").getColorType();
            this.borderWidth = this.properties.get("border-width").getLength().mvalue();
            this.borderStyle = this.properties.get("border-style").getEnum();
            this.id = this.properties.get("id").getString();
            area.getIDReferences().createID(this.id);
            if (area instanceof BlockArea) {
                area.end();
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.increaseHeight(this.spaceBefore);
        }
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
        }
        this.areaContainer = new AreaContainer(this.fs, -area.borderWidthLeft, -area.borderWidthTop + area.getHeight(), area.getAllocationWidth(), area.spaceLeft(), 2);
        this.areaContainer.foCreator = this;
        this.areaContainer.setPage(area.getPage());
        this.areaContainer.setBackgroundColor(this.backgroundColor);
        this.areaContainer.setBorderStyle(this.borderStyle, this.borderStyle, this.borderStyle, this.borderStyle);
        this.areaContainer.setBorderWidth(this.borderWidth, this.borderWidth, this.borderWidth, this.borderWidth);
        this.areaContainer.setBorderColor(this.borderColor, this.borderColor, this.borderColor, this.borderColor);
        this.areaContainer.start();
        this.areaContainer.setAbsoluteHeight(area.getAbsoluteHeight());
        this.areaContainer.setIDReferences(area.getIDReferences());
        vector = new Vector();
        int n3 = this.children.size();
        object = null;
        n2 = 1;
        n = this.marker;
        while (n < n3) {
            Object e = this.children.elementAt(n);
            if (!(e instanceof TableRow)) {
                throw new FOPException("Currently only Table Rows are supported in table body, header and footer");
            }
            TableRow tableRow = (TableRow)e;
            tableRow.setColumns(this.columns);
            tableRow.doSetup(this.areaContainer);
            if (tableRow.getKeepWithPrevious().getType() != "KEEP_WITH_AUTO" && object != null && vector.indexOf(object) == -1) {
                vector.addElement((String)object);
            } else if (n2 != 0 && vector.size() > 0) {
                vector = new Vector<String>();
            }
            Status status = tableRow.layout(this.areaContainer);
            if (status.isIncomplete()) {
                if (vector.size() > 0) {
                    tableRow.removeLayout(this.areaContainer);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        TableRow tableRow2 = (TableRow)enumeration.nextElement();
                        tableRow2.removeLayout(this.areaContainer);
                        --n;
                    }
                    if (n == 0) {
                        this.resetMarker();
                        return new Status(2);
                    }
                }
                this.marker = n;
                if (n != 0 && status.getCode() == 2) {
                    status = new Status(3);
                }
                if (n < this.widows && n3 >= this.widows) {
                    this.resetMarker();
                    return new Status(2);
                }
                if (n3 <= this.orphans) {
                    this.resetMarker();
                    return new Status(2);
                }
                if (n3 - n < this.orphans && n3 >= this.orphans) {
                    int n4 = n;
                    while (n4 > n3 - this.orphans - 1) {
                        tableRow = (TableRow)this.children.elementAt(n4);
                        tableRow.removeLayout(this.areaContainer);
                        --n;
                        --n4;
                    }
                    if (n < this.widows && n3 >= this.widows) {
                        this.resetMarker();
                        return new Status(2);
                    }
                    this.marker = n;
                    area.addChild(this.areaContainer);
                    area.increaseHeight(this.areaContainer.getHeight());
                    area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                    return new Status(3);
                }
                if (n != 0 || this.areaContainer.getContentHeight() > 0) {
                    area.addChild(this.areaContainer);
                    area.increaseHeight(this.areaContainer.getHeight());
                    area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
                }
                return status;
            }
            if (status.getCode() == 8) {
                vector.addElement((String)((Object)tableRow));
                n2 = 0;
            } else {
                n2 = 1;
            }
            object = tableRow;
            ++n;
        }
        area.addChild(this.areaContainer);
        this.areaContainer.end();
        area.increaseHeight(this.areaContainer.getHeight());
        area.setAbsoluteHeight(this.areaContainer.getAbsoluteHeight());
        if (this.spaceAfter != 0) {
            area.increaseHeight(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void removeLayout(Area area) {
        area.removeChild(this.areaContainer);
        if (this.spaceBefore != 0) {
            area.increaseHeight(-this.spaceBefore);
        }
        if (this.spaceAfter != 0) {
            area.increaseHeight(-this.spaceAfter);
        }
        this.resetMarker();
    }

    public void setColumns(Vector vector) {
        this.columns = vector;
    }

    public void setYPosition(int n) {
        this.areaContainer.setYPosition(n);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new TableBody(fObj, propertyList);
        }
    }
}

