/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.IllegalDataException;
import org.jdom.IllegalNameException;
import org.jdom.Verifier;
import org.jdom.output.XMLOutputter;

public class DocType
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: DocType.java,v $ $Revision: 1.24 $ $Date: 2003/04/08 04:14:49 $ $Name: jdom_1_0_b9_rc2 $";
    protected String elementName;
    protected String publicID;
    protected String systemID;
    protected Document document;
    protected String internalSubset;

    protected DocType() {
    }

    public DocType(String elementName) {
        this(elementName, null, null);
    }

    public DocType(String elementName, String systemID) {
        this(elementName, null, systemID);
    }

    public DocType(String elementName, String publicID, String systemID) {
        this.setElementName(elementName);
        this.setPublicID(publicID);
        this.setSystemID(systemID);
    }

    public Object clone() {
        DocType docType = null;
        try {
            docType = (DocType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        docType.document = null;
        return docType;
    }

    public final boolean equals(Object ob) {
        return this == ob;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getInternalSubset() {
        return this.internalSubset;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected DocType setDocument(Document document) {
        this.document = document;
        return this;
    }

    public DocType setElementName(String elementName) {
        String reason = Verifier.checkXMLName(elementName);
        if (reason != null) {
            throw new IllegalNameException(elementName, "DocType", reason);
        }
        this.elementName = elementName;
        return this;
    }

    public void setInternalSubset(String newData) {
        this.internalSubset = newData;
    }

    public DocType setPublicID(String publicID) {
        String reason = Verifier.checkPublicID(publicID);
        if (reason != null) {
            throw new IllegalDataException(publicID, "DocType", reason);
        }
        this.publicID = publicID;
        return this;
    }

    public DocType setSystemID(String systemID) {
        String reason = Verifier.checkSystemLiteral(systemID);
        if (reason != null) {
            throw new IllegalDataException(systemID, "DocType", reason);
        }
        this.systemID = systemID;
        return this;
    }

    private boolean stringEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    public String toString() {
        return "[DocType: " + new XMLOutputter().outputString(this) + "]";
    }
}

