/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactInfo;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.LatestStrategy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.repository.AbstractRepository;
import fr.jayasoft.ivy.repository.Repository;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.resolver.AbstractResourceResolver;
import fr.jayasoft.ivy.resolver.ResolvedResource;
import fr.jayasoft.ivy.resolver.ResolverHelper;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RepositoryResolver
extends AbstractResourceResolver {
    private Repository _repository;
    private Boolean _alwaysCheckExactRevision = null;

    public Repository getRepository() {
        return this._repository;
    }

    public void setRepository(Repository repository) {
        this._repository = repository;
    }

    public void setName(String name) {
        super.setName(name);
        if (this._repository instanceof AbstractRepository) {
            ((AbstractRepository)this._repository).setName(name);
        }
    }

    protected ResolvedResource findResourceUsingPattern(ModuleRevisionId mrid, String pattern, String artifact, String type, String ext, Date date) {
        return RepositoryResolver.findResourceUsingPattern(this.getName(), this.getRepository(), this.getLatestStrategy(), mrid, pattern, artifact, type, ext, date, this.isAlwaysCheckExactRevision());
    }

    public static ResolvedResource findResourceUsingPattern(String name, Repository repository, LatestStrategy strategy, ModuleRevisionId mrid, String pattern, String artifact, String type, String ext, Date date) {
        return RepositoryResolver.findResourceUsingPattern(name, repository, strategy, mrid, pattern, artifact, type, ext, date, true);
    }

    public static ResolvedResource findResourceUsingPattern(String name, Repository repository, LatestStrategy strategy, ModuleRevisionId mrid, String pattern, String artifact, String type, String ext, Date date, boolean alwaysCheckExactRevision) {
        try {
            if (mrid.isExactRevision() || alwaysCheckExactRevision) {
                String resourceName = IvyPatternHelper.substitute(pattern, mrid, artifact, type, ext);
                Message.debug("\t trying " + resourceName);
                Resource res = repository.getResource(resourceName);
                long start = System.currentTimeMillis();
                boolean reachable = res.exists();
                if (reachable) {
                    return new ResolvedResource(res, mrid.getRevision());
                }
                if (!mrid.isExactRevision()) {
                    return RepositoryResolver.findDynamicResourceUsingPattern(name, repository, strategy, mrid, pattern, artifact, type, ext, date);
                }
                Message.debug("\t" + name + ": resource not reachable for " + mrid + ": res=" + res);
                return null;
            }
            return RepositoryResolver.findDynamicResourceUsingPattern(name, repository, strategy, mrid, pattern, artifact, type, ext, date);
        }
        catch (Exception ex) {
            Message.debug("\t" + name + ": unable to get resource for " + mrid + ": res=" + IvyPatternHelper.substitute(pattern, mrid, artifact, type, ext) + ": " + ex.getMessage());
            return null;
        }
    }

    private static ResolvedResource findDynamicResourceUsingPattern(String name, Repository repository, LatestStrategy strategy, ModuleRevisionId mrid, String pattern, String artifact, String type, String ext, Date date) {
        ArtifactInfo found;
        ArtifactInfo[] rress = ResolverHelper.findAll(repository, mrid, pattern, artifact, type, ext);
        if (rress == null) {
            Message.debug("\t" + name + ": unable to list resources for " + mrid + ": pattern=" + pattern);
            return null;
        }
        for (int i = 0; i < rress.length; ++i) {
            Message.debug("\t" + name + ": found " + rress[i]);
        }
        if (rress.length == 1) {
            Message.debug("only one resource found: no need to use latest strategy");
            found = rress[0];
        } else {
            found = (ResolvedResource)strategy.findLatest(rress, date);
        }
        if (found == null) {
            Message.debug("\t" + name + ": no resource found for " + mrid + ": pattern=" + pattern);
        } else if (!((ResolvedResource)found).getResource().exists()) {
            Message.debug("\t" + name + ": resource not reachable for " + mrid + ": res=" + ((ResolvedResource)found).getResource());
            return null;
        }
        return found;
    }

    protected ResolvedResource[] findAll(ModuleRevisionId mrid, String pattern, String artifact, String type, String ext) {
        return ResolverHelper.findAll(this._repository, mrid, pattern, artifact, type, ext);
    }

    protected long get(Resource resource, File ivyTempFile) throws IOException {
        this._repository.get(resource.getName(), ivyTempFile);
        return ivyTempFile.length();
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        String destPattern = "ivy".equals(artifact.getType()) && !this.getIvyPatterns().isEmpty() ? (String)this.getIvyPatterns().get(0) : (String)this.getArtifactPatterns().get(0);
        String dest = IvyPatternHelper.substitute(destPattern, artifact);
        this._repository.put(src, dest, overwrite);
        Message.info("\tpublished " + artifact.getName() + " to " + dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache) {
        try {
            this._repository.addTransferListener(ivy);
            DownloadReport downloadReport = super.download(artifacts, ivy, cache);
            Object var6_5 = null;
            if (ivy != null) {
                this._repository.removeTransferListener(ivy);
            }
            return downloadReport;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (ivy == null) break block3;
                this._repository.removeTransferListener(ivy);
            }
            throw throwable;
        }
    }

    protected void findTokenValues(Collection names, List patterns, Map tokenValues, String token) {
        Iterator iter = patterns.iterator();
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            String partiallyResolvedPattern = IvyPatternHelper.substituteTokens(pattern, tokenValues);
            String[] values = ResolverHelper.listTokenValues(this._repository, partiallyResolvedPattern, token);
            if (values == null) continue;
            names.addAll(Arrays.asList(values));
        }
    }

    public String getTypeName() {
        return "repository";
    }

    public void dumpConfig() {
        super.dumpConfig();
        Message.debug("\t\trepository: " + this.getRepository());
    }

    public void setIvy(Ivy ivy) {
        super.setIvy(ivy);
        if (ivy != null && this._alwaysCheckExactRevision == null) {
            this._alwaysCheckExactRevision = Boolean.valueOf(ivy.getVariable("ivy.default.always.check.exact.revision"));
        }
    }

    public boolean isAlwaysCheckExactRevision() {
        return this._alwaysCheckExactRevision == null ? true : this._alwaysCheckExactRevision;
    }

    public void setAlwaysCheckExactRevision(boolean alwaysCheckExactRevision) {
        this._alwaysCheckExactRevision = alwaysCheckExactRevision;
    }
}

