# $Id: verbiste-0.1.spec.in,v 1.27 2010/08/12 19:46:18 sarrazip Exp $

# RPM .spec file for Verbiste

# Release number can be specified with rpm --define 'rel SOMETHING' ...
# If no such --define is used, the release number is 1.
#
# Source archive's extension can be specified with rpm --define 'srcext .foo'
# where .foo is the source archive's actual extension.
# To compile an RPM from a .bz2 source archive, give the command
#   rpmbuild -ta --define 'srcext .bz2' verbiste-0.1.32.tar.bz2
#
%if %{?rel:0}%{!?rel:1}
%define rel 1
%endif
%if %{?srcext:0}%{!?srcext:1}
%define srcext .gz
%endif

# TeX command as installed on a Fedora system by the texlive package.
%define texhash /usr/bin/texhash

%{expand:%%define ismdk %(if [ %_vendor = "MandrakeSoft" ]; then echo 1; else echo 0; fi)}

Summary: French conjugation system
Name: verbiste
Version: 0.1.32
Release: %{rel}
License: GPL
Group: Applications/Text
Source: %{name}-%{version}.tar%{srcext}
URL: http://sarrazip.com/dev/verbiste.html
Prefix: /usr
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

BuildRequires: libxml2-devel >= 2.4.0, gnome-panel-devel, gettext
Requires: libxml2 >= 2.4.0, perl, perl-XML-Parser

%description
This package contains a database of French conjugation templates
and a list of more than 6000 regular and irregular French verbs
with their corresponding template.  One can obtain the complete
conjugation for a verb from its infinitive form, and obtain the mode,
tense and person from a conjugated verb.  The library comes with two
command-line tools named french-conjugator and french-deconjugator
(see their manual pages).

%description -l fr
Ce paquet contient une base de données de modèles de conjugaison
du français et une liste de plus de 6000 verbes réguliers et
irréguliers avec leur modèle correspondant.  On peut obtenir
la conjugaison complète pour un verbe à partir de sa forme
infinitive, ou encore obtenir le mode, le temps et la personne à
partir d'un verbe conjugué.  La librairie vient avec deux outils à
ligne de commande nommés french-conjugator et french-deconjugator
(voir leurs pages de manuel).


%package devel
Summary: C++ development files for the Verbiste library
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: libxml2-devel >= 2.4.0

%description devel
C++ development files for the Verbiste library.

%description -l fr devel
Fichiers de développement C++ development pour la librairie Verbiste.

%package gnome
Summary: GNOME Panel applet and application based on Verbiste
Group: Applications/Text
Requires: %{name} = %{version}-%{release}

BuildRequires: gnome-panel-devel >= 2.0.0
Requires: gnome-panel >= 2.0.0

%if %ismdk

BuildRequires: libpanel-applet-2_0-devel
BuildRequires: libglade2.0_0-devel
BuildRequires: libgnomeui2-devel
Requires: libgnomeui2

%else

BuildRequires: libgnomeui-devel >= 2.0.0
Requires: libgnomeui >= 2.0.0

%endif

%description gnome
GNOME Panel applet and application based on Verbiste.

%description -l fr gnome
Applet et application Verbiste pour le panneau GNOME.

%prep
%setup -q

%build
%configure --with-gnome-app --with-gnome-applet --disable-maintainer-mode --without-examples
make %{?_smp_mflags}

%install
rm -fR "$RPM_BUILD_ROOT"
make install DESTDIR="$RPM_BUILD_ROOT" INSTALL="%{__install} -p"
# This file gets created on x86_64 for no apparent reason.
# It's owned by glibc-common.
rm -f "$RPM_BUILD_ROOT%{_datadir}/locale/locale.alias"

%clean
rm -fR $RPM_BUILD_ROOT

%post
/sbin/ldconfig

%post gnome
# Tell TeX to rebuild its database of installed files:
if test -x %{texhash}; then %{texhash}; fi

%postun
/sbin/ldconfig

%postun gnome
# Tell TeX to rebuild its database of installed files:
if test -x %{texhash}; then %{texhash}; fi

%files
%defattr(-, root, root)
%{_libdir}/lib*.so.*
%{_mandir}/man*/*.*
%{_mandir}/*/man*/*.*
%{_bindir}/french-*
%{_datadir}/%{name}-*
%doc %{_defaultdocdir}/*

%files devel
%defattr(-, root, root)
%{_includedir}/*
%{_libdir}/lib*.so
%{_prefix}/lib/lib*.la
# (sic) See Fedora documentation re: "More RPM Building Hints"
%{_libdir}/pkgconfig/*

%files gnome
%defattr(-, root, root)
%{_bindir}/%{name}
%{_libexecdir}/*
%{_libdir}/bonobo/servers/*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/locale/*/LC_MESSAGES/%{name}.mo
%{_datadir}/pixmaps/*
%{_datadir}/texmf/tex/latex/*
