/*  $Id: main-window.h,v 1.6 2004/02/26 03:12:42 sarrazip Exp $
    main-window.h - Input and conjugation window

    verbiste - French conjugation system
    Copyright (C) 2003 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#ifndef _H_main_window
#define _H_main_window

#include <gtk/gtkentry.h>
#include <gdk/gdkkeysyms.h>

#include <string>
#include <stdexcept>


extern gboolean hideOnDelete;


void showAbout();


/**
    Initialize the verb dictionary.
    @throws	std::logic_error	object representing a failure to
					initialize the dictionary and read
					its knowledge base
*/
void initVerbDict() throw(std::logic_error);


/**
    Shows a GNOME error dialog and waits for the user to close it.
    @param	msg		UTF-8 error message to display
*/
void showErrorDialog(const std::string &msg);


/**
    Show a window with the full conjugation of the given verb.
    @param	utf8UserText	UTF-8 string of the conjugated verb
				(upper-case is allowed)
*/
void processText(const std::string &utf8UserText);


#endif  /* _H_main_window */
