/*
                              File Browser
 */

#ifndef FB_H
#define FB_H

#include <sys/types.h>
#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	File browser file extension type structure:
 */
typedef struct {

	gchar *ext;	/* Extension(s), space separated list. */
	gchar *name;	/* Description of type. */

} fb_type_struct;


extern gint FileBrowserInit(void);
extern void FileBrowserSetTransientFor(GtkWidget *w);
extern gbool FileBrowserIsQuery(void);
extern void FileBrowserBreakQuery(void);
extern gbool FileBrowserGetResponse(
        const gchar *title,
        const gchar *ok_label, const gchar *cancel_label,
        const gchar *path,
        fb_type_struct **type, gint total_types,
        gchar ***path_rtn, gint *path_total_rtns,
        fb_type_struct **type_rtn
);
extern void FileBrowserMap(void);
extern void FileBrowserUnmap(void);
extern void FileBrowserShutdown(void);

extern gint FileBrowserTypeListNew(
        fb_type_struct ***list, gint *total,
        const gchar *ext,	/* Space separated list of extensions. */
        const gchar *name	/* Descriptive name. */
);
extern void FileBrowserDeleteTypeList(
	fb_type_struct **t, gint total
);


#endif	/* FB_H */
