/*
			    Scratch Pad Callbacks
 */

#ifndef SCRATCHPADCB_H
#define SCRATCHPADCB_H

#include <sys/types.h>
#include <gtk/gtk.h>

#include "scratchpad.h"


extern void ScratchPadRowDeleteCB(gpointer data);
extern void ScratchPadTargetComboTextInsertCB(
	GtkEditable *editable,
	const gchar *text, gint length, gint *position,
	gpointer data
);
extern void ScratchPadTargetComboButtonEnterCB(
	GtkButton *button, gpointer data
);
extern gint ScratchPadEventCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern gint ScratchPadMenuMapCB(
	GtkWidget *widget, GdkEventButton *button, gpointer data
);

extern void ScratchPadDestroyCB(GtkObject *object, gpointer data);
extern gint ScratchPadCloseCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
extern void ScratchPadCloseButtonCB(
	GtkWidget *widget, gpointer data
);

extern gint ScratchPadMenuItemEnterCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);


extern void ScratchPadInsertCB(GtkWidget *widget, gpointer data);
extern void ScratchPadEditCB(GtkWidget *widget, gpointer data);
extern void ScratchPadDeleteCB(GtkWidget *widget, gpointer data);

extern void ScratchPadSetVertexCB(GtkWidget *widget, gpointer data);
extern void ScratchPadSetNormalCB(GtkWidget *widget, gpointer data);
extern void ScratchPadSetTexCoordCB(GtkWidget *widget, gpointer data);
extern void ScratchPadSetAllCB(GtkWidget *widget, gpointer data);

extern void ScratchPadCListSelectCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);      
extern void ScratchPadCListUnselectCB(
	GtkCList *clist, gint row, gint column, GdkEvent *event,
	gpointer data
);

extern void ScratchPadTextChangeCB(
	GtkEditable *editable, gpointer data
);


#endif	/* SCRATCHPADCB_H */
