/*
**  This file is part of Vidalia, and is subject to the license terms in the
**  LICENSE file, found in the top level directory of this distribution. If you
**  did not receive the LICENSE file with this file, you may obtain it from the
**  Vidalia source package distributed by the Vidalia Project at
**  http://www.vidalia-project.net/. No part of Vidalia, including this file,
**  may be copied, modified, propagated, or distributed except according to the
**  terms described in the LICENSE file.
*/

/*
** \file StreamItem.cpp
** \version $Id: StreamItem.cpp 3735 2009-04-28 20:28:01Z edmanm $
** \brief Item representing a stream through Tor and its status
*/

#include "StreamItem.h"
#include "CircuitListWidget.h"


/** Constructor */
StreamItem::StreamItem(const Stream &stream)
{
  /* Update the status and target */
  update(stream);
}

/** Updates the status of this stream item. */
void
StreamItem::update(const Stream &stream)
{
  _stream = stream;
  setText(CircuitListWidget::ConnectionColumn, stream.target());
  setToolTip(CircuitListWidget::ConnectionColumn, stream.target());
  setText(CircuitListWidget::StatusColumn, stream.statusString());
  setToolTip(CircuitListWidget::StatusColumn, stream.statusString());
}

