# -*- coding: UTF8 -*-

###
# This file is part of VideoManager.
#
# VideoManagerCommon is the legal property of Erwan Briand <xbright2005@gmail.com>
# Copyright (c) 2006 Erwan Briand
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

# VideoManagerCommon.py utilise un module de gestion d'erreurs écrit en Python
# Ce module est sous GPL et vous pouvez vous aussi l'utiliser !
# Plus d'informations : http://www.codingteam.net/programmationvoir-25.html

###
#
# Traduction

try:
	import ConfigParser,sys,commands
	config = ConfigParser.ConfigParser()
	config.read("/home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg")
	try:
		LOCALE = config.get("divers","locale")
	except:
		LOCALE = "fr"
except:
	print "Loading translation file...\t\t\t[failed]\nModules needed: ConfigParser, sys, commands"
	sys.exit()
###
#
# Début de la gestion des erreurs

try:
	import sys,os
	from xml2translate import xml2translate

	translation = xml2translate(os.path.dirname(os.path.realpath(__file__))+"/lang/translate-"+LOCALE+".xml")
except:
	print "Loading translation file...\t\t\t[failed]\nModules needed: sys, os, xml2translate"
	sys.exit()

try:
	from ErrorManager import Manage
	GestionErreur = Manage()
	GestionErreur.SetNomFichier("VideoManagerCommon.py")
	if LOCALE == "fr":
		GestionErreur.SetLocale("fr")
	else:
		GestionErreur.SetLocale("other")
except:
	print translation.GetTranslationValueByEntry("txt1")
	sys.exit()

try:
	import traceback
except:
	print translation.GetTranslationValueByEntry("txt1")
	sys.exit()

def Myexcepthook(type, value, tb):
	total = ""
        lines=traceback.format_exception(type, value, tb)
	for i in range(len(lines)):
		total = total + lines[i]
	GestionErreur.Alerte(2,translation.GetTranslationValueByEntry("txt2")+"\n\n---------------------Traceback lines-----------------------\n"+total+"\n---------------------------------------------------------------",0)
        sys.exit()

sys.excepthook=Myexcepthook

# Fin de la gestion des erreurs
#
###

try:
	import amazon
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","amazon",1),0)
	sys.exit()

try:
	import sqlite
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","sqlite",1),0)
	sys.exit()

try:
	import gtk
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","gtk",1),0)
	sys.exit()

try:
	import glob
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","glob",1),0)
	sys.exit()

try:
	import urllib
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","urllib",1),0)
	sys.exit()
try:
	import threading
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","threading",1),0)
	sys.exit()

try:
	import time
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","time",1),0)
	sys.exit()

try:
 	import re
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","re",1),0)
	sys.exit()

try:
	import webbrowser
except:
	GestionErreur.Alerte(1,translation.GetTranslationValueByEntry("txt3").replace("%s","webbrowser",1),0)
	sys.exit()

### Classe de Tepache : GLADE (interface utilisateur)
from SimpleGladeApp import SimpleGladeApp
from SimpleGladeApp import bindtextdomain

app_name = "VideoManager"
app_version = "0.5"
glade_dir = ""
locale_dir = ""
bindtextdomain(app_name, locale_dir)

amazon.setLicense("0T1CC8DE1HQGRWEMBG82")

#######Classes interface (fronthend)

class Window5(SimpleGladeApp):

    def __init__(self, path="gui.glade",
                 root="window5",
                 domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)
	global window5BIS
	window5BIS = self
	#####
	##Traduction des textes GLADE
	#####
	self.window5.set_title(translation.GetTranslationValueByEntry("txt72"))
	self.label124.set_markup(translation.GetTranslationValueByEntry("txt73"))
	self.label125.set_text(translation.GetTranslationValueByEntry("txt39"))
	self.label126.set_text(translation.GetTranslationValueByEntry("txt25"))
	self.label127.set_text(translation.GetTranslationValueByEntry("txt41"))
	self.label128.set_text(translation.GetTranslationValueByEntry("txt24"))
	self.label141.set_markup("<b>"+translation.GetTranslationValueByEntry("txt40")+"</b>")
	self.label140.set_text(translation.GetTranslationValueByEntry("txt74"))
	#####

    def on_button29_clicked(self, widget, *args):
	film = window5BIS.entry12.get_text().replace(' ','+',50)
	htmlSource = urllib.urlopen("http://www.allocine.fr/recherche/?motcle="+film+"&f=3&rub=1").read(200000)
	test = '<h4><a href="'
	if test in htmlSource:
		i = 0
		for link in re.findall('<h4><a href="(.*?)" class="link1">',htmlSource):
			i = i + 1
		if i == 1:
			Window7().ParseAlloCine(link)
		else:
			window7 = Window7()
			for link in re.findall('<h4><a href="(.*?)" class="link1">',htmlSource):
				nam = [ link ]
				window7.clist5.append(nam)
			window7.clist5.select_row(0,0)
	else:
		msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt20"))
		msgbox.run()
		msgbox.destroy()

    #-- Window5.on_button24_clicked {
    def on_button24_clicked(self, widget, *args):
	nom_film = self.entry12.get_text()
	realisateur_film = self.entry13.get_text()
	annee_film = self.entry14.get_text()
	genre_film = self.combobox4.get_active_text()

	if nom_film == "":
		self.ErreurChamp()
		return False
	if realisateur_film == "":
		self.ErreurChamp()
		return False
	if annee_film == "":
		self.ErreurChamp()
		return False
	if genre_film == "":
		self.ErreurChamp()
		return False

	OptionsHeritee = Options()
	test = OptionsHeritee.ObtenirLaConfiguration(5)
	if test == "oui":
		txt = OptionsHeritee.ObtenirLaConfiguration(2)
		pythonBooks = amazon.searchByKeyword(nom_film, product_line=txt)
		if pythonBooks != "noresult":
			url = pythonBooks[0].URL
			conf = OptionsHeritee.ObtenirLaConfiguration(3)
			if conf == "Moyenne":
				res = urllib.urlretrieve(pythonBooks[0].ImageUrlMedium, "/home/"+commands.getoutput("whoami")+"/.videomanager/covers/"+nom_film+"_"+conf+".jpg")
			if conf == "Grande":
				res = urllib.urlretrieve(pythonBooks[0].ImageUrlLarge, "/home/"+commands.getoutput("whoami")+"/.videomanager/covers/"+nom_film+"_"+conf+".jpg")
			if conf == "Petite":
				res = urllib.urlretrieve(pythonBooks[0].ImageUrlSmall, "/home/"+commands.getoutput("whoami")+"/.videomanager/covers/"+nom_film+"_"+conf+".jpg")
			imageto = "/home/"+commands.getoutput("whoami")+"/.videomanager/covers/"+nom_film+"_"+conf+".jpg"
		else:
			imageto = ""
	else:
		imageto = ""
	
	buffertexte = self.textview4.get_buffer()
	texte = buffertexte.get_text(buffertexte.get_start_iter(),buffertexte.get_end_iter())

	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	cur.execute("insert into films (nom,realisateur,annee,genre,note,fichier,url,imagemedium) values (%s,%s,%s,%s,%s,%s,%s,%s)", (nom_film, realisateur_film, annee_film, genre_film, "0", self.filename, texte, imageto))
	cx.commit()
	cur.close()
	cx.close()

	self.window5.destroy()
    #-- Window5.on_button24_clicked }

    def ErreurChamp(self):
	msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt21"))
	msgbox.run()
	msgbox.destroy()

class Window6(SimpleGladeApp):

    def __init__(self, path="gui.glade",
                 root="window6",
                 domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)
	#####
	##Traduction des textes GLADE
	#####
	self.window6.set_title(translation.GetTranslationValueByEntry("txt75"))
	self.label132.set_text(translation.GetTranslationValueByEntry("txt76"))
	#####

    #-- Window6.on_button26_clicked {
    def on_button26_clicked(self, widget, *args):
	try:
		CLIST_row
		CLIST_column
	except:
		msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt22"))
		msgbox.run()
		msgbox.destroy()
	else:
		txt = self.clist4.get_text(CLIST_row,CLIST_column)
		MediathequeHeritee = Mediatheque()
		MediathequeHeritee.FenetrePropriete(txt)
    #-- Window6.on_button26_clicked }

    #-- Window6.on_clist4_select_row {
    def on_clist4_select_row(self,b,c,d,e):
	global CLIST_row
	global CLIST_column
	CLIST_row = c
	CLIST_column = d
    #-- Window6.on_clist4_select_row }

class Window7(SimpleGladeApp):

    def __init__(self, path="gui.glade",
                 root="window7",
                 domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)
	#####
	##Traduction des textes GLADE
	#####
	self.window7.set_title(translation.GetTranslationValueByEntry("txt77"))
	self.label143.set_text(translation.GetTranslationValueByEntry("txt78"))
	self.label145.set_text(translation.GetTranslationValueByEntry("txt79"))
	self.label146.set_text(translation.GetTranslationValueByEntry("txt80"))
	self.label144.set_text(translation.GetTranslationValueByEntry("txt81"))
	#####

    def on_clist5_select_row(self,b,c,d,e):
	global CLIST2_row
	global CLIST2_column
	CLIST2_row = c
	CLIST2_column = d

    def on_button31_clicked(self, widget, *args):
	webbrowser.open("http://www.allocine.fr"+self.clist5.get_text(CLIST2_row,CLIST2_column))

    def on_button32_clicked(self, widget, *args):
	self.window7.destroy()

    def on_button30_clicked(self, widget, *args):
	self.ParseAlloCine(self.clist5.get_text(CLIST2_row,CLIST2_column))

    def ParseAlloCine(self,motcle):
	htmlSource = urllib.urlopen("http://www.allocine.fr"+motcle).read(200000)
	#for realisator in re.findall('<h4>Réalisé par <a class="link1" href=".*?">(.*?)</a></h4>',htmlSource):
	for realisator in re.findall('.html">(.*?)</a></h4><h4>&nbsp;&nbsp;&nbsp;<img src="http://a69.g.akamai.net/n/69/10688/v1/img5.allocine.fr/acmedia/skin/allocinev5/puce/fleche_bleue.gif" border="0" style="margin: 0 6 0 0" width="6" height="8" /><a href=".*?" class="link1">Voir tout le casting...</a></h4>',htmlSource):
		window5BIS.entry13.set_text(realisator.decode('iso-8859-1'))
	for date in re.findall('<h4>Date de sortie : <b>(.*?)</b>',htmlSource):
		window5BIS.entry14.set_text(date[-4:])
	for synopsis in re.findall('<td valign="top" style="padding:10 0 0 0"><div align="justify"><h4>(.*?)</h4></div></td>',htmlSource):
		window5BIS.textview4.set_wrap_mode(gtk.WRAP_WORD)
		buffertexte = window5BIS.textview4.get_buffer()
		buffertexte.set_text(synopsis.decode('iso-8859-1'))
	for film in re.findall('<title>(.*?)</title>',htmlSource):
		window5BIS.entry12.set_text(film.decode('iso-8859-1'))
	self.window7.destroy()

#######Méthodes pour VideoManager (bakhend)

class Mediatheque:

#    def __init__(self):
#	print "Initialisation de la classe Mediatheque de VideoManagerCommon.py réussie !"

    def Load(self, win, typeof):
	## Sauvegarde du classement des films
	config = ConfigParser.ConfigParser()
	OptionsHeritee = Options()

	config.add_section("mediatheque")
	config.set("mediatheque", "typeof", typeof)

	config.add_section("film")
	config.set("film", "prog", OptionsHeritee.ObtenirLaConfiguration(4))

	config.add_section("amazon")
	config.set("amazon", "ligne", OptionsHeritee.ObtenirLaConfiguration(2))
	config.set("amazon", "taille", OptionsHeritee.ObtenirLaConfiguration(3))

	config.add_section("divers")
	config.set("divers", "locale", OptionsHeritee.ObtenirLaConfiguration(6))
	config.set("divers", "pochette", OptionsHeritee.ObtenirLaConfiguration(5))
	config.set("divers", "type", OptionsHeritee.ObtenirLaConfiguration(7))

	config.write(open("/home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg","w"))

	if win.user == 1:
		win.scrolled_window.hide()
	OptionsHeritee = Options()
	if OptionsHeritee.ObtenirLaConfiguration(7) == "normal":
		win.clist1.clear()
		win.statusbar1.push(0,translation.GetTranslationValueByEntry("txt23"))
		if typeof == "genre":
			aenregistrer = "genre"
			win.clist1.set_column_title(0,translation.GetTranslationValueByEntry("txt24"))
			data = Options().ObtenirTousLesGenres()
			i=0
			while i<= 15:
				win.clist1.append([ data[i] ])
				i = i+1
		else:
			cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
			cur = cx.cursor()
			if typeof == "real":
				aenregistrer = "real"
				cur.execute("select realisateur from films group by realisateur order by realisateur")
				for row in cur.fetchall():
					data = [ [ row.realisateur ] ]
					win.clist1.append(data[0])
				win.clist1.set_column_title(0,translation.GetTranslationValueByEntry("txt25"))
			if typeof == "ann":
				aenregistrer = "ann"
				cur.execute("select annee from films group by annee order by annee")
				for row in cur.fetchall():
					data = [ [ row.annee ] ]
					win.clist1.append(data[0])
				win.clist1.set_column_title(0,translation.GetTranslationValueByEntry("txt26"))
			if typeof == "note":
				aenregistrer = "note"
				cur.execute("select note from films group by note order by note")
				for row in cur.fetchall():
					data = [ [ row.note ] ]
					win.clist1.append(data[0])
				win.clist1.set_column_title(0,translation.GetTranslationValueByEntry("txt27"))
			cur.close()
			cx.close()

	if OptionsHeritee.ObtenirLaConfiguration(7) == "avance":
		win.user = 1
		win.statusbar1.push(0,translation.GetTranslationValueByEntry("txt23"))
        	win.scrolledwindow4.hide()
		win.scrolledwindow2.hide()
		win.scrolledwindow3.hide()
		win.button25.show()
	
		win.scrolled_window = gtk.ScrolledWindow()
		win.scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
	
		win.treestore = gtk.TreeStore(str)
		win.treeview = gtk.TreeView(win.treestore)
	
		win.cell = gtk.CellRendererText()
		win.tvcolumn = gtk.TreeViewColumn(translation.GetTranslationValueByEntry("txt33"), win.cell, markup=0)
		win.treeview.connect("row-activated", win.selectone, iter)
	
		if typeof == "genre":
			aenregistrer = "genre"
			data = OptionsHeritee.ObtenirTousLesGenres()
			i=0
			for da in data:
				m_iter = win.treestore.append(None, [da.replace("&","&amp;",50)])
				cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
				cur = cx.cursor()
				cur.execute("select * from films where genre = %s", (da))
				u = 0
				for row in cur.fetchall():
					win.treestore.append(m_iter, ["<b>%s</b>" % row.nom])
					u = u + 1
				cur.close()
				cx.close()
				i = i+1
		else:
			cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
			cur = cx.cursor()
			if typeof == "real":
				aenregistrer = "real"
				cur.execute("select realisateur from films group by realisateur order by realisateur")
				i=0
				for row in cur.fetchall():
					m_iter = win.treestore.append(None, [row.realisateur])
					cur.execute("select * from films where realisateur = %s", (row.realisateur))
					u = 0
					for row in cur.fetchall():
						win.treestore.append(m_iter, ["<b>%s</b>" % row.nom])
						u = u + 1
					i = i+1

			if typeof == "ann":
				aenregistrer = "ann"
				cur.execute("select annee from films group by annee order by annee")
				i=0
				for row in cur.fetchall():
					m_iter = win.treestore.append(None, [row.annee])
					cur.execute("select * from films where annee = %s", (row.annee))
					u = 0
					for row in cur.fetchall():
						win.treestore.append(m_iter, ["<b>%s</b>" % row.nom])
						u = u + 1
					i = i+1

			if typeof == "note":
				aenregistrer = "note"
				cur.execute("select note from films group by note order by note")
				i=0
				for row in cur.fetchall():
					m_iter = win.treestore.append(None, [row.note])
					cur.execute("select * from films where note = %s", (row.note))
					u = 0
					for row in cur.fetchall():
						win.treestore.append(m_iter, ["<b>%s</b>" % row.nom])
						u = u + 1
					i = i+1

			cur.close()
			cx.close()

		win.treeview.append_column(win.tvcolumn)
		win.treeview.set_search_column(0)
		win.treeview.set_reorderable(False)
	
		win.tvcolumn.add_attribute(win.cell, 'text', 0)
		#win.tvcolumn.set_sort_column_id(0)
	
		win.scrolled_window.add(win.treeview)
		win.treeview.show()
		win.hbox1.add(win.scrolled_window)
		win.scrolled_window.show()

    def Cherche(self, win, occurence):
	win.statusbar1.push(1,translation.GetTranslationValueByEntry("txt28").replace("%s",occurence,1))
	win.clist3.clear()
	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	cur.execute("select * from films where nom = %s ", (occurence) )
	i = 0
	for row in cur.fetchall():
		data = [ [ row.nom, row.realisateur, row.annee, row.genre ] ]
		win.clist3.append(data[0])
		i = i + 1
	if i == 0:
		win.statusbar1.push(2,translation.GetTranslationValueByEntry("txt29").replace("%s",occurence,1))
	cur.close()
	cx.close()

    def AjouteDossier(self, win):
	win.selectdossier = gtk.FileChooserDialog(translation.GetTranslationValueByEntry("txt30"), None, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
	win.selectdossier.set_current_folder(os.path.expanduser("~/"))
	dossier = gtk.FileChooserDialog.run(win.selectdossier)
        folder = None
        if dossier == gtk.RESPONSE_OK:
             folder = win.selectdossier.get_filename()
       	win.selectdossier.destroy()
	if folder != None:
		window6 = Window6()
		self.ScanneDossier(folder, "avi", window6)
		self.ScanneDossier(folder, "mpg", window6)
		self.ScanneDossier(folder, "mpeg", window6)
		self.ScanneDossier(folder, "ogg", window6)
		self.ScanneDossier(folder, "ogm", window6)
		self.ScanneDossier(folder, "mkv", window6)

    def ScanneDossier(self, dossier, extension, win):
	for nomfichier in glob.glob(dossier+"/*."+extension):
		i=0
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("select * from films where fichier = %s limit 1", (nomfichier))
		for row in cur.fetchall():
			i=i+1
		cur.close()
		cx.close()
		if i==0:
			datafichier = [ [ nomfichier ] ]
			win.clist4.append(datafichier[0])

    def AjouteFichier(self, win):
	win.selectfichier = gtk.FileChooserDialog(translation.GetTranslationValueByEntry("txt31"), None, gtk.FILE_CHOOSER_ACTION_OPEN, (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,gtk.STOCK_OPEN, gtk.RESPONSE_OK))
	win.selectfichier.set_current_folder(os.path.expanduser("~/"))
	filter = gtk.FileFilter()
	filter.add_pattern("*.avi")
	filter.add_pattern("*.mpg")
	filter.add_pattern("*.mpeg")
	filter.add_pattern("*.ogg")
	filter.add_pattern("*.ogm")
	filter.add_pattern("*.mkv")
	win.selectfichier.set_filter(filter)
	dossier2 = gtk.FileChooserDialog.run(win.selectfichier)
        fichier = None
        if dossier2 == gtk.RESPONSE_OK:
             fichier = win.selectfichier.get_filename()
       	win.selectfichier.destroy()
	if fichier != None:
		i=0
		cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
		cur = cx.cursor()
		cur.execute("select * from films where fichier = %s limit 1", (fichier))
		for row in cur.fetchall():
			i=i+1
		cur.close()
		cx.close()
		if i==0:
			self.FenetrePropriete(fichier)
		else:
			msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt32"))
			msgbox.run()
			msgbox.destroy()

    def FenetrePropriete(self, fichier):
	i=0
	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	cur.execute("select * from films where fichier = %s limit 1", (fichier))
	for row in cur.fetchall():
		i=i+1
	cur.close()
	cx.close()
	if i==0:
		window5 = Window5()
		txt = os.path.basename(fichier)
		txt = txt.replace('.avi', '')
		txt = txt.replace('.mpg', '')
		txt = txt.replace('.mpeg', '')
		window5.entry12.set_text(txt)
		window5.label130.set_markup("<i>"+os.path.basename(fichier)+"</i>")
		window5.filename = fichier
		window5.combobox4.set_active(0)
	else:
		msgbox = gtk.MessageDialog(None,gtk.DIALOG_MODAL,gtk.MESSAGE_ERROR,gtk.BUTTONS_OK,translation.GetTranslationValueByEntry("txt32"))
		msgbox.run()
		msgbox.destroy()

class Options:

#    def __init__(self):
#	print "Initialisation de la classe Options de VideoManagerCommon.py réussie !"

    def ObtenirLaConfiguration(self, getto):
	u="/home/"+commands.getoutput("whoami")+"/.videomanager/"
	config = ConfigParser.ConfigParser()
	config.read(u+"config.cfg")
	if getto == 1:
		Classification = config.get("mediatheque","typeof")
		return Classification
	if getto == 2:
		Classification = config.get("amazon","ligne")
		return Classification
	if getto == 3:
		Classification = config.get("amazon","taille")
		return Classification
	if getto == 4:
		Classification = config.get("film","prog")
		return Classification
	if getto == 5:
		Classification = config.get("divers","pochette")
		return Classification
	if getto == 6:
		Classification = config.get("divers","locale")
		return Classification
	if getto == 7:
		Classification = config.get("divers","type")
		return Classification

    def SauvegardeLeType(self, typechoix):
	config = ConfigParser.ConfigParser()
	OptionsHeritee = Options()

	config.add_section("mediatheque")
	config.set("mediatheque", "typeof", OptionsHeritee.ObtenirLaConfiguration(1))

	config.add_section("film")
	config.set("film", "prog", OptionsHeritee.ObtenirLaConfiguration(4))

	config.add_section("amazon")
	config.set("amazon", "ligne", OptionsHeritee.ObtenirLaConfiguration(2))
	config.set("amazon", "taille", OptionsHeritee.ObtenirLaConfiguration(3))

	config.add_section("divers")
	config.set("divers", "locale", OptionsHeritee.ObtenirLaConfiguration(6))
	config.set("divers", "pochette", OptionsHeritee.ObtenirLaConfiguration(5))
	config.set("divers", "type", typechoix)

	config.write(open("/home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg","w"))

    def ObtenirTousLesGenres(self):
	lang = LOCALE
	file = open(os.path.dirname(os.path.realpath(__file__))+"/lang/rub-"+lang,"r")
	lignes = file.readlines()
	file.close()

	c = [ "" ]
	i = 0
	for l in lignes:
		l = l.replace("\n","",50).replace("&amp;","&",50)
		c.insert(i,l)
		i = i + 1
	return c

class FonctionsDeBases:

#    def __init__(self):
#	print "Initialisation de la classe FonctionsDeBases de VideoManagerCommon.py réussie !"

    def CommandesGeneriques(self):
	#os.system("cd ~ && mkdir .videomanager")
	#os.system("cd ~/.videomanager && mkdir covers")
	## Sans sortie à la console :
	a = commands.getoutput("cd ~ && mkdir .videomanager && cd ~/.videomanager && mkdir covers")

	if commands.getoutput("ls /home/"+commands.getoutput("whoami")+"/.videomanager/version") != "/home/"+commands.getoutput("whoami")+"/.videomanager/version" and commands.getoutput("ls /home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg") == "/home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg":
		print "<=0.3"
		## Mise à niveau du fichier de configuration
		config = ConfigParser.ConfigParser()
		OptionsHeritee = Options()

		config.add_section("mediatheque")
		config.set("mediatheque", "typeof", OptionsHeritee.ObtenirLaConfiguration(1))

		config.add_section("film")
		config.set("film", "prog", OptionsHeritee.ObtenirLaConfiguration(4))

		config.add_section("amazon")
		config.set("amazon", "ligne", OptionsHeritee.ObtenirLaConfiguration(2))
		config.set("amazon", "taille", OptionsHeritee.ObtenirLaConfiguration(3))

		config.add_section("divers")
		config.set("divers", "locale", "fr")
		config.set("divers", "pochette", "oui")
		config.set("divers", "type", "normal")

		config.write(open("/home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg","w"))
		## Création d'un fichier indiquant la version
		Version = open("/home/"+commands.getoutput("whoami")+"/.videomanager/version", "w")
		Version.write("0.5")
		Version.close

	if commands.getoutput("ls /home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg") != "/home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg":
		config = ConfigParser.ConfigParser()

		config.add_section("mediatheque")
		config.set("mediatheque", "typeof", "genre")

		config.add_section("film")
		config.set("film", "prog", "totem")

		config.add_section("amazon")
		config.set("amazon", "ligne", "dvd")
		config.set("amazon", "taille", "Grande")

		config.add_section("divers")
		config.set("divers", "locale", "fr")
		config.set("divers", "pochette", "oui")
		config.set("divers", "type", "normal")

		config.write(open("/home/"+commands.getoutput("whoami")+"/.videomanager/config.cfg","w"))

	cx = sqlite.connect("/home/"+commands.getoutput("whoami")+"/.videomanager/films.db3")
	cur = cx.cursor()
	try:
		cur.execute("create table films (rowid integer primary key, nom text, realisateur text, annee text, genre text, note text, fichier text, url text, imagemedium text)")
		cx.commit()
	except:
		pass
	cur.close()
	cx.close()
