#!/usr/bin/python
# -*- coding: utf-8 -*-

## This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from GlobalDefines import *
from Documentation import *

class DocHelp(QDialog,Ui_Documentation) : #OK QT4
    def __init__(self, Videoporama, parent=None):
      super(DocHelp, self).__init__(parent)
      self.setupUi(self)
      self.Videoporama=Videoporama
      self.Videoporama.qtapp.connect(self.closeabout,SIGNAL("clicked()"),self,SLOT("close()"))
      self.Videoporama.qtapp.connect(self.BackwardBt,SIGNAL("clicked()"),self.DocumentationBackward)
      self.Videoporama.qtapp.connect(self.ForwardBt,SIGNAL("clicked()"),self.DocumentationForward)
      self.Videoporama.qtapp.connect(self.textBrowser,SIGNAL("backwardAvailable(bool)"),self.DocumentationBackwardAvailable)
      self.Videoporama.qtapp.connect(self.textBrowser,SIGNAL("forwardAvailable(bool)"),self.DocumentationForwardAvailable)
      self.BackwardBt.setDisabled(True)
      self.ForwardBt.setDisabled(True)

    def SetSourceDocument(self,HtmlFile):
      if sys.platform == 'win32':
        List=[]
        List.append(validatePath(os.getcwd(),True)+u"help")
        self.textBrowser.setSearchPaths(List)
        PathName=HtmlFile
      else :
        PathName=validatePath(os.path.abspath(os.path.dirname(sys.argv[0])),True)+u"help/"+HtmlFile
      self.textBrowser.setSource(QUrl(PathName))
      self.BackwardBt.setDisabled(True)
      self.ForwardBt.setDisabled(True)

    def DocumentationBackwardAvailable(self,available) :
      self.BackwardBt.setEnabled(available)

    def DocumentationForwardAvailable(self,available) :
      self.ForwardBt.setEnabled(available)

    def DocumentationBackward(self) :
      self.textBrowser.backward()

    def DocumentationForward(self) :
      self.textBrowser.forward()
