#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os
import Image
import random
from math import *
from __builtin__ import hex as hexp
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from GlobalDefines import *
from lot import *
from DocHelpDlg import *

#---------------------------------------------------------------------------------------------------------------------------------------------------------------
# Serie dialog box
#---------------------------------------------------------------------------------------------------------------------------------------------------------------

class Lot(QDialog,Ui_lot) :
    def __init__(self,lstTransi,VideoporamaInstance,parent=None) :
      super(Lot, self).__init__(parent)
      self.setupUi(self)
      self.VideoporamaInstance=VideoporamaInstance
      # Fill transition and transition option list box
      self.index=-1
      self.typet.addItems(lstTransi)
      self.typet.addItem(VideoporamaInstance.qtapp.translate("main","Random"))
      self.RANDOMTRANSITIONTYPE=self.typet.count()-1

      self.connect(self.typet,SIGNAL("currentIndexChanged(int)"),self.chgTrOption)
      self.connect(self.bgfilea,SIGNAL("clicked()"),self.bgfileact)
      self.connect(self.bgcolora,SIGNAL("clicked()"),self.bgcoloract)
      self.connect(self.updateLine,SIGNAL("clicked()"),self.updateLineA)
      self.connect(self.removeLine,SIGNAL("clicked()"),self.removeLineA)
      self.connect(self.empty,SIGNAL("clicked()"),self.emptyTableA)
      self.connect(self.validLine,SIGNAL("clicked()"),self.validLineA)
      self.connect(self.buttonBox,SIGNAL("rejected()"),self,SLOT("close()"))
      self.connect(self.tableImage,SIGNAL("itemSelectionChanged()"),self.updateOption)

      self.checkBox_time.setChecked(False)
      self.checkBox_bgfile.setChecked(False)
      self.checkBox_bgcolor.setChecked(False)
      self.checkBox_speedt.setChecked(False)
      self.checkBox_typet.setChecked(False)

      self.connect(self.checkBox_time,SIGNAL("stateChanged(int)"),self.SetupInterface)
      self.connect(self.checkBox_bgfile,SIGNAL("stateChanged(int)"),self.SetupInterface)
      self.connect(self.checkBox_bgcolor,SIGNAL("stateChanged(int)"),self.SetupInterface)
      self.connect(self.checkBox_speedt,SIGNAL("stateChanged(int)"),self.SetupInterface)
      self.connect(self.checkBox_typet,SIGNAL("stateChanged(int)"),self.SetupInterface)
      self.connect(self.HelpBt,SIGNAL("pressed()"),self.onHelp)

      # Defaulf background color
      color=toqcolor(QString(VideoporamaInstance.ConfBgColor).toInt(16)[0])
      qp=QPalette()
      qp.setColor(QPalette.Base,color)
      self.bgcolor.setPalette(qp)
      self.bgcolor.setText(unicode(VideoporamaInstance.ConfBgColor))
      self.bgfile.setText(unicode(VideoporamaInstance.ConfBgFile))
      self.time.setValue(int(VideoporamaInstance.ConfTime))
      self.speedt.setCurrentIndex(int(VideoporamaInstance.ConfSpeedT))
      self.typet.setCurrentIndex(int(VideoporamaInstance.ConfTypeT))
      self.transiopt.setCurrentIndex(int(VideoporamaInstance.ConfTransiOpt))

      self.SetupInterface(False)

    def onHelp(self):
      self.docw=DocHelp(self.VideoporamaInstance,self)
      self.docw.SetSourceDocument(self.VideoporamaInstance.qtapp.translate("Documentation","en-lotbox.html"))
      self.docw.show() 

    def SetupInterface(self,state) :
      self.time.setEnabled(self.checkBox_time.isChecked())
      self.bgfile.setEnabled(self.checkBox_bgfile.isChecked())
      self.bgfilea.setEnabled(self.checkBox_bgfile.isChecked())
      self.bgcolor.setEnabled(self.checkBox_bgcolor.isChecked())
      self.bgcolora.setEnabled(self.checkBox_bgcolor.isChecked())
      self.speedt.setEnabled(self.checkBox_speedt.isChecked())
      self.typet.setEnabled(self.checkBox_typet.isChecked())
      self.transiopt.setEnabled(self.checkBox_typet.isChecked())

    def updateOption(self) :
      CurSel =self.tableImage.currentRow()
      if CurSel!=-1:
        if CurSel!=self.index :
          self.index=CurSel
          self.fromc.setValue(int(self.tableImage.item(self.index,0).text()))
          self.toc.setValue(int(self.tableImage.item(self.index,1).text()))
          option=self.tableImage.item(self.index,2).text().split(":")

          self.time.setValue(int(option[0].split("=")[1]))
          self.bgfile.setText(option[1].split("=")[1])
          self.bgcolor.setText(option[2].split("=")[1])
          color=toqcolor(QString(option[2].split("=")[1]).toInt(16)[0])
          qp=QPalette()
          qp.setColor(QPalette.Base,color)
          self.bgcolor.setPalette(qp)
          self.speedt.setCurrentIndex(int(option[3].split("=")[1]))
          self.typet.setCurrentIndex(int(option[4].split("=")[1]))
          self.transiopt.setCurrentIndex(int(option[5]))

          self.checkBox_time.setChecked(option[0].split("=")[0]!="0")
          self.checkBox_bgfile.setChecked(option[1].split("=")[0]!="0")
          self.checkBox_bgcolor.setChecked(option[2].split("=")[0]!="0")
          self.checkBox_speedt.setChecked(option[3].split("=")[0]!="0")
          self.checkBox_typet.setChecked(option[4].split("=")[0]!="0")

          self.SetupInterface(False)

    def bgfileact(self):
      file=QFileDialog.getOpenFileName(self, "FileDialog",self.VideoporamaInstance.lastDirBackground, "Images(*.jpg *.png *.gif *.xpm)")
      self.bgfile.setText(file)
      self.VideoporamaInstance.lastDirBackground=os.path.split(unicode(file).encode('utf-8'))[0]

    def bgcoloract(self):
      color=QColorDialog.getColor(toqcolor(QString(self.bgcolor.text()).toInt(16)[0]),self)
      red=color.red()
      green=color.green()
      blue=color.blue()
      xcolor=colortohex(red*65536+green*256+blue)
      color=toqcolor(QString(xcolor).toInt(16)[0])
      qp=QPalette()
      qp.setColor(QPalette.Base,color)
      self.bgcolor.setPalette(qp)
      self.bgcolor.setText(unicode(xcolor))

    def chgTrOption(self,index) :
      z=getTrOptionLst(self.VideoporamaInstance,index)
      self.transiopt.clear()
      # Add icons to Combobox
      i=0;
      max=len(z)
      while i<max:
        if index==7:
          FNameTr=u"iconstr/"+z[i]+u".png"
        else:
          FNameTr=u"iconstr/tr-0"+unicode(index)+u"-0"+unicode(i)+u".png"
        try:
          self.transiopt.addItem(QIcon(FNameTr),z[i])
        except:
          self.transiopt.addItem(z[i])
        i=i+1

    def updateLineA(self) :
      if self.tableImage.currentRow() != -1 :
        options=QString(
          unicode(int(self.checkBox_time.isChecked()))+"="+unicode(self.time.value())+
          ":"+unicode(int(self.checkBox_bgfile.isChecked()))+"="+self.bgfile.text()+
          ":"+unicode(int(self.checkBox_bgcolor.isChecked()))+"="+self.bgcolor.text()+
          ":"+unicode(int(self.checkBox_speedt.isChecked()))+"="+unicode(self.speedt.currentIndex())+
          ":"+unicode(int(self.checkBox_typet.isChecked()))+"="+unicode(self.typet.currentIndex())+
          ":"+unicode(self.transiopt.currentIndex())
        )
        self.tableImage.setItem(self.tableImage.currentRow(),0,QTableWidgetItem(unicode(self.fromc.value())))
        self.tableImage.setItem(self.tableImage.currentRow(),1,QTableWidgetItem(unicode(self.toc.value())))
        self.tableImage.setItem(self.tableImage.currentRow(),2,QTableWidgetItem(options))
      else :
        self.validLineA()

    def removeLineA(self) :
      if self.tableImage.currentRow() != -1 :
        self.tableImage.removeRow(self.tableImage.currentRow())

    def emptyTableA(self) :
      while self.tableImage.rowCount() > 0 :
        self.tableImage.removeRow(0)

    def validLineA(self) :
      self.tableImage.insertRow(self.tableImage.rowCount())
      self.tableImage.setItem(self.tableImage.rowCount()-1,0,QTableWidgetItem(unicode(self.fromc.value())))
      self.tableImage.setItem(self.tableImage.rowCount()-1,1,QTableWidgetItem(unicode(self.toc.value())))
      options=QString(
        unicode(int(self.checkBox_time.isChecked()))+"="+unicode(self.time.value())+
        ":"+unicode(int(self.checkBox_bgfile.isChecked()))+"="+self.bgfile.text()+
        ":"+unicode(int(self.checkBox_bgcolor.isChecked()))+"="+self.bgcolor.text()+
        ":"+unicode(int(self.checkBox_speedt.isChecked()))+"="+unicode(self.speedt.currentIndex())+
        ":"+unicode(int(self.checkBox_typet.isChecked()))+"="+unicode(self.typet.currentIndex())+
        ":"+unicode(self.transiopt.currentIndex())
      )
      self.tableImage.setItem(self.tableImage.rowCount()-1,2,QTableWidgetItem(options))
      self.tableImage.setCurrentCell((self.tableImage.rowCount()-1),0)
      self.updateLineA()


