#!/usr/bin/python
# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import sys
import os
from subprocess import *
from xml.dom import minidom
from xml.dom.minidom import Document
from process import *
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from __builtin__ import hex as hexp
from string import *
from interface import *
from main_win import *
from statusconf import *
from about import *
from configuration import *
from GlobalDefines import *
from DocHelpDlg import *

class videoporama :
    def __init__(self,args):
      #local variables definition
      self.index                        = -1
      self.AACMode                      = ""        #adts if ffmpeg 0.6 and libfaac for ffmpeg 0.5
      self.StopMAJOFD                   = False     #Flag to stop modification of OFD configuration for project
      self.StopMAJSpinbox               = False     #Flag to stop multiple update during spinbox update
      self.BLOCKDefZoomPointDlg         = False     #Flag for allow only one DefZoomPointDlg at a time
      self.BLOCKCloseApp                = False     #Flag to block multiple ask for save project when close app
      self.StopUpdatePixDuringNewSelect = False     #Variable to stop multiple updatepix when an image is selected
      self.StopUpdatePixDuringEmpty     = False     #Variable to stop updatepix when empty timeline
      self.StopSetupInterface           = False     #Variable to stop multiple SetupInterface
      self.OutputOFDXMLObject           = None      #Output format definition XML Object
      self.homeDir                      = ""        #Home directory
      self.lastDirImage                 = ""        #Last directory use for Image
      self.lastDirProject               = ""        #Last directory use for Project
      self.lastDirSound                 = ""        #Last directory use for Sound
      self.lastDirRender                = ""        #Last directory use for Render
      self.lastDirBackground            = ""        #Last directory use for Background Image

      #Project file
      self.ProjectFilePathName          = ""        #PathName of the project file
      self.ProjectXMLObject             = None      #Document object of the project file
      self.IsProjectModified            = False     #Flag for known if project file need to be save
      self.videof                       = 0         #Project video format
      self.imgformat                    = 0         #Project image format
      self.outputf                      = 0         #Project output format
      self.soundfile                    = ""        #Project sound file
      self.outputFile                   = ""        #Project output file

      #Configuration file
      self.ConfigFilePathName           = ""        #PathName of the configuration file
      self.ConfigXMLObject              = None      #Document object of the configuration file

      #Directory Configuration (default value are calculate during the init process)
      self.T                            = ""        #Temporary directory
      self.I                            = ""        #FFMPEG directory
      self.MP                           = ""        #MPlayer directory
      self.S                            = ""        #SOX directory
      self.MJ                           = ""        #MPJEPTools directory

      #Standard Project Options (default value are set here !)
      self.ConfVideoF                   = 0         #Default output format
      self.ConfImgFormat                = 0         #Default output format
      self.ConfOutputF                  = 0         #Default output format
      self.ConfTime                     = 7         #project options : image duration
      self.ConfSpeedT                   = 3         #project options : transition duration
      self.ConfTypeT                    = 8         #project options : default transition : Random
      self.ConfTransiOpt                = 0         #project options : default transition option (0 for Random)
      self.ConfBgFile                   = ""        #project options : default background file
      self.ConfBgColor                  = 0         #project options : default background color
      self.ConfDisplayUnit              = 0         #Display configuration - "0"=as %, "1"= as Pixel
      self.ConfAutoRotate               = 1         #Display configuration - Automatic Rotation of rotaded image
      self.XMLText                     = None       #Overlaid text

      #Other options
      self.CheckCodecAtStartup          = 0         #if 0 then Check Codec at Startup
      self.ThumbnailsSize               = 1         #size of the thumbnails in the timeline
      self.RestoreWindowState           = 1         #if 1 restore window size/position at startup

      #-------------------------------------------------------------------------------------------------------------

      # Init Qt application and locale
      self.qtapp=QApplication(args)
      locale = QLocale.system().name()

      #Init QT translation
      qtTrans = QTranslator()
      if qtTrans.load(u"/usr/share/qt4/translations/qt_"+unicode(locale[0:2])+u".qm") :
        self.qtapp.installTranslator(qtTrans)

      #Init videoporama translation
      qtTranslator = QTranslator()
      if qtTranslator.load(u"./locale/videoporama_"+unicode(locale[0:2])+u".qm") :
        self.qtapp.installTranslator(qtTranslator)

      #check if the .videoporama directory exist in the home-user. If not : create it
      self.homeDir=os.path.expanduser("~")
      if self.homeDir[len(self.homeDir)-1]!=os.sep : self.homeDir=self.homeDir+os.sep

      self.lastDirImage      = self.homeDir        #Last directory use for Image
      self.lastDirProject    = self.homeDir        #Last directory use for Project
      self.lastDirSound      = self.homeDir        #Last directory use for Sound
      self.lastDirRender     = self.homeDir        #Last directory use for Render
      self.lastDirBackground = self.homeDir        #Last directory use for Background Image

      self.homeDir=validatePath(self.homeDir+u".videoporama/")
      
      #Init default directory
      if os.name == 'nt' : 
        #Windows version
        self.I  = os.getcwd()+os.sep+"extern_bin"+os.sep+"ffmpeg"+os.sep+"bin"+os.sep      #FFMPEG directory
        self.MP = os.getcwd()+os.sep+"extern_bin"+os.sep+"mplayer"+os.sep                  #MPlayer directory
        self.S  = os.getcwd()+os.sep+"extern_bin"+os.sep+"sox"+os.sep                      #SOX directory
        self.MJ = os.getcwd()+os.sep+"extern_bin"+os.sep+"mjpegtools"+os.sep+"bin"+os.sep  #MPJEPTools directory
      else:
        #Unix/Linux version
        self.I  = "/usr/bin/"        #FFMPEG directory
        self.MP = "/usr/bin/"        #MPlayer directory
        self.S  = "/usr/bin/"        #SOX directory
        self.MJ = "/usr/bin/"        #MPJEPTools directory

      if (not os.path.exists(self.homeDir)) :
        print self.qtapp.translate("main","Configuration directory doesn't exist")
        print self.qtapp.translate("main","Create configuration directory at "+self.homeDir)
        try:
          os.mkdir(self.homeDir)
        except:
          print self.qtapp.translate("main","Error creating driectory directory at "+self.homeDir)
          return

      # Loading Output Format Definition from xml file
      fo=open("VideoporamaOFD.xml",'r')
      self.OutputOFDXMLObject=minidom.parse(fo)
      fo.close()

      # Loading configuration data from xml file
      print self.qtapp.translate("main",u"Loading configuration data")
      self.ConfigFilePathName=self.homeDir+u'idv_config.xml'
      try:
        fo=open(self.ConfigFilePathName,'r')
        self.ConfigXMLObject=minidom.parse(fo)
        fo.close()
        ForceConfig=False
      except:
        print self.qtapp.translate("main","Create configuration data file at "+self.ConfigFilePathName)
        self.ConfigXMLObject= Document()
        xmltag = self.ConfigXMLObject.createElement(u"configuration")
        self.ConfigXMLObject.appendChild(xmltag)
        ForceConfig=True

      #Loading configuration from configuration file
      #  ... force loading all data to create them with default value if not exist

      #Configuration TAB Directory configuration
      self.T                 = unicode(LoadValueFromXMLFile(self.ConfigXMLObject,'tmpdir',self.homeDir))             #Temporary directory
      self.I                 = LoadValueFromXMLFile(self.ConfigXMLObject,'imgmgkdir',self.I)                         #FFMPEG directory
      self.MP                = LoadValueFromXMLFile(self.ConfigXMLObject,'mplayerdir',self.MP)                       #MPlayer directory
      self.S                 = LoadValueFromXMLFile(self.ConfigXMLObject,'soxdir',self.S)                            #SOX directory
      self.MJ                = LoadValueFromXMLFile(self.ConfigXMLObject,'mjpegtoolsdir',self.MJ)                    #MPJEPTools directory
      self.lastDirImage      = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirImage',self.lastDirImage)           #Last directory use for Image
      self.lastDirProject    = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirProject',self.lastDirProject)       #Last directory use for Project
      self.lastDirSound      = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirSound',self.lastDirSound)           #Last directory use for Sound
      self.lastDirRender     = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirRender',self.lastDirRender)         #Last directory use for Render
      self.lastDirBackground = LoadValueFromXMLFile(self.ConfigXMLObject,'lastDirBackground',self.lastDirBackground) #Last directory use for Background Image

      #Configuration TAB Display configuration
      self.ConfDisplayUnit    = LoadValueFromXMLFile(self.ConfigXMLObject,'zoomVal',self.ConfDisplayUnit)
      self.RestoreWindowState = LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-RestoreWindowState',self.RestoreWindowState)
      self.ThumbnailsSize     = int(LoadValueFromXMLFile(self.ConfigXMLObject,'ThumbnailsSize',self.ThumbnailsSize))
      self.ConfAutoRotate     = LoadValueFromXMLFile(self.ConfigXMLObject,'ConfAutoRotate',self.ConfAutoRotate)

      #Configuration TAB Default output format
      self.ConfVideoF         = LoadValueFromXMLFile(self.ConfigXMLObject,'videof',self.ConfVideoF)
      self.ConfImgFormat      = LoadValueFromXMLFile(self.ConfigXMLObject,'imgformat',self.ConfImgFormat)
      self.ConfOutputF        = LoadValueFromXMLFile(self.ConfigXMLObject,'outputf',self.ConfOutputF)
      self.XMLText            = None
      self.ConfOFDDeviceType  = LoadValueFromXMLFile(self.ConfigXMLObject,'OFDDeviceType',"Computer")
      self.ConfOFDDeviceModel = LoadValueFromXMLFile(self.ConfigXMLObject,'OFDDeviceModel',"Generic PC")
      self.ConfOFDOutputCodec = LoadValueFromXMLFile(self.ConfigXMLObject,'OFDOutputCodec',"VCD/SVCD")
      if self.ConfImgFormat==1: self.ConfOFDOutputFormat= LoadValueFromXMLFile(self.ConfigXMLObject,'OFDOutputFormat',"VCD-NTSC 352x240-30 fps")
      else :                    self.ConfOFDOutputFormat= LoadValueFromXMLFile(self.ConfigXMLObject,'OFDOutputFormat',"VCD-NTSC 352x240 Wide-30 fps")
      self.imgformat          = int(self.ConfImgFormat)
      self.OFDDeviceType      = self.ConfOFDDeviceType
      self.OFDDeviceModel     = self.ConfOFDDeviceModel
      self.OFDOutputCodec     = self.ConfOFDOutputCodec
      self.OFDOutputFormat    = self.ConfOFDOutputFormat

      #Configuration TAB Standards project options
      self.ConfTime           = LoadValueFromXMLFile(self.ConfigXMLObject,'time',self.ConfTime)
      self.ConfSpeedT         = LoadValueFromXMLFile(self.ConfigXMLObject,'speedt',self.ConfSpeedT)
      self.ConfTypeT          = LoadValueFromXMLFile(self.ConfigXMLObject,'typet',self.ConfTypeT)
      self.ConfTransiOpt      = LoadValueFromXMLFile(self.ConfigXMLObject,'transiopt',self.ConfTransiOpt)
      self.ConfBgFile         = LoadValueFromXMLFile(self.ConfigXMLObject,'bgfile',self.ConfBgFile)
      self.ConfBgColor        = LoadValueFromXMLFile(self.ConfigXMLObject,'bgcolor',self.ConfBgColor)

      #Others Configuration options
      ForceMaximized          = LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-ismaximized',0)
      self.CheckCodecAtStartup= LoadValueFromXMLFile(self.ConfigXMLObject,'CheckCodecAtStartup',self.CheckCodecAtStartup)

      # Main windows
      self.win=Gui_Main()
      self.win.statusbar.showMessage(self.qtapp.translate("main","Ready"))
      
      #Init Timeline
      self.win.timeline.horizontalHeader().hide()
      self.win.timeline.verticalHeader().hide()
      self.win.timeline.setRowCount(1)
      self.win.timeline.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOn)
      self.win.timeline.setShowGrid(False)
      self.SelectionEnCours=None

      #Init TableZoomPoint
      self.win.TableZoomPoint.horizontalHeader().hide()
      self.win.TableZoomPoint.verticalHeader().hide()
      self.win.TableZoomPoint.setColumnCount(1)
      self.win.TableZoomPoint.setShowGrid(False)

      self.index=-1

      #Init TAB Montage
      self.win.imgformat.setCurrentIndex(self.imgformat)

      #Init TAB Image
      # Create transition list
      self.lstT=LstTransi(self)
      self.win.typet.addItems(self.lstT)
      self.RANDOMTRANSITIONTYPE=self.win.typet.count()
      self.win.transiopt.addItem(QIcon("iconstr/tr-00-00.png"),self.qtapp.translate("main","No Option"))

      # Restore Windows Settings (size/position/state) if needed
      try:
        if self.RestoreWindowState=="1":
          Rx=int(LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-x',0))
          Ry=int(LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-y',0))
          Rw=int(LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-width',0))
          Rh=int(LoadValueFromXMLFile(self.ConfigXMLObject,'WindowsSettings-height',0))
          self.win.move(Rx,Ry)
          self.win.resize(Rw,Rh)
          #ForceMaximized already loaded during configuration file initialisation
          if ForceMaximized!="0": self.win.showMaximized()
      except:
        None

      #setup Timeline heigh depend on self.ThumbnailsSize
      self.App_ChTThumbnailSize(False)

      # Difference between Posix and Nt plateforme
      if os.name == 'nt' : actionButton="triggered()"
      else : actionButton="activated()"

      #---------------------------------------------
      # Qt SLOT/SIGNAL connection
      #---------------------------------------------

      #application handler
      self.qtapp.connect(self.win.action_Exit,SIGNAL(actionButton),self.App_CloseApp)
      self.qtapp.connect(self.qtapp, SIGNAL("lastWindowClosed()"),self.App_CloseApp)
      self.qtapp.connect(self.win,SIGNAL("resizeEvent(QResizeEvent)"),self.App_ResizeEvent)
      self.qtapp.connect(self.win.option,SIGNAL("currentChanged(int)"),self.App_DisplayPixMainWin)

      #file manipulation function
      self.qtapp.connect(self.win.action_New,SIGNAL(actionButton),self.File_NewProject)
      self.qtapp.connect(self.win.action_Open,SIGNAL(actionButton),self.File_OpenProject)
      self.qtapp.connect(self.win.action_Save,SIGNAL(actionButton),self.File_SaveProject)
      self.qtapp.connect(self.win.actionSave_as,SIGNAL(actionButton),self.File_SaveAsProject)

      #TAB Montage Option
      self.qtapp.connect(self.win.soundfile,SIGNAL("lostFocus()"),self.TAB_Montage_ChgSndFile)
      self.qtapp.connect(self.win.soundfilea,SIGNAL("clicked()"),self.TAB_Montage_BrowseSndFile)
      self.qtapp.connect(self.win.imgformat,SIGNAL("activated(int)"),self.TAB_Montage_SetImgFormat)
      self.qtapp.connect(self.win.DefTextBtMontage,SIGNAL("pressed()"),self.TAB_Montage_DefText)
      self.qtapp.connect(self.win.DeviceTypeCB,SIGNAL("currentIndexChanged(int)"),self.TAB_Montage_ChgDeviceType)
      self.qtapp.connect(self.win.DeviceModelCB,SIGNAL("currentIndexChanged(int)"),self.TAB_Montage_ChgDeviceModel)
      self.qtapp.connect(self.win.OutputCodecCB,SIGNAL("currentIndexChanged(int)"),self.TAB_Montage_ChgOutputCodec)
      self.qtapp.connect(self.win.OutputFormatCB,SIGNAL("currentIndexChanged(int)"),self.TAB_Montage_ChgOutputFormat)

      #TAB Image
      self.qtapp.connect(self.win.typet,SIGNAL("currentIndexChanged(int)"),self.TAB_Image_ChgTrOption)
      self.qtapp.connect(self.win.transiopt,SIGNAL("currentIndexChanged(int)"),self.TAB_Image_ChgOptTr)
      #self.qtapp.connect(self.win.time,SIGNAL("valueChanged(int)"),self.TAB_Image_ChgTime)
      self.qtapp.connect(self.win.speedt,SIGNAL("activated(int)"),self.TAB_Image_ChoixSpeedT)
      self.qtapp.connect(self.win.bgfile,SIGNAL("lostFocus()"),self.TAB_Image_ChgBgFile)
      self.qtapp.connect(self.win.bgfilea,SIGNAL("clicked()"),self.TAB_Image_BrowseBgFile)
      self.qtapp.connect(self.win.bgcolor,SIGNAL("lostFocus()"),self.TAB_Image_ChgBgColor)
      self.qtapp.connect(self.win.bgcolora,SIGNAL("clicked()"),self.TAB_Image_BrowseBgColor)
      self.qtapp.connect(self.win.DefTextBtImage,SIGNAL("pressed()"),self.TAB_Image_DefText)

      #Timeline action
      self.qtapp.connect(self.win.actionAdd,SIGNAL(actionButton),self.Timeline_BrowseAddImage)
      self.qtapp.connect(self.win.actionAddtitle,SIGNAL(actionButton),self.Timeline_AddTitle)
      self.qtapp.connect(self.win.actionMove_right,SIGNAL(actionButton),self.Timeline_MoveItemToRight)
      self.qtapp.connect(self.win.actionMove_left,SIGNAL(actionButton),self.Timeline_MoveItemToLeft)
      self.qtapp.connect(self.win.actionRemove,SIGNAL(actionButton),self.Timeline_DeleteItem)
      self.qtapp.connect(self.win.timeline,SIGNAL("itemSelectionChanged()"),self.Timeline_ChgSelectedItem)

      #TableZoomPoint and TAB Zoom action
      self.qtapp.connect(self.win.addZoomPoint,SIGNAL("pressed()"),self.TableZoomPoint_AddPoint)
      self.qtapp.connect(self.win.moveZoomPointToLeft,SIGNAL("pressed()"),self.TableZoomPoint_MoveItemToUp)
      self.qtapp.connect(self.win.moveZoomPointToRight,SIGNAL("pressed()"),self.TableZoomPoint_MoveItemToDown)
      self.qtapp.connect(self.win.removeZoomPoint,SIGNAL("pressed()"),self.TableZoomPoint_DeleteItem)
      self.qtapp.connect(self.win.ZoomPointTimeFixe,SIGNAL("valueChanged(int)"),self.TableZoomPoint_ChgTimeFixe)
      self.qtapp.connect(self.win.ZoomPointTimeTravel,SIGNAL("valueChanged(int)"),self.TableZoomPoint_ChgTimeToTravel)
      self.qtapp.connect(self.win.TableZoomPoint,SIGNAL("itemSelectionChanged()"),self.TableZoomPoint_ChgSelectedItem)
      self.qtapp.connect(self.win.ZoomPointXValue,SIGNAL("valueChanged(double)"),self.TableZoomPoint_ChgZoomPointXValue)
      self.qtapp.connect(self.win.ZoomPointYValue,SIGNAL("valueChanged(double)"),self.TableZoomPoint_ChgZoomPointYValue)
      self.qtapp.connect(self.win.ZoomPointZoomValue,SIGNAL("valueChanged(double)"),self.TableZoomPoint_ChgZoomPointZoomValue)
      self.qtapp.connect(self.win.DefZoomPointBt,SIGNAL("pressed()"),self.TableZoomPoint_DefZoomPoint)
      self.qtapp.connect(self.win.DefTextBtZoomPoint,SIGNAL("pressed()"),self.TableZoomPoint_DefZoomPointText)
      #Other toolbar action
      self.qtapp.connect(self.win.actionConfiguration,SIGNAL(actionButton),self.Conf_DialogBox)
      self.qtapp.connect(self.win.action_About,SIGNAL(actionButton),self.App_About)
      self.qtapp.connect(self.win.actionDocumentation,SIGNAL(actionButton),self.App_Documentation)
      self.qtapp.connect(self.win.outputfilea,SIGNAL("clicked()"),self.App_BrowseOutputFile)
      self.qtapp.connect(self.win.outputfile,SIGNAL("editingFinished()"),self.App_ChOutputFile)
      self.qtapp.connect(self.win.start,SIGNAL("clicked()"),self.App_DoRender)
      self.qtapp.connect(self.win.serie,SIGNAL(actionButton),self.App_ProcessSerieDialog)
      self.qtapp.connect(self.win.actionPreview,SIGNAL(actionButton),self.App_Preview)
      self.qtapp.connect(self.win.actionVideo_player,SIGNAL(actionButton),self.App_MplayerView)

      # Display main window
      self.win.show()
      #check config
      self.check_CheckConfig(False,ForceConfig)
      #if firsttime : open the configuration dialogbox
      if ForceConfig==True: self.Conf_DialogBox()

      # Parse Output Format Definition
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          self.win.DeviceTypeCB.addItem(OutputDeviceType.getAttribute("Name"))
      self.win.DeviceTypeCB.setCurrentIndex(self.win.DeviceTypeCB.findText(self.ConfOFDDeviceType))
      self.win.DeviceModelCB.setCurrentIndex(self.win.DeviceModelCB.findText(self.ConfOFDDeviceModel))
      self.win.OutputCodecCB.setCurrentIndex(self.win.OutputCodecCB.findText(self.ConfOFDOutputCodec))
      self.win.OutputFormatCB.setCurrentIndex(self.win.OutputFormatCB.findText(self.ConfOFDOutputFormat))
      self.StopMAJOFD = False

      #Init new project
      self.IsProjectModified=False
      self.File_NewProject()
      
      # If option -idv + idv file -> Open file
      if len(args) > 2 :
        if args[2] == "-idv" :
          self.ProjectFilePathName=args[3]
          #Import configurations data from xml file
          try:
            fo2=open(self.ProjectFilePathName,'r')
            self.ProjectXMLObject=minidom.parse(fo2)
            fo2.close()
            #Make object from XML data
            self.File_MakeFromXML()
          except:
            print self.qtapp.translate("main","Opening ")+self.ProjectFilePathName
            
      # Display lenght time.
      self.App_DisplayLenght()
      self.App_DisplayPixMainWin(0)
      # Start app
      self.qtapp.exec_()
      
    #----------------------------------------------------------------------------------------
    # Petite fonction pour forcer les réaffichages en vidant l'EventLoop !
    #----------------------------------------------------------------------------------------
    def WaitEvents(self):
        i=0
        while i<250:
          QCoreApplication.processEvents()
          i+=1

    #----------------------------------------------------------------------------------------
    # closeApp : when videoporama stop
    #----------------------------------------------------------------------------------------
    def App_CloseApp(self):
      if self.BLOCKCloseApp: return
      #Ask to save project before continuing if current project not save
      if self.IsProjectModified:
        self.BLOCKCloseApp=True
        reply = QtGui.QMessageBox.question(self.win, self.qtapp.translate("main","New project"),
          self.qtapp.translate("main","Current project was modified.\nSave it now before continuing ?"),
          QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply==QtGui.QMessageBox.Yes: self.File_SaveProject()

      # Save Windows size/position on exit
      if self.win.isMaximized():  state=1
      else : state=0
      size=self.win.frameGeometry()

      # upate xml conf document for windows state/size/position
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-ismaximized",unicode(state))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-x",unicode(size.x()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-y",unicode(size.y()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-width",unicode(size.width()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-height",unicode(size.height()))

      #other
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirImage",unicode(self.lastDirImage))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirProject",unicode(self.lastDirProject))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirSound",unicode(self.lastDirSound))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirRender",unicode(self.lastDirRender))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirBackground",unicode(self.lastDirBackground))

      #save the config file
      fisa=open(self.ConfigFilePathName,'w')
      #fisa.write(self.ConfigXMLObject.toprettyxml(encoding='utf-8'))
      fisa.write(self.ConfigXMLObject.toxml('utf-8'))
      fisa.close()

      self.qtapp.quit()

    #-------------------------------------------------------------------------------------------------
    # App_DisplayPixMainWin : function call each time the preview zone (main window) need to be update
    #-------------------------------------------------------------------------------------------------
    def App_DisplayPixMainWin(self,TabToDisplay) :
      if self.StopUpdatePixDuringNewSelect==True : return
      #Aspect ratio rendering
      OuputWidth=float(self.win.preview.width())
      if self.imgformat==1 : OutputHeight=float((OuputWidth/16)*9)
      else :                 OutputHeight=float((OuputWidth/4)*3)
      if OutputHeight>self.win.preview.height():
      #Retry for OuputWidth if image is not landscape
        OutputHeight=float(self.win.preview.height())
        if self.imgformat==1 : OuputWidth=float((OutputHeight/9)*16)
        else :                 OuputWidth=float((OutputHeight/3)*4)
      #Calc position
      DecalX=float(self.win.preview.width()-OuputWidth)/2
      DecalY=float(self.win.preview.height()-OutputHeight)/2
      #Create Background QImage
      bkgpix = QImage(QSize(self.win.preview.width(),self.win.preview.height()),QImage.Format_ARGB32_Premultiplied)
      p=QPainter(bkgpix)
      p.fillRect(QRect(0,0,self.win.preview.width(),self.win.preview.height()),toqcolor(QString("afafaf").toInt(16)[0]))
      p.end()
      if (self.index != -1) :
        image=self.win.timeline.cellWidget(0,self.index)
        if image!=None:
          # Zoom and travel TAB
          i = self.win.TableZoomPoint.currentRow()
          if i > -1 : Dessin=image.ToRenderImageForDisplay(i,OuputWidth,OutputHeight)
          else :      Dessin=image.ToRenderImageForDisplay(0,OuputWidth,OutputHeight)
          if self.XMLText!=None: Dessin=ApplyTextToQImage(Dessin,self.XMLText.getElementsByTagName(u"SaveXML")[0])
          p=QPainter(bkgpix)
          p.drawImage(DecalX,DecalY,Dessin)
          p.end()
      self.win.preview.setPixmap(QPixmap.fromImage(bkgpix))

    #----------------------------------------------------------------------------------------
    # App_ResizeEvent : when main videoporama window is resize
    #----------------------------------------------------------------------------------------
    def App_ResizeEvent(self, event) :
      try:
        self.App_DisplayPixMainWin(self.win.option.currentIndex())
      except:
        None

    #----------------------------------------------------------------------------------------
    # App_ResizeEvent : when main videoporama window is resize
    #----------------------------------------------------------------------------------------
    def App_ChTThumbnailSize(self,Reload=True) :
      if self.ThumbnailsSize==0:
        self.win.timeline.setMinimumSize(QtCore.QSize(0, 80))
        self.win.timeline.setMaximumSize(QtCore.QSize(16777215, 80))
      elif self.ThumbnailsSize==1:
        self.win.timeline.setMinimumSize(QtCore.QSize(0, 120))
        self.win.timeline.setMaximumSize(QtCore.QSize(16777215, 120))
      else:
        self.win.timeline.setMinimumSize(QtCore.QSize(0, 150))
        self.win.timeline.setMaximumSize(QtCore.QSize(16777215, 150))
      self.win.timeline.setRowHeight(0,self.win.timeline.height()-18)
      self.win.TableZoomPoint.setColumnWidth(0,self.win.TableZoomPoint.width()-18)
      if Reload :
        #--------------------------------
        #Reload project to apply new size
        #--------------------------------
        #ensure ProjectXMLObject is created
        self.File_CreateXMLObject()
        #clean all
        self.StopUpdatePixDuringEmpty=True
        self.Timeline_Empty()
        self.StopUpdatePixDuringEmpty=False
        self.win.outputfile.clear()
        self.win.bgfile.clear()
        self.win.bgcolor.clear()
        self.win.soundfile.clear()
        #Make object from XML data
        self.File_MakeFromXML(True,False)

    #----------------------------------------------------------------------------------------
    # Function for set all elements in the main windows
    #----------------------------------------------------------------------------------------
    def App_SetupInterface(self):
      self.StopSetupInterface = True
      NbrImageItem = self.win.timeline.columnCount()
      if NbrImageItem>0:
        self.index = self.win.timeline.currentColumn()
        if self.index==-1:
          #if none is selected, force select the first
          self.win.timeline.setCurrentCell(0,0)
          self.index = self.win.timeline.currentColumn()
          return
        image=self.win.timeline.cellWidget(0,self.index)
        row=self.win.TableZoomPoint.currentRow()
        if row!=-1 : ZoomPointItem=self.win.TableZoomPoint.cellWidget(row,0)
        else : ZoomPointItem=None
      else:
        self.index    = -1
        image         = None
        ZoomPointItem = None

      self.App_WindowTitleAndFlag()

      #----------------------------------------
      #TAB Montage Option
      #----------------------------------------
      self.win.imgformat.setCurrentIndex(self.imgformat)
      self.win.soundfile.setText(self.soundfile)
      
      self.StopMAJOFD=True
      self.win.DeviceTypeCB.setCurrentIndex(self.win.DeviceTypeCB.findText(self.OFDDeviceType))
      self.win.DeviceModelCB.setCurrentIndex(self.win.DeviceModelCB.findText(self.OFDDeviceModel))
      self.win.OutputCodecCB.setCurrentIndex(self.win.OutputCodecCB.findText(self.OFDOutputCodec))
      self.win.OutputFormatCB.setCurrentIndex(self.win.OutputFormatCB.findText(self.OFDOutputFormat))
      self.StopMAJOFD=False

      #----------------------------------------
      #TAB Image
      #----------------------------------------
      self.win.bgcolor.setDisabled(image==None)
      self.win.bgcolora.setDisabled(image==None)
      self.win.bgfile.setDisabled(image==None)
      self.win.bgfilea.setDisabled(image==None)
      self.win.ZoomPointTimeFixe.setDisabled(image==None)
      self.win.ZoomPointTimeTravel.setDisabled(image==None)
      self.win.speedt.setDisabled(image==None)
      self.win.typet.setDisabled(image==None)
      self.win.transiopt.setDisabled(image==None)
      self.win.DefTextBtImage.setDisabled(image==None)

      if image!=None:
        self.win.bgcolor.setText(unicode(image.bgcolor))
        color=toqcolor(QString(image.bgcolor).toInt(16)[0])
        qp=QPalette()
        qp.setColor(QPalette.Base,color)
        self.win.bgcolor.setPalette(qp)
        self.win.bgfile.setText(image.bgfile)
        self.win.speedt.setCurrentIndex(int(image.speedt))
        self.win.typet.setCurrentIndex(int(image.typet))
        self.win.transiopt.setCurrentIndex(int(image.opttransi))
      else:
        self.win.bgcolor.setText(unicode(self.ConfBgColor))
        color=toqcolor(QString(self.ConfBgColor).toInt(16)[0])
        qp=QPalette()
        qp.setColor(QPalette.Base,color)
        self.win.bgcolor.setPalette(qp)
        self.win.bgfile.setText(self.ConfBgFile)
        self.win.speedt.setCurrentIndex(int(self.ConfSpeedT))
        self.win.typet.setCurrentIndex(int(self.ConfTypeT))
        self.win.transiopt.setCurrentIndex(int(self.ConfTransiOpt))

      #----------------------------------------
      #Timeline action
      #----------------------------------------
      self.win.actionMove_left.setDisabled(image==None or NbrImageItem<2 or self.index==0)
      self.win.actionMove_right.setDisabled(image==None or NbrImageItem<2 or self.index==NbrImageItem-1)
      self.win.actionRemove.setDisabled(self.index==-1)
      self.win.actionPreview.setDisabled(NbrImageItem==0)

      #----------------------------------------
      #TableZoomPoint action
      #----------------------------------------
      self.win.addZoomPoint.setDisabled(image==None)
      self.win.moveZoomPointToLeft.setDisabled(image==None or self.win.TableZoomPoint.rowCount()<2 or self.win.TableZoomPoint.currentRow()==0)
      self.win.moveZoomPointToRight.setDisabled(image==None or self.win.TableZoomPoint.rowCount()<2 or self.win.TableZoomPoint.currentRow()==self.win.TableZoomPoint.rowCount()-1)
      self.win.removeZoomPoint.setDisabled(image==None or self.win.TableZoomPoint.rowCount()<2)
      self.win.ZoomPointXValue.setDisabled(ZoomPointItem==None)
      self.win.ZoomPointYValue.setDisabled(ZoomPointItem==None)
      self.win.ZoomPointZoomValue.setDisabled(ZoomPointItem==None)
      self.win.DefZoomPointBt.setDisabled(ZoomPointItem==None)
      self.win.DefTextBtZoomPoint.setDisabled(ZoomPointItem==None)
      self.win.ZoomPointTimeFixe.setDisabled(ZoomPointItem==None)

      if ZoomPointItem!=None : 
        #if an item is selected in TableZoomPoint
        ZoomPointItem.SetupInterface()
        self.win.ZoomPointTimeTravel.setDisabled(self.win.TableZoomPoint.currentRow()==0)
        if self.win.TableZoomPoint.currentRow()==0: self.win.ZoomPointTimeTravel.setValue(0)
      else :
        #if no item in TableZoomPoint
        self.win.ZoomPointXLabel.setText("")
        self.win.ZoomPointYLabel.setText("")
        self.win.ZoomPointZoomLabel.setText("")
        self.win.ZoomPointTimeFixe.setValue(0)
        self.win.ZoomPointTimeTravel.setValue(0)

      if self.ConfDisplayUnit=="0":
        #Display unit in %
        self.win.ZoomPointXValue.setDecimals(2)
        self.win.ZoomPointYValue.setDecimals(2)
        self.win.ZoomPointZoomValue.setDecimals(2)
      else:
        #Display unit in pixel
        self.win.ZoomPointXValue.setDecimals(0)
        self.win.ZoomPointYValue.setDecimals(0)
        self.win.ZoomPointZoomValue.setDecimals(0)

      #----------------------------------------
      #Other toolbar action
      #----------------------------------------
      #self.win.actionVideo_player.setDisabled(NbrImageItem==0)
      self.win.serie.setDisabled(NbrImageItem==0)
      self.win.outputfile.setText(self.outputFile)
      self.App_DisplayLenght()
      self.StopSetupInterface = False

    #----------------------------------------------------------------------------------------
    # Function to calcul project duration and set it
    #----------------------------------------------------------------------------------------
    def App_DisplayLenght(self) :
      try:
        xmlroot        =self.OutputOFDXMLObject.getElementsByTagName(u"VideoporamaOutputFormatDefinition")[0]
        xmlDeviceType  =getElementsByAttributName(xmlroot,self.OFDDeviceType)
        xmlDeviceModel =getElementsByAttributName(xmlDeviceType,self.OFDDeviceModel)
        xmlOutputCodec =getElementsByAttributName(xmlDeviceModel,self.OFDOutputCodec)
        if self.imgformat==1: xmlGeometry=getElementsByAttributName(xmlOutputCodec,"Wide - 16:9")
        else: xmlGeometry=getElementsByAttributName(xmlOutputCodec,"Normal - 4:3")
        xmlFormat      =getElementsByAttributName(xmlGeometry,self.OFDOutputFormat)
        imgpsec        =xmlFormat.getAttribute(u'FPS')
      except:
        imgpsec="25"

      imgpsec=int(imgpsec)
      if imgpsec==30 : ips=float(30000/1001)
      else :           ips=imgpsec

      self.totimage = 0
      k=0
      while k<self.win.timeline.columnCount() :
        Image=self.win.timeline.cellWidget(0,k)
        if Image!=None:
          if k==(self.win.timeline.columnCount()-1): self.totimage += Image.CalcImageTime(imgpsec)[1]
          else : self.totimage += Image.CalcImageTime(imgpsec)[1]-Image.CalcImageTime(imgpsec)[5]
        k+=1
      self.win.duration.setText(frameToTime(self.totimage, ips))

    #----------------------------------------------------------------------------------------
    # Function for set Window Title and Flag
    #----------------------------------------------------------------------------------------
    def App_WindowTitleAndFlag(self):
      Title="Videoporama - "
      if self.IsProjectModified: Title=Title+"*"
      if self.ProjectFilePathName=="":
        Title=Title+"<"+self.qtapp.translate("main","new file")+">"
      else:
        Title=Title+self.ProjectFilePathName
      self.win.setWindowTitle(Title)

    #----------------------------------------------------------------------------------------
    # Function for set Window Title and Flag
    #----------------------------------------------------------------------------------------
    def App_SetModifiedFlag(self):
      if self.IsProjectModified==False and self.StopUpdatePixDuringNewSelect==False:
        self.IsProjectModified=True
        self.App_WindowTitleAndFlag()

    #----------------------------------------------------------------------------------------
    # Function call each time Output Filename is set by user
    #----------------------------------------------------------------------------------------
    def App_ChOutputFile(self): #OK QT4
      of=self.win.outputfile.text()
      if not of.isEmpty() :
        if os.name != 'nt' :
          if of.startsWith(u"~/") :
            of.replace(0,1,self.homeDir)
          if not of.startsWith(u"/") :
            of=self.T+of
        else :
          if len(of)>2 and of[1]==":":
            None
          else : 
            of=self.homeDir+of
          of=validatePath(of,False)
          print "Validate path="+unicode(of)
            
        if of!=self.outputFile:
          self.outputFile=of
          self.lastDirRender=os.path.split(unicode(file))[0]
          self.win.outputfile.setText(of)
          self.App_SetModifiedFlag()

    #----------------------------------------------------------------------------------------
    # Function for selecting an Output Filename with browse
    #----------------------------------------------------------------------------------------
    def App_BrowseOutputFile(self): #OK QT4
      file=QFileDialog.getSaveFileName(self.win, self.qtapp.translate("main","File Dialog"),self.lastDirRender, "")
      if file!="" and file!=self.outputFile :
        if os.name == 'nt' : file=validatePath(file,False)
        self.outputFile=file
        self.lastDirRender=os.path.split(unicode(file))[0]
        self.win.outputfile.setText(self.outputFile)
        self.App_SetModifiedFlag()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# Other toolbar action
#-----------------------------------------------------------------------------------------------------------------------------------------------
    #----------------------------------------------------------------------------------------
    # Preview process
    #----------------------------------------------------------------------------------------
    def App_Preview(self) :
      #ensure ProjectXMLObject is created
      self.File_CreateXMLObject()
      self.prevmontage=process(self.ProjectXMLObject,self.ConfigXMLObject,self,self.OutputOFDXMLObject,self.imgformat,True,self)
      self.prevmontage.start()
      #self.prevmontage.run()

    #----------------------------------------------------------------------------------------
    # Render process
    #----------------------------------------------------------------------------------------
    def App_DoRender(self) :
      #ensure ProjectXMLObject is created
      self.File_CreateXMLObject()
      
      self.prc=process(self.ProjectXMLObject,self.ConfigXMLObject,self,self.OutputOFDXMLObject,self.imgformat,False,self)
      if self.prc.err==0 :
        self.showprog=ShowProgress(self,self.win,self.MP,self.prc.totimage,self.prc)
        self.showprog.show()
        #self.prc.run()
        self.prc.start()
        self.showprog.FileName=unicode(self.prc.o+self.prc.ext)
        self.qtapp.connect(self.prc,SIGNAL("image"),self.App_DoRenderDisplayImg)
        self.qtapp.connect(self.prc,SIGNAL("frame"),self.App_DoRenderInfoFrame)

    def App_DoRenderDisplayImg(self,img) :
      if self.win.imgformat.currentIndex() == 0 : wimg = 400
      else :                                      wimg = 533
      self.showprog.viewimg.setPixmap(QPixmap.fromImage(img.ToRenderImageForDisplay(0,wimg ,300 )))
      self.showprog.viewimg.setAlignment(Qt.AlignCenter)

    def App_DoRenderInfoFrame(self,frame) :
      txt=self.qtapp.translate("Show","processing frame ")+unicode(frame)+self.qtapp.translate("Show"," from ")+unicode(int(self.prc.totimage))
      self.showprog.info.setText(txt)
      self.showprog.progressBar1.setValue(frame)
      if int(frame)==self.showprog.totframe : self.showprog.activideo()

    #----------------------------------------------------------------------------------------
    # start mplayer to view a file
    #----------------------------------------------------------------------------------------
    def App_MplayerView(self) :
      #--------------------------------------------- à faire : vérifier en anglais !
      self.mpview = Mplayer(self,taille=(400,300), choixWidget=(Mplayer.PAS_PRECEDENT_SUIVANT,Mplayer.CURSEUR_A_PART,Mplayer.PARCOURIR), cheminMPlayer=self.MP)
      self.mpview.setWindowTitle(self.qtapp.translate("main","Video Player"))
      self.mpview.show()

    #----------------------------------------------------------------------------------------
    # About Dialog box
    #----------------------------------------------------------------------------------------
    def App_About(self) :
      aboutw=About(self.win)
      aboutw.show()
      self.qtapp.connect(aboutw.closeabout,SIGNAL("clicked()"),aboutw,SLOT("close()"))

    #----------------------------------------------------------------------------------------
    # Documentation Dialog box
    #----------------------------------------------------------------------------------------
    def App_Documentation(self) :
      docw=DocHelp(self,self.win)
      docw.SetSourceDocument(self.qtapp.translate("link","en-main.html"))
      docw.show() 

    #----------------------------------------------------------------------------------------
    # Serie dialog box and process
    #----------------------------------------------------------------------------------------
    def App_ProcessSerieDialog(self) :
      self.winserie=Lot(self.lstT,self,self.win)
      self.winserie.fromc.setMaximum(self.win.timeline.columnCount())
      self.winserie.toc.setMaximum(self.win.timeline.columnCount())
      self.winserie.show()
      self.qtapp.connect(self.winserie.buttonBox,SIGNAL("accepted()"),self.App_ProcessSerieDo)

    def App_ProcessSerieDo(self) :
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      #if user forget to add line : add current selection
      if self.winserie.tableImage.rowCount() == 0 : self.winserie.validLineA()
      #Process all line
      Cur=0
      while Cur < self.winserie.tableImage.rowCount() :
        option=self.winserie.tableImage.item(Cur,2).text().split(":")
        imF   =self.winserie.tableImage.item(Cur,0).text()
        imL   =self.winserie.tableImage.item(Cur,1).text()
        i=int(imF)-1
        while i <= (int(imL)-1) :
          if unicode(option[0].split("=")[0])=="1" :
            UpdateAttributXMLFile(self.win.timeline.cellWidget(0,i).ZoomPointList,u"Point-0",u"timeFixe",unicode(option[0].split("=")[1]),u"ZoomPointTable")
            if i==self.win.timeline.currentRow(): self.win.TableZoomPoint.cellWidget(0,0).timeFixe=int(unicode(option[0].split("=")[1]))
          if unicode(option[1].split("=")[0])=="1" : self.win.timeline.cellWidget(0,i).bgfile   =unicode(option[1].split("=")[1])
          if unicode(option[2].split("=")[0])=="1" : self.win.timeline.cellWidget(0,i).bgcolor  =unicode(option[2].split("=")[1])
          if unicode(option[3].split("=")[0])=="1" : self.win.timeline.cellWidget(0,i).speedt   =unicode(option[3].split("=")[1])
          if unicode(option[4].split("=")[0])=="1" : 
            if int(option[4].split("=")[1])==self.winserie.RANDOMTRANSITIONTYPE:
              transi, optTransi = randomTransi()
              self.win.timeline.cellWidget(0,i).typet    =int(transi)
              self.win.timeline.cellWidget(0,i).opttransi=int(optTransi)
            else:
              self.win.timeline.cellWidget(0,i).typet    =int(option[4].split("=")[1])
              self.win.timeline.cellWidget(0,i).opttransi=int(option[5])
          #refresh image and timeline thumbnail
          self.win.timeline.cellWidget(0,i).ResetThumb()
          i+=1
        Cur+=1
      self.App_SetupInterface()
      self.App_DisplayLenght()
      self.App_SetModifiedFlag()
      self.App_DisplayPixMainWin(self.win.option.currentIndex())
      self.qtapp.restoreOverrideCursor()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# Status_conf dialog box : Check configuration and display report
#-----------------------------------------------------------------------------------------------------------------------------------------------

    def check_CheckConfig(self,ConfigWindow=True,ForceHide=False):
      #if call was made from the configuration dialog box, first save the config
      if ConfigWindow==True: self.Conf_SaveConfig(False)

      # init dialog box if need or if self.CheckCodecAtStartup not check
      if (ConfigWindow==True) or (ForceHide==False and self.CheckCodecAtStartup!="2"):
        ok=QIcon(QPixmap("icons/ok.png"))
        nok=QIcon(QPixmap("icons/nok.png"))
        self.statconf=StatusConf(self.win)
      else : self.statconf=None

      #Check FFMpeg directory configuration
      if IsPathExist(self.I):
        if IsBinaryFileExist(self.I+"ffmpeg"):
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,"FFmpeg"+self.qtapp.translate("main"," is correctly configured")))
        else:
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"FFmpeg : "+self.qtapp.translate("main","not found, check the configuration")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"FFmpeg "+self.qtapp.translate("main",": The configuration directory is not define, check the configuration")))

      #Check ffmpeg abilities
      self.fmsg = 0
      self.msgffmpeg = QStringList()
      self.listformats = QStringList()
      self.convertformat = []

      try:
        f = subprocess.Popen(validateCommande(self.I+"ffmpeg")+' -formats', shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        FormatToTest=[
          #Video codec test
          ["RAW DV (dv)","dv"],
          ["MPEG1","mpeg1video"],
          ["MPEG2","mpeg2video"],
          ["Flash","flv"],
          ["Theora","libtheora"],
          ["MJPEG","mjpeg"],
          ["Xvid","libxvid"],
          ["H264","libx264"],
          ["WebM (VP8)","libvpx"],
          #Audiocodec test
          ["libfaac AAC (Advanced Audio Codec)","libfaac"],
          ["ADTS AAC (Advanced Audio Codec)","adts"],
          ["libmp3lame MP3 (MPEG audio layer 3)","libmp3lame"],
          ["libvorbis Vorbis","libvorbis"],
          ["Dolby Digital (AC-3)","ac3"],
          ["PCM signed 16-bit little-endian","s16le"],
          
          #File format test
          ["MPEG file format","mpeg"],
          ["MOV file format","mov"],
          ["DV file format","dv"],
          ["AVI file format","avi"],
          ["FLV file format","flv"],
          ["MKV file format","matroska"],
          ["3GP file format","3gp"],
          ["WEBM file format","webm"],
          ["MP4 file format","mp4"]
        ]

        #search all format
        self.AACMode=""
        verffmpeg = f.communicate()[0]
        for ff in FormatToTest :
          if verffmpeg.find(ff[1]) == -1 :  #if format is not found
            self.fmsg = 1
            #add-it to the projet combobox
            if ff[1]!="libfaac" and ff[1]!="adts" and self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The ffmpeg package installed don't include %1 and isn't able to encode in %2. This format will be disable in the user interface.").arg(QString(ff[1])).arg(QString(ff[0]))))

          else :  #if format is found
            if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,self.qtapp.translate("main","The ffmpeg package is able to encode in %1.").arg(QString(ff[0]))))
            if ff[1]=="libfaac" : self.AACMode="libfaac"
            self.listformats.append(ff[1])

        # if AAC not found (search for Codecs: is not a good solution, but, for this moment ...
        if self.AACMode=="" and verffmpeg.find("Codecs:")==-1 : self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The ffmpeg package installed don't include %1 and isn't able to encode in %2. This format will be disable in the user interface.").arg(QString("AAC")).arg(QString("Advanced Audio Codec"))))
      except:
        None
          
      #Check SoX
      if IsPathExist(self.S):
        if IsBinaryFileExist(self.S+"sox"):
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,"SoX"+self.qtapp.translate("main"," is correctly configured")))
          #Check sox abilities
          try:
            s = subprocess.Popen(validateCommande(unicode(self.S+"sox"))+u" -h", shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE).communicate()[0]
            self.msgsox = [u"",u"",u""]
            if s.find("wav") == -1 :
              if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","Wav Format is not supported by your version of Sox. Add required package from your distribution unless you won't be able to make video.")))
            if s.find("ogg") == -1 :
              if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","Ogg Format is not supported by your version of Sox. Add required package from your distribution unless you won't be able to use ogg sound file.")))
            if s.find("mp3") == -1 :
              if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","Mp3 Format is not supported by your version of Sox. Add required package from your distribution unless you won't be able to use mp3 sound file.")))
          except:
            None
        else:
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"SoX : "+self.qtapp.translate("main","not found, check the configuration")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"SoX "+self.qtapp.translate("main",": The configuration directory is not define, check the configuration")))

      #Check MJpegTools
      if IsPathExist(self.MJ):
        if IsBinaryFileExist(self.MJ+"mpeg2enc"):
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,"MJpegTools"+self.qtapp.translate("main"," is correctly configured")))
        else:
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"MJpegTools : "+self.qtapp.translate("main","not found, check the configuration")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"MJpegTools "+self.qtapp.translate("main",": The configuration directory is not define, check the configuration")))

      #Check MPlayer
      if IsPathExist(self.MP):
        if IsBinaryFileExist(self.MP+"mplayer"):
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,"MPlayer"+self.qtapp.translate("main"," is correctly configured")))
        else:
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"MPlayer : "+self.qtapp.translate("main","not found, check the configuration")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,"MPlayer "+self.qtapp.translate("main",": The configuration directory is not define, check the configuration")))

      #Check tempdir
      if IsPathExist(self.T):
        if IsPathWritable(self.T) :
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(ok,self.qtapp.translate("main","The temporary directory is writable")))
        else :
          if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The temporary directory is not writable")))
      else:
        if self.statconf!=None: self.statconf.status.addItem(QListWidgetItem(nok,self.qtapp.translate("main","The temporary directory is not define, check the configuration")))

      if self.statconf!=None: 
        c=int(self.CheckCodecAtStartup)
        self.statconf.chk.setChecked(bool(c))
        self.qtapp.connect(self.statconf.closew,SIGNAL("clicked()"),self.statconf,SLOT("close()"))
        self.statconf.connect(self.statconf.chk,SIGNAL("stateChanged(int)"),self.check_ChgDisplayAtStartup)
        self.statconf.show()

    #Handler for the checkbox "Don't display at startup"
    def check_ChgDisplayAtStartup(self,state):
      self.CheckCodecAtStartup=unicode(state)
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"CheckCodecAtStartup",unicode(state))

#-----------------------------------------------------------------------------------------------------------------------------------------------
# File manipulation functions
#-----------------------------------------------------------------------------------------------------------------------------------------------

    #----------------------------------------------------------------------------------------
    # Create a new Project (to xml file) function
    #----------------------------------------------------------------------------------------
    def File_NewProject(self):
      #Ask to save project before continuing if current project not save
      if self.IsProjectModified:
        reply = QtGui.QMessageBox.question(self.win, self.qtapp.translate("main","New project"),
          self.qtapp.translate("main","Current project was modified.\nSave it now before continuing ?"),
          QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply==QtGui.QMessageBox.Yes: self.File_SaveProject()
    
      #Clean
      self.StopUpdatePixDuringEmpty=True
      self.Timeline_Empty()
      self.StopUpdatePixDuringEmpty=False
      self.win.outputfile.clear()
      self.win.soundfile.clear()
      self.ProjectFilePathName=""
      self.XMLText=None

      #Prepare new data object
      ProjectFilePathName=""
      self.ProjectXMLObject= Document()
      xmltag = self.ProjectXMLObject.createElement(u"Videoporama")
      self.ProjectXMLObject.appendChild(xmltag)

      #init new project with default option from configuration XML object
      self.imgformat          = int(LoadValueFromXMLFile(self.ProjectXMLObject,'imgformat',self.ConfImgFormat,u"Videoporama"))
      self.soundfile          = LoadValueFromXMLFile(self.ProjectXMLObject,'sndfile',"",u"Videoporama")
      self.outputFile         = ""
      self.StopMAJSpinbox = True
      self.win.imgformat.setCurrentIndex(self.imgformat)
      self.win.DeviceTypeCB.setCurrentIndex(self.win.DeviceTypeCB.findText(self.ConfOFDDeviceType))
      self.win.DeviceModelCB.setCurrentIndex(self.win.DeviceModelCB.findText(self.ConfOFDDeviceModel))
      self.win.OutputCodecCB.setCurrentIndex(self.win.OutputCodecCB.findText(self.ConfOFDOutputCodec))
      self.win.OutputFormatCB.setCurrentIndex(self.win.OutputFormatCB.findText(self.ConfOFDOutputFormat))
      self.StopMAJSpinbox = False

      self.IsProjectModified=False
      #Setup interface
      self.App_SetupInterface()
#      self.win.preview.setScene(None)

    #----------------------------------------------------------------------------------------
    # open an existing project (from xml file) function
    #----------------------------------------------------------------------------------------
    def File_OpenProject(self): #OK QT4
      #Ask to save project before continuing if current project not save
      if self.IsProjectModified:
        reply = QtGui.QMessageBox.question(self.win, self.qtapp.translate("main","Open project"),
          self.qtapp.translate("main","Current project was modified.\nSave it now before continuing ?"),
          QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if reply==QtGui.QMessageBox.Yes: self.File_SaveProject()

      #Select a file
      try :
        FileName=QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","Open project"),self.lastDirProject, QString("*.idv (*.idv)"))
        self.WaitEvents() #Pour laisser le temps à la fenêtre de se fermer !
        if FileName!="":
          self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
          self.lastDirProject=os.path.split(unicode(FileName))[0]

          #Clean
          self.StopUpdatePixDuringEmpty=True
          self.Timeline_Empty()
          self.StopUpdatePixDuringEmpty=False
          self.win.outputfile.clear()
          self.win.bgfile.clear()
          self.win.bgcolor.clear()
          self.win.soundfile.clear()

          self.ProjectFilePathName=FileName
          #Import configurations data from xml file
          try:
            fo2=open(self.ProjectFilePathName,'r')
            self.ProjectXMLObject=minidom.parse(fo2)
            fo2.close()
            self.IsProjectModified=False
            #Make object from XML data
            self.File_MakeFromXML()
          except:
            None
        self.qtapp.restoreOverrideCursor()
      except :
        None

    #----------------------------------------------------------------------------------------
    # Save project to file asking for filename (to xml file) function
    #----------------------------------------------------------------------------------------
    def File_SaveAsProject(self):
      #Get a new filename
      FileName=QFileDialog.getSaveFileName(self.win,self.qtapp.translate("main","Save project"),self.lastDirProject, QString("*.idv (*.idv)"))
      if FileName!="":
        self.lastDirProject=os.path.split(unicode(FileName))[0]
        self.ProjectFilePathName=FileName
        #ensure filename have the correct extension
        if unicode(self.ProjectFilePathName).endswith(u'.idv')==False :
          self.ProjectFilePathName=unicode(self.ProjectFilePathName)+u".idv"
        #ensure ProjectXMLObject is created
        self.File_CreateXMLObject()
        #write xml to file
        try:
          fisa=open(self.ProjectFilePathName,'w')
          #fisa.write(self.ProjectXMLObject.toprettyxml(encoding='utf-8'))
          fisa.write(self.ProjectXMLObject.toxml('utf-8'))
          fisa.close()
          self.IsProjectModified=False
          self.App_WindowTitleAndFlag()
        except:
          None

    #----------------------------------------------------------------------------------------
    # saveProject (to xml file) function
    #----------------------------------------------------------------------------------------
    def File_SaveProject(self):
      #if no filename transfert to Save As function
      if self.ProjectFilePathName=="":
        self.File_SaveAsProject()
      else:
        #ensure ProjectXMLObject is created
        self.File_CreateXMLObject()
        #write xml to file
        try:
          fisa=open(self.ProjectFilePathName,'w')
          #fisa.write(self.ProjectXMLObject.toprettyxml(encoding='utf-8'))
          fisa.write(self.ProjectXMLObject.toxml('utf-8'))
          fisa.close()
          self.IsProjectModified=False
          self.App_WindowTitleAndFlag()
        except:
          None

    #----------------------------------------------------------------------------------------
    # Create XMLObject from objects
    #----------------------------------------------------------------------------------------
    def File_CreateXMLObject(self):
      self.ProjectXMLObject= Document()
      xmltag = self.ProjectXMLObject.createElement(u"Videoporama")
      self.ProjectXMLObject.appendChild(xmltag)

      UpdateConfigurationXMLFile(self.ProjectXMLObject,u"outputfile",unicode(self.outputFile),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,u"sndfile",unicode(self.soundfile),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,u"imgformat",unicode(self.imgformat),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,'OFDDeviceType',unicode(self.OFDDeviceType),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,'OFDDeviceModel',unicode(self.OFDDeviceModel),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,'OFDOutputCodec',unicode(self.OFDOutputCodec),u"Videoporama")
      UpdateConfigurationXMLFile(self.ProjectXMLObject,'OFDOutputFormat',unicode(self.OFDOutputFormat),u"Videoporama")

      #Transfert overlaid text to XMLFile
      xmlPoint=self.ProjectXMLObject.getElementsByTagName(u"Videoporama")[0]
      xmlText=xmlPoint.getElementsByTagName(u"Text")
      if xmlText.length>0 :
        xmlText=xmlText[0]
        # Remove only if this child is type image (and not type Zoompoint)
        if xmlText.getAttribute(u"Type")=="Overlaid":
          xmlPoint.removeChild(xmlText)
      if self.XMLText!=None:
        xmlText=self.XMLText.getElementsByTagName(u"Text")
        if xmlText.length>0 :
          xmlText=xmlText[0]
          TextToAdd=self.XMLText.importNode(xmlText,True)
          xmlPoint.appendChild(TextToAdd)

      nitem=self.win.timeline.columnCount()
      i=0
      while i<nitem :
        #Project options
        NameItem="IMG-"+unicode(i)
        UpdateAttributXMLFile(self.ProjectXMLObject,NameItem,'transition',unicode(self.win.timeline.cellWidget(0,i).typet))
        UpdateAttributXMLFile(self.ProjectXMLObject,NameItem,'tr_option',unicode(self.win.timeline.cellWidget(0,i).opttransi))
        UpdateAttributXMLFile(self.ProjectXMLObject,NameItem,'speedt',unicode(self.win.timeline.cellWidget(0,i).speedt))
        UpdateAttributXMLFile(self.ProjectXMLObject,NameItem,'bgcolor',unicode(self.win.timeline.cellWidget(0,i).bgcolor))
        UpdateAttributXMLFile(self.ProjectXMLObject,NameItem,'bgfile',unicode(self.win.timeline.cellWidget(0,i).bgfile))
        UpdateAttributXMLFile(self.ProjectXMLObject,NameItem,'urlimage',unicode(self.win.timeline.cellWidget(0,i).urlim))

        item=self.win.timeline.cellWidget(0,i)
        
        #Transfert image text to XMLFile
        xmlPoint=self.ProjectXMLObject.getElementsByTagName(u"IMG-"+unicode(i))[0]
        xmlText=xmlPoint.getElementsByTagName(u"Text")
        if xmlText.length>0 :
          xmlText=xmlText[0]
          # Remove only if this child is type image (and not type Zoompoint)
          if xmlText.getAttribute(u"Type")=="Image":
            xmlPoint.removeChild(xmlText)
        
        if item.XMLText!=None:
          xmlText=item.XMLText.getElementsByTagName(u"Text")
          if xmlText.length>0 :
            xmlText=xmlText[0]
            TextToAdd=item.XMLText.importNode(xmlText,True)
            xmlPoint.appendChild(TextToAdd)

        #Transfert XML ZoomPointList of each item to XMLFile
        j=0
        x=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+unicode(j),u"x",u"ZoomPointTable")
        while x!="":
          y=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+unicode(j),u"y",u"ZoomPointTable")
          zoom=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+unicode(j),u"zoom",u"ZoomPointTable")
          timeFixe=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+unicode(j),u"timeFixe",u"ZoomPointTable")
          timeToTravel=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+unicode(j),u"timeToTravel",u"ZoomPointTable")
          
          #add zoompoint to xml
          UpdateAttributSubXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(j),'x',unicode(x))
          UpdateAttributSubXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(j),'y',unicode(y))
          UpdateAttributSubXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(j),'zoom',unicode(zoom))
          UpdateAttributSubXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(j),'timeFixe',unicode(timeFixe))
          UpdateAttributSubXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(j),'timeToTravel',unicode(timeToTravel))
          # Transfert ZoompointText item(s)
          xmlDocItem=item.ZoomPointList.getElementsByTagName(u"Point-"+unicode(j))[0]
          xmlDoc=xmlDocItem.getElementsByTagName(u"Text")
          if xmlDoc.length>0 :  # If text exist
            xmlDoc=xmlDoc[0]
            xmlPoint=self.ProjectXMLObject.getElementsByTagName(u"IMG-"+unicode(i))[0]
            xmlPoint=xmlPoint.getElementsByTagName(u"Point-"+unicode(j))[0]
            xmlText=xmlPoint.getElementsByTagName(u"Text")
            if xmlText.length>0 :
              xmlText=xmlText[0]
              xmlPoint.removeChild(xmlText)
            xmlText=xmlDocItem.getElementsByTagName(u"Text")
            if xmlText.length>0 :
              xmlText=xmlText[0]
              TextToAdd=item.ZoomPointList.importNode(xmlDoc,True)
              xmlPoint.appendChild(TextToAdd)
          j+=1
          x=LoadAttributFromXMLFile(item.ZoomPointList,u"Point-"+unicode(j),u"x",u"ZoomPointTable")
        i+=1

    #----------------------------------------------------------------------------------------
    # Read data from ProjectXMLObject and create all object
    #----------------------------------------------------------------------------------------
    def File_MakeFromXML(self,ForceNewImageFormat=False,ForceNewVideoFormat=False): #OK QT4
      #init new project with XML file
      if ForceNewImageFormat==False: self.imgformat = int(LoadValueFromXMLFile(self.ProjectXMLObject,'imgformat',self.ConfImgFormat,u"Videoporama"))
      self.outputFile     = LoadValueFromXMLFile(self.ProjectXMLObject,'outputfile',"",u"Videoporama")
      self.soundfile      = LoadValueFromXMLFile(self.ProjectXMLObject,'sndfile',"",u"Videoporama")
      self.OFDDeviceType  = LoadValueFromXMLFile(self.ProjectXMLObject,'OFDDeviceType',"",u"Videoporama")
      self.OFDDeviceModel = LoadValueFromXMLFile(self.ProjectXMLObject,'OFDDeviceModel',"",u"Videoporama")
      self.OFDOutputCodec = LoadValueFromXMLFile(self.ProjectXMLObject,'OFDOutputCodec',"",u"Videoporama")
      self.OFDOutputFormat= LoadValueFromXMLFile(self.ProjectXMLObject,'OFDOutputFormat',"",u"Videoporama")

      #Search if the project have overlaid text
      xmlPoint=self.ProjectXMLObject.getElementsByTagName(u"Videoporama")[0]
      xmlText =xmlPoint.getElementsByTagName(u"Text")
      if xmlText.length>0 :
        xmlText=xmlText[0]
        # Be sure this child is type Overlaid (and not type image or Zoompoint)
        if xmlText.getAttribute(u"Type")=="Overlaid":
          self.XMLText=Document()
          xmlRoot=self.XMLText.createElement(u"SaveXML")
          self.XMLText.appendChild(xmlRoot)
          xmlRoot.appendChild(self.ProjectXMLObject.importNode(xmlText,True))
      else :
        self.XMLText=None

      # load images
      k=0
      NameItem="IMG-"+unicode(k)
      transition=LoadAttributFromXMLFile(self.ProjectXMLObject,NameItem,'transition',u"Videoporama")
      while transition!="":
        #stop update during this process
        self.StopUpdatePixDuringNewSelect=True

        #create the thumb/image
        col=self.win.timeline.columnCount()
        Image=myLabel(
          LoadAttributFromXMLFile(self.ProjectXMLObject,NameItem,'urlimage',u"Videoporama"),         #urlim = Filename
          LoadAttributFromXMLFile(self.ProjectXMLObject,NameItem,'bgfile',u"Videoporama"),           #background file
          LoadAttributFromXMLFile(self.ProjectXMLObject,NameItem,'bgcolor',u"Videoporama"),          #background color
          LoadAttributFromXMLFile(self.ProjectXMLObject,NameItem,'transition',u"Videoporama"),       #transition type
          LoadAttributFromXMLFile(self.ProjectXMLObject,NameItem,'tr_option',u"Videoporama"),        #transition option
          LoadAttributFromXMLFile(self.ProjectXMLObject,NameItem,'speedt',u"Videoporama"),           #transition duration
          self.imgformat,                                                                            #image format 16/9 or 4/3
          self                                                                                       #Videoporama class instance
        )

        #Search if the image have text
        xmlPoint=self.ProjectXMLObject.getElementsByTagName(NameItem)[0]
        xmlText =xmlPoint.getElementsByTagName(u"Text")
        if xmlText.length>0 :
          xmlText=xmlText[0]
          # Be sure this child is type image (and not type Zoompoint)
          if xmlText.getAttribute(u"Type")=="Image":
            Image.XMLText=Document()
            xmlRoot=Image.XMLText.createElement(u"SaveXML")
            Image.XMLText.appendChild(xmlRoot)
            xmlRoot.appendChild(self.ProjectXMLObject.importNode(xmlText,True))

        self.win.timeline.insertColumn(col)
        hpix=self.win.timeline.height()-18
        if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
        else :            wpix=(hpix-4)*4/3+34
        self.win.timeline.setColumnWidth(col,wpix)
        self.win.timeline.setCellWidget(0,col,Image)

        #Load ZoomPoint
        i=0
        x=LoadAttributSubFromXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(i),'x')
        while x!="":
          y=LoadAttributSubFromXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(i),'y')
          zoom=LoadAttributSubFromXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(i),'zoom')
          timeFixe=LoadAttributSubFromXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(i),'timeFixe')
          timeToTravel=LoadAttributSubFromXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(i),'timeToTravel')
          xmlSourceImage=self.ProjectXMLObject.getElementsByTagName('IMG-'+unicode(k))[0]
          xmlSourcePoint=xmlSourceImage.getElementsByTagName('Point-'+unicode(i))[0]
          xmlText=xmlSourcePoint.getElementsByTagName(u"Text")
          if xmlText.length>0 :
            xmlText =xmlText[0]
            TextToAdd=self.ProjectXMLObject.importNode(xmlText,True)
          else:
            TextToAdd=None

          #Temp : Compatibility with old file
          if timeFixe=="": 
            timeFixe=LoadAttributFromXMLFile(self.ProjectXMLObject,NameItem,'time',u"Videoporama")
            timeToTravel=0

          Image.AddZoomPointItem(float(x),float(y),float(timeFixe),float(zoom),float(timeToTravel),False,False,TextToAdd)
          i+=1
          x=LoadAttributSubFromXMLFile(self.ProjectXMLObject,NameItem,'Point-'+unicode(i),'x')

        #Generate thumbail for this image
        Image.updatePix()
        #Force Display new thumbnail
        self.win.timeline.repaint()
        #update now available
        self.StopUpdatePixDuringNewSelect=False
        #display the thumb/image
        Image.updatePix()
        k+=1
        NameItem=u"IMG-"+unicode(k)
        transition=LoadAttributFromXMLFile(self.ProjectXMLObject,NameItem,'transition',u"Videoporama")

      #end process by setting some properties 
      if self.win.timeline.columnCount() != 0 :
        self.win.serie.setEnabled(True)
        self.win.actionRemove.setEnabled(True)
      self.App_DisplayLenght()
      self.App_SetupInterface()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# Configuration dialog box
#-----------------------------------------------------------------------------------------------------------------------------------------------

    def Conf_DialogBox(self) : #OK QT4
      self.winconfig=Configuration(self.win)

      #Init transition ComboBox
      self.winconfig.typet.insertItems(0,self.lstT)
      self.winconfig.typet.addItem(self.qtapp.translate("main","Random"))
      self.RANDOMTRANSITIONTYPE=self.winconfig.typet.count()-1

      # Difference between Posix and Nt plateforme
      if os.name == 'nt' : actionButton="triggered()"
      else : actionButton="activated()"

      self.qtapp.connect(self.winconfig.saveconfig,SIGNAL("clicked()"),self.Conf_SaveConfig)
      self.qtapp.connect(self.winconfig.chk,SIGNAL("clicked()"),self.check_CheckConfig)

      #TAB Directory configuration : init lineEdit and signal for browse button from each directory configuration
      self.Conf_InitTextOption(self.winconfig.tmpdir,'tmpdir',self.T)
      self.Conf_InitTextOption(self.winconfig.imgmgkdir,'imgmgkdir',self.I)
      self.Conf_InitTextOption(self.winconfig.mjpegtoolsdir,'mjpegtoolsdir',self.MJ)
      self.Conf_InitTextOption(self.winconfig.soxdir,'soxdir',self.S)
      self.Conf_InitTextOption(self.winconfig.mplayerdir,'mplayerdir',self.MP)
      
      self.qtapp.connect(self.winconfig.tmpdirbut,SIGNAL("clicked()"),self.Conf_ChTMPDir)
      self.qtapp.connect(self.winconfig.tmpdir,SIGNAL("editingFinished()"),self.Conf_ChTMPDirEd)
      self.qtapp.connect(self.winconfig.mplayerbut,SIGNAL("clicked()"),self.Conf_ChMPlayerDir)
      self.qtapp.connect(self.winconfig.mplayerdir,SIGNAL("editingFinished()"),self.Conf_ChMPlayerDirEd)
      self.qtapp.connect(self.winconfig.imgmgkbut,SIGNAL("clicked()"),self.Conf_ChFFMPEGDir)
      self.qtapp.connect(self.winconfig.imgmgkdir,SIGNAL("editingFinished()"),self.Conf_ChFFMPEGDirEd)
      self.qtapp.connect(self.winconfig.mjpegtoolsbut,SIGNAL("clicked()"),self.Conf_ChMJPEGToolsDir)
      self.qtapp.connect(self.winconfig.mjpegtoolsdir,SIGNAL("editingFinished()"),self.Conf_ChMJPEGToolsDirEd)
      self.qtapp.connect(self.winconfig.soxbut,SIGNAL("clicked()"),self.Conf_ChSOXDir)
      self.qtapp.connect(self.winconfig.soxdir,SIGNAL("editingFinished()"),self.Conf_ChSOXDirEd)

      #TAB Display configuration : Init & Signal
      self.Conf_InitCBOption(self.winconfig.zoomMode,'zoomVal',self.ConfDisplayUnit)
      self.Conf_InitCBOption(self.winconfig.RestoreWindowState,'WindowsSettings-RestoreWindowState',self.RestoreWindowState)
      self.Conf_InitCBOption(self.winconfig.ThumbnailsSize,'ThumbnailsSize',self.ThumbnailsSize)
      self.qtapp.connect(self.winconfig.ThumbnailsSize,SIGNAL("currentIndexChanged(int)"),self.Conf_ChThumbnailsSize)

      #TAB Default output format : Init & Signal
      self.Conf_InitCBOption(self.winconfig.imgformat,'imgformat',self.ConfImgFormat)
      self.qtapp.connect(self.winconfig.imgformat,SIGNAL("currentIndexChanged(int)"),self.Conf_ChgImgFormat)
      self.qtapp.connect(self.winconfig.DeviceTypeCB,SIGNAL("currentIndexChanged(int)"),self.Conf_ChgDeviceType)
      self.qtapp.connect(self.winconfig.DeviceModelCB,SIGNAL("currentIndexChanged(int)"),self.Conf_ChgDeviceModel)
      self.qtapp.connect(self.winconfig.OutputCodecCB,SIGNAL("currentIndexChanged(int)"),self.Conf_ChgOutputCodec)
      self.qtapp.connect(self.winconfig.zoomMode,SIGNAL("activated(int)"),self.Conf_ChDisplayZoomOption)
      # Parse Output Format Definition
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          self.winconfig.DeviceTypeCB.addItem(OutputDeviceType.getAttribute("Name"))
      self.winconfig.DeviceTypeCB.setCurrentIndex(self.winconfig.DeviceTypeCB.findText(self.ConfOFDDeviceType))
      self.winconfig.DeviceModelCB.setCurrentIndex(self.winconfig.DeviceModelCB.findText(self.ConfOFDDeviceModel))
      self.winconfig.OutputCodecCB.setCurrentIndex(self.winconfig.OutputCodecCB.findText(self.ConfOFDOutputCodec))
      self.winconfig.OutputFormatCB.setCurrentIndex(self.winconfig.OutputFormatCB.findText(self.ConfOFDOutputFormat))
      
      #TAB Standards project options : Init & Signal
      self.Conf_InitIntOption(self.winconfig.time,'time',self.ConfTime)
      self.Conf_InitCBOption(self.winconfig.speedt,'speedt',self.ConfSpeedT)
      self.Conf_InitCBOption(self.winconfig.typet,'typet',self.ConfTypeT)
      self.Conf_ChgTrOption(self.winconfig.typet.currentIndex())
      self.Conf_InitCBOption(self.winconfig.transiopt,'transiopt',self.ConfTransiOpt)
      self.Conf_InitTextOption(self.winconfig.bgfile,'bgfile',self.ConfBgFile)
      xcolor=QString(self.ConfBgColor).toInt(16)[0]
      qp=QPalette()
      qp.setColor(QPalette.Base,toqcolor(xcolor)) 
      self.winconfig.bgcolor.setPalette(qp)
      self.winconfig.bgcolor.setText(colortohex(xcolor))
      self.qtapp.connect(self.winconfig.bgcolora,SIGNAL("clicked()"),self.Conf_BrowseBgColor)
      self.qtapp.connect(self.winconfig.bgfilea,SIGNAL("clicked()"),self.Conf_ChgBgFile)
      self.qtapp.connect(self.winconfig.typet,SIGNAL("currentIndexChanged(int)"),self.Conf_ChgTrOption)
      self.qtapp.connect(self.winconfig.HelpBt,SIGNAL("pressed()"),self.Conf_Documentation)

      #End of init : Display the dialog box
      self.winconfig.show()

    #----------------------------------------------------------------------------------------
    # Documentation Dialog box
    #----------------------------------------------------------------------------------------
    def Conf_Documentation(self) :
      docw=DocHelp(self,self.win)
      docw.SetSourceDocument(self.qtapp.translate("Documentation","en-configbox.html"))
      docw.show() 

    def Conf_ChgDeviceType(self,index):
      self.winconfig.DeviceModelCB.clear()
      # Parse Output Format Definition for filling DeviceModelCB
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          DeviceType=OutputDeviceType.getAttribute("Name")
          if DeviceType==self.winconfig.DeviceTypeCB.itemText(index):
            for OutputDeviceModel in OutputDeviceType.childNodes :
              if OutputDeviceModel.nodeType==OutputDeviceModel.ELEMENT_NODE:
                self.winconfig.DeviceModelCB.addItem(OutputDeviceModel.getAttribute("Name"))

    def Conf_ChgDeviceModel(self,index):
      self.winconfig.OutputCodecCB.clear()
      # Parse Output Format Definition for filling OutputCodecCB
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          DeviceType=OutputDeviceType.getAttribute("Name")
          if DeviceType==self.winconfig.DeviceTypeCB.currentText():
            for OutputDeviceModel in OutputDeviceType.childNodes :
              if OutputDeviceModel.nodeType==OutputDeviceModel.ELEMENT_NODE:
                DeviceModel=OutputDeviceModel.getAttribute("Name")
                if DeviceModel==self.winconfig.DeviceModelCB.itemText(index):
                  for OutputCodec in OutputDeviceModel.childNodes :
                    if OutputCodec.nodeType==OutputCodec.ELEMENT_NODE:
                      self.winconfig.OutputCodecCB.addItem(OutputCodec.getAttribute("Name"))

    def Conf_ChgOutputCodec(self,index):
      self.winconfig.OutputFormatCB.clear()
      TestGeometry=self.winconfig.imgformat.currentText()
      # Parse Output Format Definition for filling OutputFormatCB
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          DeviceType=OutputDeviceType.getAttribute("Name")
          if DeviceType==self.winconfig.DeviceTypeCB.currentText():
            for OutputDeviceModel in OutputDeviceType.childNodes :
              if OutputDeviceModel.nodeType==OutputDeviceModel.ELEMENT_NODE:
                DeviceModel=OutputDeviceModel.getAttribute("Name")
                if DeviceModel==self.winconfig.DeviceModelCB.currentText():
                  for OutputCodec in OutputDeviceModel.childNodes :
                    if OutputCodec.nodeType==OutputCodec.ELEMENT_NODE:
                      Codec=OutputCodec.getAttribute("Name")
                      if Codec==self.winconfig.OutputCodecCB.itemText(index):
                        for OutputGeometry in OutputCodec.childNodes :
                          if OutputGeometry.nodeType==OutputGeometry.ELEMENT_NODE:
                            Geometry=self.qtapp.translate("MainWindow",OutputGeometry.getAttribute("Name"))
                            if Geometry==TestGeometry:
                              for OutputFormat in OutputGeometry.childNodes :
                                if OutputFormat.nodeType==OutputFormat.ELEMENT_NODE:
                                  IsTestVideo=False
                                  IsTestAudio=False
                                  IsTestFile =False
                                  for fmt in self.listformats : 
                                    if fmt==OutputFormat.getAttribute("TestVideo") : IsTestVideo=True
                                    TestAudio=OutputFormat.getAttribute("TestAudio")
                                    if TestAudio=="adts" and self.AACMode=="libfaac" : TestAudio=self.AACMode
                                    if fmt==TestAudio : IsTestAudio=True
                                    if fmt==OutputFormat.getAttribute("TestFile")  : IsTestFile=True
                                  if IsTestVideo and IsTestAudio :
                                    self.winconfig.OutputFormatCB.addItem(OutputFormat.getAttribute("Name"))
      if self.winconfig.OutputFormatCB.count()==0:
        self.winconfig.OutputFormatCB.addItem(self.qtapp.translate("main","No available format"))

    def Conf_ChgImgFormat(self,index):
      self.Conf_ChgOutputCodec(self.winconfig.OutputCodecCB.currentIndex())
      
    #sub to init a Text LineEdit
    def Conf_InitTextOption(self,object,XmlName,default):
      try:
        object.setText(self.ConfigXMLObject.getElementsByTagName(XmlName)[0].childNodes[0].nodeValue)
      except:
        object.setText(default)

    #sub to init a ComboBox
    def Conf_InitCBOption(self,object,XmlName,default):
      try:
        object.setCurrentIndex(int(self.ConfigXMLObject.getElementsByTagName(XmlName)[0].childNodes[0].nodeValue))
      except:
        object.setCurrentIndex(default)

    #sub to init a Int LineEdit
    def Conf_InitIntOption(self,object,XmlName,default):
      try:
        object.setValue(int(self.ConfigXMLObject.getElementsByTagName(XmlName)[0].childNodes[0].nodeValue))
      except:
        object.setValue(default)

    #Function call each time ThumbnailsSize choice is change
    def Conf_ChThumbnailsSize(self,index) :
      self.ThumbnailsSize=index
      self.App_ChTThumbnailSize()
  
    #Function call each time transition choice is change => update option transition list
    def Conf_ChgTrOption(self,index) :
      #Load Transition Option from Transition selected
      z=getTrOptionLst(self,index)
      self.winconfig.transiopt.clear()
      i=0;
      max=len(z)
      while i<max:
        if index==7:
          FNameTr=u"iconstr/"+z[i]+u".png"
        else:
          FNameTr=u"iconstr/tr-0"+unicode(index)+u"-0"+unicode(i)+u".png"
        try:
          self.winconfig.transiopt.addItem(QIcon(FNameTr),z[i])
        except:
          self.winconfig.transiopt.addItem(z[i])
        i=i+1
           
    def Conf_ChTMPDirEd(self) :
      Path=validatePath(self.winconfig.tmpdir.text())
      if (Path!=""):
        self.T=unicode(Path)
        self.winconfig.tmpdir.setText(self.T)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"tmpdir",self.T,1)

    # Action button to browse for directory : TempDir
    def Conf_ChTMPDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self.winconfig, self.qtapp.translate("main","Directory Dialog"), self.homeDir))
      if (Path!=""):
        self.T=unicode(Path)
        self.winconfig.tmpdir.setText(self.T)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"tmpdir",self.T,1)

    def Conf_ChFFMPEGDirEd(self) :
      Path=validatePath(self.winconfig.imgmgkdir.text())
      if (Path!=""):
        self.I=unicode(Path)
        self.winconfig.imgmgkdir.setText(self.I)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"imgmgkdir",self.I,1)

    # Action button to browse for directory : FFMPEGDir
    def Conf_ChFFMPEGDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self.winconfig, self.qtapp.translate("main","Directory Dialog"), self.homeDir))
      if (Path!=""):
        self.I=Path
        self.winconfig.imgmgkdir.setText(self.I)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"imgmgkdir",self.I,1)

    def Conf_ChMJPEGToolsDirEd(self) :
      Path=validatePath(self.winconfig.mjpegtoolsdir.text())
      if (Path!=""):
        self.MJ=Path
        self.winconfig.mjpegtoolsdir.setText(self.MJ)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"mjpegtoolsdir",self.MJ,1)

    # Action button to browse for directory : MJPEGToolsDir
    def Conf_ChMJPEGToolsDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self.winconfig, self.qtapp.translate("main","Directory Dialog"), self.homeDir))
      if (Path!=""):
        self.MJ=Path
        self.winconfig.mjpegtoolsdir.setText(self.MJ)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"mjpegtoolsdir",self.MJ,1)

    def Conf_ChSOXDirEd(self) :
      Path=validatePath(self.winconfig.soxdir.text())
      if (Path!=""):
        self.S=Path
        self.winconfig.soxdir.setText(self.S)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"soxdir",self.S,1)

    # Action button to browse for directory : SOXDir
    def Conf_ChSOXDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self.winconfig, self.qtapp.translate("main","Directory Dialog"), self.homeDir))
      if (Path!=""):
        self.S=Path
        self.winconfig.soxdir.setText(self.S)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"soxdir",self.S,1)

    def Conf_ChMPlayerDirEd(self) :
      Path=validatePath(self.winconfig.mplayerdir.text())
      if (Path!=""):
        self.MP=Path
        self.winconfig.mplayerdir.setText(self.MP)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"mplayerdir",self.MP,1)

    # Action button to browse for directory : MPlayerDir
    def Conf_ChMPlayerDir(self): 
      Path=validatePath(QFileDialog.getExistingDirectory(self.winconfig, self.qtapp.translate("main","Directory Dialog"), self.homeDir))
      if (Path!=""):
        self.MP=Path
        self.winconfig.mplayerdir.setText(self.MP)
        UpdateConfigurationXMLFile(self.ConfigXMLObject,"mplayerdir",self.MP,1)

    # Action button to select a background file
    def Conf_ChgBgFile(self): #OK QT4
      file=QFileDialog.getOpenFileName(self.winconfig, self.qtapp.translate("main","File Dialog"),self.lastDirBackground, "Image(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
      if file!="":
        self.lastDirBackground=os.path.split(unicode(file))[0]
        self.winconfig.bgfile.setText(file)

    # Action button to select a background color
    def Conf_BrowseBgColor(self):
      color=QColorDialog.getColor(toqcolor(QString(self.ConfBgColor).toInt(16)[0]),self.winconfig)
      qp=QPalette()
      qp.setColor(QPalette.Base,color)
      self.winconfig.bgcolor.setPalette(qp)
      red=color.red()
      green=color.green()
      blue=color.blue()
      self.ConfBgColor=colortohex(red*65536+green*256+blue)
      self.winconfig.bgcolor.setText(self.ConfBgColor)

    # Change zoom display mode
    def Conf_ChDisplayZoomOption(self,txt):
      self.ConfDisplayUnit = unicode(txt)
      #Setup interface
      self.App_SetupInterface()

    # Save configuration to XML File
    def Conf_SaveConfig(self,ToClose=True): 
      # configurations elements
      self.T                  =self.winconfig.tmpdir.text()          # tmp directory
      self.I                  =self.winconfig.imgmgkdir.text()       # ffmpeg directory
      self.MJ                 =self.winconfig.mjpegtoolsdir.text()   # mjpegtools directory
      self.S                  =self.winconfig.soxdir.text()          # SOX directory
      self.MP                 =self.winconfig.mplayerdir.text()      # mplayer directory
      self.ConfBgFile         =self.winconfig.bgfile.text()
      self.ConfBgColor        =self.winconfig.bgcolor.text()
      self.ConfTime           =self.winconfig.time.text()
      self.ConfSpeedT         =self.winconfig.speedt.currentIndex()
      self.ConfTypeT          =self.winconfig.typet.currentIndex()
      self.ConfTransiOpt      =self.winconfig.transiopt.currentIndex()
      self.ConfImgFormat      =self.winconfig.imgformat.currentIndex()
      self.ConfDisplayUnit    =unicode(self.winconfig.zoomMode.currentIndex())
      self.ThumbnailsSize     =int(self.winconfig.ThumbnailsSize.currentIndex())
      self.RestoreWindowState =self.winconfig.RestoreWindowState.currentIndex()
      self.ConfOFDDeviceType  =self.winconfig.DeviceTypeCB.currentText()
      self.ConfOFDDeviceModel =self.winconfig.DeviceModelCB.currentText()
      self.ConfOFDOutputCodec =self.winconfig.OutputCodecCB.currentText()
      self.ConfOFDOutputFormat=self.winconfig.OutputFormatCB.currentText()

      # Update xml document
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"imgmgkdir",unicode(self.winconfig.imgmgkdir.text()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"mjpegtoolsdir",unicode(self.winconfig.mjpegtoolsdir.text()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"soxdir",unicode(self.winconfig.soxdir.text()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"tmpdir",unicode(self.winconfig.tmpdir.text()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"mplayerdir",unicode(self.winconfig.mplayerdir.text()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"time",unicode(self.winconfig.time.text()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"speedt",unicode(self.winconfig.speedt.currentIndex()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"typet",unicode(self.winconfig.typet.currentIndex()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"transiopt",unicode(self.winconfig.transiopt.currentIndex()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"bgcolor",unicode(self.winconfig.bgcolor.text()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"bgfile",unicode(self.winconfig.bgfile.text()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"imgformat",unicode(self.winconfig.imgformat.currentIndex()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"zoomVal",unicode(self.winconfig.zoomMode.currentIndex()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"ThumbnailsSize",unicode(self.winconfig.ThumbnailsSize.currentIndex()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-RestoreWindowState",unicode(self.winconfig.RestoreWindowState.currentIndex()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'OFDDeviceType',unicode(self.ConfOFDDeviceType))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'OFDDeviceModel',unicode(self.ConfOFDDeviceModel))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'OFDOutputCodec',unicode(self.ConfOFDOutputCodec))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,'OFDOutputFormat',unicode(self.ConfOFDOutputFormat))

      # Save Windows size/position on exit
      if self.win.isMaximized():  state=1
      else : state=0
      size=self.win.frameGeometry()
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-ismaximized",unicode(state))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-x",unicode(size.x()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-y",unicode(size.y()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-width",unicode(size.width()))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"WindowsSettings-height",unicode(size.height()))

      #Other
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirImage",unicode(self.lastDirImage))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirProject",unicode(self.lastDirProject))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirSound",unicode(self.lastDirSound))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirRender",unicode(self.lastDirRender))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"lastDirBackground",unicode(self.lastDirBackground))
      UpdateConfigurationXMLFile(self.ConfigXMLObject,u"CheckCodecAtStartup",unicode(self.CheckCodecAtStartup))

      #save the file
      fisa=open(self.ConfigFilePathName,'w')
      #fisa.write(self.ConfigXMLObject.toprettyxml(encoding='utf-8'))
      fisa.write(self.ConfigXMLObject.toxml('utf-8'))
      fisa.close()

      if ToClose==True: self.winconfig.close()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# TAB Image
#-----------------------------------------------------------------------------------------------------------------------------------------------

    #Function call each time a user enter a new value for background color
    def TAB_Image_ChgBgColor(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        BgColor=self.win.bgcolor.text()
        color=toqcolor(QString(BgColor).toInt(16)[0])
        qp=QPalette()
        qp.setColor(QPalette.Base,color)
        self.win.bgcolor.setPalette(qp)
        red=color.red()
        green=color.green()
        blue=color.blue()
        xcolor=colortohex(red*65536+green*256+blue)
        self.win.timeline.cellWidget(0,self.index).bgcolor=xcolor
        self.win.BgColor=xcolor
        self.win.timeline.cellWidget(0,self.index).ResetThumb()
        self.App_SetupInterface()
        self.App_SetModifiedFlag()
        self.App_DisplayPixMainWin(self.win.option.currentIndex())

    #Function call each time browse palette to select a background color
    def TAB_Image_BrowseBgColor(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        color=QColorDialog.getColor(toqcolor(QString(self.win.timeline.cellWidget(0,self.index).bgcolor).toInt(16)[0]),self.win)
        red=color.red()
        green=color.green()
        blue=color.blue()
        xcolor=colortohex(red*65536+green*256+blue)
        self.win.timeline.cellWidget(0,self.index).bgcolor=xcolor
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.win.timeline.cellWidget(0,self.index).ResetThumb()
          self.App_SetupInterface()
          self.App_SetModifiedFlag()
          self.App_DisplayPixMainWin(self.win.option.currentIndex())

    #Function call each time a user enter a new value for background file
    def TAB_Image_ChgBgFile(self):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.win.timeline.cellWidget(0,self.index).bgfile=self.win.bgfile.text()
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.win.timeline.cellWidget(0,self.index).ResetThumb()
          self.App_SetupInterface()
          self.App_SetModifiedFlag()
          self.App_DisplayPixMainWin(self.win.option.currentIndex())

    #Function call each time browse file to select a background file
    def TAB_Image_BrowseBgFile(self):
      file=QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","File Dialog"),self.lastDirBackground, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
      if file!="":
        self.win.bgfile.setText(file)
        self.lastDirBackground=os.path.split(unicode(file))[0]
        self.TAB_Image_ChgBgFile()
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.win.timeline.cellWidget(0,self.index).ResetThumb()
          self.App_SetupInterface()
          self.App_SetModifiedFlag()
          self.App_DisplayPixMainWin(self.win.option.currentIndex())

    #Function call each time option-transition choice is change
    def TAB_Image_ChgOptTr(self,newopttransi):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() and newopttransi!=-1 :
        if (self.StopUpdatePixDuringNewSelect!=True):
          image=self.win.timeline.cellWidget(0,self.index)
          if image!=None:
            image.opttransi=newopttransi
            image.updatePix()
          #self.App_SetupInterface()
          self.App_SetModifiedFlag()

    #Function call each time image duration change
    def TAB_Image_ChgTime(self,val):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.win.timeline.cellWidget(0,self.index).time=val
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.win.timeline.cellWidget(0,self.index).updatePix()
          self.App_SetupInterface()
          self.App_SetModifiedFlag()
          self.App_DisplayLenght()

    #Function call each time transition choice is change
    def TAB_Image_ChgTrOption(self,NewTransi) :
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        z=getTrOptionLst(self,NewTransi)
        self.win.transiopt.clear()
        i=0;
        max=len(z)
        while i<max:
          if NewTransi==7:
            FNameTr=u"iconstr/"+z[i]+u".png"
          else:
            FNameTr=u"iconstr/tr-0"+unicode(NewTransi)+u"-0"+unicode(i)+u".png"
          try:
            self.win.transiopt.addItem(QIcon(FNameTr),z[i])
          except:
            self.win.transiopt.addItem(z[i])
          i=i+1
        try:
          if (self.StopUpdatePixDuringNewSelect!=True):
            self.win.timeline.cellWidget(0,self.index).typet=NewTransi
            self.win.timeline.cellWidget(0,self.index).optTransi=0
            self.win.timeline.cellWidget(0,self.index).updatePix()
            self.App_SetModifiedFlag()
            self.App_SetupInterface()
            self.App_DisplayLenght()
        except:
          None

    #Function call each time transition duration change
    def TAB_Image_ChoixSpeedT(self,txt):
      if self.index!=-1 and self.index==self.win.timeline.currentColumn() :
        self.win.timeline.cellWidget(0,self.index).speedt=txt
        if (self.StopUpdatePixDuringNewSelect!=True):
          self.win.timeline.cellWidget(0,self.index).updatePix()
          self.App_SetModifiedFlag()
          self.App_SetupInterface()
          self.App_DisplayLenght()

    def TAB_Image_DefText(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        self.DefTextDlg=DefTextDlg(image,0,self,"Image",self.win)
        self.DefTextDlg.show()
        self.DefTextDlg.FirstInit()
        if image.XMLText!=None :
          xmlPoint=image.XMLText.getElementsByTagName(u"SaveXML")[0]
          self.DefTextDlg.ImportXML(xmlPoint)
        self.DefTextDlg.ForcePaint()

    def TAB_Image_DefTextOk(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        image.XMLText=self.DefTextDlg.ExportToXML()
        image.ResetThumb()
        self.DefTextDlg.close()
        self.App_DisplayPixMainWin(self.win.option.currentIndex())
        self.App_SetModifiedFlag()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# TAB Montage Option
#-----------------------------------------------------------------------------------------------------------------------------------------------
    def TAB_Montage_ChgDeviceType(self,index):
      self.win.DeviceModelCB.clear()
      if self.StopMAJOFD==False : self.OFDDeviceType=self.win.DeviceTypeCB.itemText(index)
      # Parse Output Format Definition for filling DeviceModelCB
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          DeviceType=OutputDeviceType.getAttribute("Name")
          if DeviceType==self.win.DeviceTypeCB.itemText(index):
            for OutputDeviceModel in OutputDeviceType.childNodes :
              if OutputDeviceModel.nodeType==OutputDeviceModel.ELEMENT_NODE:
                self.win.DeviceModelCB.addItem(OutputDeviceModel.getAttribute("Name"))
      if self.StopMAJSpinbox==False and self.StopMAJOFD==False :
        self.App_SetModifiedFlag()
        self.App_SetupInterface()

    def TAB_Montage_ChgDeviceModel(self,index):
      self.win.OutputCodecCB.clear()
      if self.StopMAJOFD==False : self.OFDDeviceModel=self.win.DeviceModelCB.itemText(index)
      # Parse Output Format Definition for filling OutputCodecCB
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          DeviceType=OutputDeviceType.getAttribute("Name")
          if DeviceType==self.win.DeviceTypeCB.currentText():
            for OutputDeviceModel in OutputDeviceType.childNodes :
              if OutputDeviceModel.nodeType==OutputDeviceModel.ELEMENT_NODE:
                DeviceModel=OutputDeviceModel.getAttribute("Name")
                if DeviceModel==self.win.DeviceModelCB.itemText(index):
                  for OutputCodec in OutputDeviceModel.childNodes :
                    if OutputCodec.nodeType==OutputCodec.ELEMENT_NODE:
                      self.win.OutputCodecCB.addItem(OutputCodec.getAttribute("Name"))
      if self.StopMAJSpinbox==False and self.StopMAJOFD==False :
        self.App_SetModifiedFlag()
        self.App_SetupInterface()

    def TAB_Montage_ChgOutputCodec(self,index):
      self.win.OutputFormatCB.clear()
      if self.StopMAJOFD==False : self.OFDOutputCodec=self.win.OutputCodecCB.itemText(index)
      # Parse Output Format Definition for filling OutputFormatCB
      for OutputDeviceType in self.OutputOFDXMLObject.firstChild.childNodes :
        if OutputDeviceType.nodeType==OutputDeviceType.ELEMENT_NODE:
          DeviceType=OutputDeviceType.getAttribute("Name")
          if DeviceType==self.win.DeviceTypeCB.currentText():
            for OutputDeviceModel in OutputDeviceType.childNodes :
              if OutputDeviceModel.nodeType==OutputDeviceModel.ELEMENT_NODE:
                DeviceModel=OutputDeviceModel.getAttribute("Name")
                if DeviceModel==self.win.DeviceModelCB.currentText():
                  for OutputCodec in OutputDeviceModel.childNodes :
                    if OutputCodec.nodeType==OutputCodec.ELEMENT_NODE:
                      Codec=OutputCodec.getAttribute("Name")
                      if Codec==self.win.OutputCodecCB.itemText(index):
                        for OutputGeometry in OutputCodec.childNodes :
                          if OutputGeometry.nodeType==OutputGeometry.ELEMENT_NODE:
                            Geometry=self.qtapp.translate("MainWindow",OutputGeometry.getAttribute("Name"))
                            if Geometry==self.win.imgformat.currentText():
                              for OutputFormat in OutputGeometry.childNodes :
                                if OutputFormat.nodeType==OutputFormat.ELEMENT_NODE:
                                  IsTestVideo=False
                                  IsTestAudio=False
                                  IsTestFile =False
                                  for fmt in self.listformats : 
                                    if fmt==OutputFormat.getAttribute("TestVideo") : IsTestVideo=True
                                    TestAudio=OutputFormat.getAttribute("TestAudio")
                                    if TestAudio=="adts" and self.AACMode=="libfaac" : TestAudio=self.AACMode
                                    if fmt==TestAudio : IsTestAudio=True
                                    if fmt==OutputFormat.getAttribute("TestFile")  : IsTestFile=True
                                  if IsTestVideo and IsTestAudio :
                                    self.win.OutputFormatCB.addItem(OutputFormat.getAttribute("Name"))
      if self.win.OutputFormatCB.count()==0:
        self.win.OutputFormatCB.addItem(self.qtapp.translate("main","No available format - Check config"))
      if self.StopMAJSpinbox==False and self.StopMAJOFD==False :
        self.App_SetModifiedFlag()
        self.App_SetupInterface()

    def TAB_Montage_ChgOutputFormat(self,index):
      if self.StopMAJOFD==False : self.OFDOutputFormat=self.win.OutputFormatCB.itemText(index)
      if self.StopMAJSpinbox==False and self.StopMAJOFD==False :
        self.App_SetModifiedFlag()
        self.App_SetupInterface()

    #Function call each time user enter a soundfile
    def TAB_Montage_ChgSndFile(self): #OK QT4
      self.soundfile=self.win.soundfile.text()
      self.lastDirSound=os.path.split(unicode(file))[0]
      self.App_SetModifiedFlag()

    #Function for browse to select soundfile
    def TAB_Montage_BrowseSndFile(self): #OK QT4
      file=QFileDialog.getOpenFileName(self.win, self.qtapp.translate("main","File Dialog"),self.lastDirSound, "Sound(*.wav *.WAV *.mp3 *.MP3 *.ogg *.OGG)")
      if file!="":
        self.soundfile=file
        self.win.soundfile.setText(file)
        self.lastDirSound=os.path.split(unicode(file))[0]
        self.App_SetModifiedFlag()

    #Function call to change image format 16/9 - 4/3
    def TAB_Montage_SetImgFormat(self,imgF) :
      self.StopUpdatePixDuringNewSelect=True
      SaveSelect = self.win.timeline.currentColumn()

      #ensure ProjectXMLObject is created
      self.File_CreateXMLObject()
      #clean all
      self.StopUpdatePixDuringEmpty=True
      self.Timeline_Empty()
      self.StopUpdatePixDuringEmpty=False
      self.win.outputfile.clear()
      self.win.bgfile.clear()
      self.win.bgcolor.clear()
      self.win.soundfile.clear()
      #apply new image format
      self.imgformat=imgF

      #Make object from XML data
      self.File_MakeFromXML(True,False)

      #Force an update of OFDFormatCB
      self.TAB_Montage_ChgOutputCodec(self.win.OutputCodecCB.findText(self.OFDOutputCodec))

      self.win.timeline.setCurrentCell(0,SaveSelect)
      self.StopUpdatePixDuringNewSelect=False
      self.App_SetModifiedFlag()
      self.App_DisplayPixMainWin(0)

    def TAB_Montage_DefText(self):
      self.DefTextDlg=DefTextDlg(None,0,self,"Overlaid",self.win)
      self.DefTextDlg.show()
      self.DefTextDlg.FirstInit()
      if self.XMLText!=None :
        xmlPoint=self.XMLText.getElementsByTagName(u"SaveXML")[0]
        self.DefTextDlg.ImportXML(xmlPoint)
        self.DefTextDlg.ForcePaint()

    def TAB_Montage_DefTextOk(self):
      self.XMLText=self.DefTextDlg.ExportToXML()
      self.DefTextDlg.close()
      self.App_DisplayPixMainWin(self.win.option.currentIndex())
      self.App_SetModifiedFlag()

#-----------------------------------------------------------------------------------------------------------------------------------------------
# Timeline action
#-----------------------------------------------------------------------------------------------------------------------------------------------
    def Timeline_BrowseAddImage(self): #QT4 OK
      if sys.platform == 'win32':
        files=QFileDialog.getOpenFileNames(self.win,self.qtapp.translate("main","Select input files"),self.lastDirImage, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *ppm *PPM *tiff *TIFF *.xpm *.XPM)")
        self.Timeline_BrowseAddImage2(files)
      else :
        fdialog = CFileDialogIMG(self.win,self.qtapp.translate("main","Select input files"),self.lastDirImage, "Images(*.jpg *.JPG *.png *.PNG *.gif *.GIF *.xpm *.XPM)")
        fdialog.addPreview()
        fdialog.setOption(QFileDialog.DontConfirmOverwrite, False)
        fdialog.setFileMode(QFileDialog.ExistingFiles)
        fdialog.show()
        self.qtapp.connect(fdialog, SIGNAL("filesSelected(QStringList)"), self.Timeline_BrowseAddImage2)

    def Timeline_BrowseAddImage2(self, files) :
      self.qtapp.setOverrideCursor(QCursor(Qt.WaitCursor))
      try :
        self.lastDirImage=os.path.split(unicode(files[0]))[0]
        NextSelectItem=self.win.timeline.columnCount()
        for file in files :
          # Check if the transition choice is "Random"-> Then define random transition
          if int(self.ConfTypeT) == self.RANDOMTRANSITIONTYPE : 
            transi, optTransi = randomTransi()
          else :
            # If not random -> Transi define by config
            transi    = self.ConfTypeT
            optTransi = self.ConfTransiOpt
          #Create new item in the timeline
          col=self.win.timeline.columnCount()
          Image=myLabel(
            unicode(file),                    #urlim = Filename
            self.ConfBgFile,                  #background file
            self.ConfBgColor,                 #background color
            unicode(transi),                  #transition type
            unicode(optTransi),               #transition option
            self.ConfSpeedT,                  #transition duration
            self.imgformat,                   #image format 16/9 or 4/3
            self                              #Videoporama class instance
          )
          Image.AddZoomPointItem(0,0,self.ConfTime,100,0.0,False,False)
          self.win.timeline.insertColumn(col)
          hpix=self.win.timeline.height()-18
          if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
          else :            wpix=(hpix-4)*4/3+34
          self.win.timeline.setColumnWidth(col,wpix)
          self.win.timeline.setCellWidget(0,col,Image)
          #Generate thumbail for this image
          Image.updatePix()
          #Force Display new thumbnail
          self.win.timeline.repaint()
        #Setup interface
        self.App_SetModifiedFlag()
        self.index=NextSelectItem
        self.win.timeline.setCurrentCell(0,NextSelectItem)
      except :
        None
      self.qtapp.restoreOverrideCursor()

    def Timeline_AddTitle(self):
      NextSelectItem=self.win.timeline.columnCount()
      # Check if the transition choice is "Random"-> Then define random transition
      if int(self.ConfTypeT) == self.RANDOMTRANSITIONTYPE : 
        transi, optTransi = randomTransi()
      else :
        # If not random -> Transi define by config
        transi    = self.ConfTypeT
        optTransi = self.ConfTransiOpt
      #Create new item in the timeline
      col=self.win.timeline.columnCount()
      Image=myLabel(
        "",                               #urlim = Filename
        self.ConfBgFile,                  #background file
        self.ConfBgColor,                 #background color
        unicode(transi),                  #transition type
        unicode(optTransi),               #transition option
        self.ConfSpeedT,                  #transition duration
        self.imgformat,                   #image format 16/9 or 4/3
        self                              #Videoporama class instance
      )
      Image.AddZoomPointItem(0,0,self.ConfTime,100,0.0,False,False)
      self.win.timeline.insertColumn(col)
      hpix=self.win.timeline.height()-18
      if self.imgformat == 1 : wpix=(hpix-4)*16/9+34
      else :            wpix=(hpix-4)*4/3+34
      self.win.timeline.setColumnWidth(col,wpix)
      self.win.timeline.setCellWidget(0,col,Image)
      #Generate thumbail for this image
      Image.updatePix()
      #Force Display new thumbnail
      self.win.timeline.repaint()
      #Setup interface
      self.App_SetModifiedFlag()
      self.index=NextSelectItem
      self.win.timeline.setCurrentCell(0,NextSelectItem)
  
    def Timeline_Empty(self):
      #Clean Timeline
      i=0
      while i<self.win.timeline.columnCount() : self.win.timeline.removeColumn(i)
      #Clean TableZoomPoint
      i=0
      while i<self.win.TableZoomPoint.rowCount() : self.win.TableZoomPoint.removeRow(i)
      self.win.bgfile.clear()
      self.win.bgcolor.clear()
      self.App_DisplayLenght()
      self.win.serie.setDisabled(True)
      self.win.actionMove_left.setDisabled(True)
      self.win.actionMove_right.setDisabled(True)
      self.win.actionRemove.setDisabled(True)

    def Timeline_MoveItemToRight(self):
      if self.index!=(self.win.timeline.columnCount()-1) :
        i=self.index
        wcol = self.win.timeline.columnWidth(i)
        pict=self.win.timeline.cellWidget(0,i).copy()
        nc=i+2
        self.win.timeline.insertColumn(nc)
        self.win.timeline.setColumnWidth(nc, wcol)
        self.win.timeline.setCellWidget(0,nc,pict)
        self.win.timeline.removeColumn(i)
        self.win.timeline.setCurrentCell(0,i+1)
        self.App_SetModifiedFlag()
        self.App_SetupInterface()

    def Timeline_MoveItemToLeft(self):
      if self.index!=0 :
        i=self.index
        wcol = self.win.timeline.columnWidth(i)
        pict=self.win.timeline.cellWidget(0,i).copy()
        b=i+1
        nc=i-1
        self.win.timeline.insertColumn(nc)
        self.win.timeline.setColumnWidth(nc, wcol)
        self.win.timeline.setCellWidget(0,nc,pict)
        self.win.timeline.removeColumn(b)
        self.win.timeline.setCurrentCell(0,nc)
        self.App_SetModifiedFlag()
        self.App_SetupInterface()

    def Timeline_DeleteItem(self):
      i = self.index
      if i > -1 :
        self.win.timeline.removeColumn(i)
        j = self.win.timeline.columnCount()
        if j != 0 :
          if i == 0 :
            self.win.timeline.setCurrentCell(0,0)
          elif i >= j :
            self.win.timeline.setCurrentCell(0,i-1)
          else :
            self.win.timeline.setCurrentCell(0,i)
        self.App_SetModifiedFlag()
        #Setup interface
        self.App_SetupInterface()

    # Function call each time an image is selected
    def Timeline_ChgSelectedItem(self): 
      if self.StopUpdatePixDuringEmpty==True: return
      #Stop all updatepix during this process
      self.StopUpdatePixDuringNewSelect=True
      
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if (image!=None):

        self.win.typet.setCurrentIndex(int(image.typet))
        self.win.bgcolor.setText(image.bgcolor)
        color=toqcolor(QString(image.bgcolor).toInt(16)[0])
        qp=QPalette()
        qp.setColor(QPalette.Base,color)
        self.win.bgcolor.setPalette(qp)
        self.win.bgfile.setText(image.bgfile)
        self.win.speedt.setCurrentIndex(int(image.speedt))
        optt=int(image.opttransi)
        self.win.transiopt.setCurrentIndex(optt)

        image.StateSelected=True
        image.updatePix()
        if (image!=self.SelectionEnCours):
          if (self.SelectionEnCours!=None):
            try:
              self.SelectionEnCours.StateSelected=False
              self.SelectionEnCours.updatePix()
              #self.SelectionEnCours.SetupInterface()
            except:
                None
        self.SelectionEnCours=image
        self.SelectionEnCours.MakeTableZoomPointFromXML()
        self.win.TableZoomPoint.setCurrentCell(0,0)
        self.StopUpdatePixDuringNewSelect=False   #Allow updatepix now
        image.updatePix() #Then force an updatepix
        
      #Setup interface
      self.StopUpdatePixDuringNewSelect=False
      self.App_DisplayPixMainWin(self.win.option.currentIndex())
#      if self.StopSetupInterface!=True: self.App_SetupInterface()

#-----------------------------------------------------------------------------------------------------------------------------------------------
#TableZoomPoint action
#-----------------------------------------------------------------------------------------------------------------------------------------------
    def TableZoomPoint_AddPoint(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        image.AddZoomPointItem(0.1,0.1,self.ConfTime,50)

        # Update Thumbnail image
        image.updatePix()

        self.App_SetModifiedFlag()
        self.App_SetupInterface()
    
    def TableZoomPoint_MoveItemToUp(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i!=0 :
          pict=self.win.TableZoomPoint.cellWidget(i,0).copy()
          b=i+1
          nc=i-1
          self.win.TableZoomPoint.insertRow(nc)
          self.win.TableZoomPoint.setRowHeight(nc,pict.h)
          self.win.TableZoomPoint.setCellWidget(nc,0,pict)
          self.win.TableZoomPoint.removeRow(b)
          self.win.TableZoomPoint.setCurrentCell(nc,0)
          image.MakeXMLZoomPointList()
          # Set number of all zoom point
          i=0
          while (i<self.win.TableZoomPoint.rowCount()):
            self.win.TableZoomPoint.cellWidget(i,0).NumZoomPoint=i
            i+=1
          image.CacheThumb=None
          image.updatePix()
          self.App_SetModifiedFlag()
          self.App_SetupInterface()
    
    def TableZoomPoint_MoveItemToDown(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i!=(self.win.TableZoomPoint.rowCount()-1) :
          pict=self.win.TableZoomPoint.cellWidget(i,0).copy()
          nc=i+2
          self.win.TableZoomPoint.insertRow(nc)
          self.win.TableZoomPoint.setRowHeight(nc,pict.h)
          self.win.TableZoomPoint.setCellWidget(nc,0,pict)
          self.win.TableZoomPoint.removeRow(i)
          self.win.TableZoomPoint.setCurrentCell(i+1,0)
          image.MakeXMLZoomPointList()
          # Set number of all zoom point
          i=0
          while (i<self.win.TableZoomPoint.rowCount()):
            self.win.TableZoomPoint.cellWidget(i,0).NumZoomPoint=i
            i+=1
          image.CacheThumb=None
          image.updatePix()
          self.App_SetModifiedFlag()
          self.App_SetupInterface()
    
    def TableZoomPoint_DeleteItem(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          self.win.TableZoomPoint.removeRow(i)
          image.NbrZoomPoint-=1
          j = self.win.TableZoomPoint.rowCount()
          if j != 0 :
            if i == 0 :
              self.win.TableZoomPoint.setCurrentCell(0,0)
            elif i >= j :
              self.win.TableZoomPoint.setCurrentCell(i-1,0)
            else :
              self.win.TableZoomPoint.setCurrentCell(i,0)
          # Set number of all zoom point
          i=0
          while (i<self.win.TableZoomPoint.rowCount()):
            self.win.TableZoomPoint.cellWidget(i,0).NumZoomPoint=i
            i+=1
          image.MakeXMLZoomPointList()
          # Update Thumbnail image
          image.updatePix()
          self.App_SetModifiedFlag()
          self.App_SetupInterface()

    #Function call each time image duration change
    def TableZoomPoint_ChgTimeFixe(self,val):
      if self.StopSetupInterface : return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            item.timeFixe = val
            item.CacheThumb=None
            image.CacheThumb=None
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.option.currentIndex())
            self.App_SetModifiedFlag()

    #Function call each time image duration change
    def TableZoomPoint_ChgTimeToTravel(self,val):
      if self.StopSetupInterface : return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            item.timeToTravel = val
            item.CacheThumb=None
            image.CacheThumb=None
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.option.currentIndex())
            self.App_SetModifiedFlag()

    def TableZoomPoint_ChgSelectedItem(self):
      # Draw each item to remove selection or add selection to the new selected item
      i=0
      while (i<self.win.TableZoomPoint.rowCount()) :
        item=self.win.TableZoomPoint.cellWidget(i,0)
        if item!=None : item.updatePix()
        i+=1
      # Repaint preview zone
      self.App_DisplayPixMainWin(self.win.option.currentIndex())
      self.App_SetupInterface()

    def TableZoomPoint_ChgZoomPointXValue(self,Value):
      if self.StopMAJSpinbox: return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            if self.ConfDisplayUnit=="0" :
              # Define value in %
              Value=Value/100
            else:
              # Define value in %
              Value=Value/image.xmax
            item.x=Value
            item.CacheThumb=None
            image.CacheThumb=None
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.option.currentIndex())
            self.App_SetModifiedFlag()

    def TableZoomPoint_ChgZoomPointYValue(self,Value):
      if self.StopMAJSpinbox: return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            if self.ConfDisplayUnit=="0" :
              # Define value in %
              Value=Value/100
            else:
              # Define value in %
              Value=Value/image.ymax
            item.y=Value
            image.CacheThumb=None
            item.CacheThumb=None
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.option.currentIndex())
            self.App_SetModifiedFlag()

    def TableZoomPoint_ChgZoomPointZoomValue(self,Value):
      if self.StopMAJSpinbox: return
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            if self.ConfDisplayUnit=="0" :
              # Define value in %
              None
            else:
              # Define value in %
              Value=(Value/image.xmax)*100
            item.zoom=Value
            item.CacheThumb=None
            image.CacheThumb=None
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.option.currentIndex())
            self.App_SetModifiedFlag()

    def TableZoomPoint_DefZoomPointText(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        ZoomPointNum = self.win.TableZoomPoint.currentRow()
        if ZoomPointNum > -1 :
          item=self.win.TableZoomPoint.cellWidget(ZoomPointNum,0)
          if item!=None : 
            self.DefTextDlg=DefTextDlg(image,ZoomPointNum,self,"ZoomPoint",self.win)
            xmlPoint=image.ZoomPointList.getElementsByTagName(u"Point-"+unicode(ZoomPointNum))[0]
            self.DefTextDlg.show()
            self.DefTextDlg.FirstInit()
            self.DefTextDlg.ImportXML(xmlPoint)
            self.DefTextDlg.ForcePaint()

    def TableZoomPoint_DefZoomPointTextOk(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        ZoomPointNum = self.win.TableZoomPoint.currentRow()
        if ZoomPointNum > -1 :
          ZoomPointItem=self.win.TableZoomPoint.cellWidget(ZoomPointNum,0)
          if ZoomPointItem!=None : 
            ZoomPointItem.CacheThumb=None
            image.CacheThumb=None
            ZoomPointItem.XMLText=self.DefTextDlg.ExportToXML()
            self.DefTextDlg.close()
            image.MakeXMLZoomPointList()
            image.updatePix()
            ZoomPointItem.updatePix()
            ZoomPointItem.SetupInterface()
            self.App_DisplayPixMainWin(self.win.option.currentIndex())
            self.App_SetModifiedFlag()

    def TableZoomPoint_DefZoomPoint(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            self.DefZoomPointDlg=DefZoomPointDlg(image,item,self,self.win)
            self.DefZoomPointDlg.show()
            self.DefZoomPointDlg.FirstInit()

    def TableZoomPoint_DefZoomPointOk(self):
      self.index = self.win.timeline.currentColumn()
      image=self.win.timeline.cellWidget(0,self.index)
      if image!=None:
        i = self.win.TableZoomPoint.currentRow()
        if i > -1 :
          item=self.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            item.CacheThumb=None
            item.x         = self.DefZoomPointDlg.cadre.x
            item.y         = self.DefZoomPointDlg.cadre.y
            item.zoom      = self.DefZoomPointDlg.cadre.zoom
            ZoomPointItem.CacheThumb=None
            image.CacheThumb=None
            self.DefZoomPointDlg.close()
            image.MakeXMLZoomPointList()
            image.updatePix()
            item.updatePix()
            item.SetupInterface()
            self.App_DisplayPixMainWin(self.win.option.currentIndex())
            image.MakeXMLZoomPointList()
            self.App_SetModifiedFlag()
