# -*- coding: utf-8 -*-

# This file is part of Videoporama
# Videoporama is a program to make diaporama export in video file
# Copyright (C) 2007-2010  Olivier Ponchaut <opvg@numericable.be> - Dominique Levray

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import os
import subprocess
import Image
import random
import math
from __builtin__ import hex as hexp
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from main_win import *
from statusconf import *
from about import *
from mplayer import *
from GlobalDefines import *
from DefTextDlg import *
from DefZoomPointDlg import *
from lotDlg import *
try : import pyexiv2
except : None
import datetime
from SND_editorDlg import *

# Debug
debug = False

class StatusConf(QDialog,Ui_statusconf) : #OK QT4
    def __init__(self, parent=None):
        super(StatusConf, self).__init__(parent)
        self.setupUi(self)

class About(QDialog,Ui_about) : #OK QT4
    def __init__(self, parent=None):
        super(About, self).__init__(parent)
        self.setupUi(self)

class CFileDialogIMG(QFileDialog) :
    def addPreview(self) :
      layout=self.layout()
      vbox = QVBoxLayout()
      title = QGroupBox(self.tr("Image preview"))
      self.preview=QLabel()
      self.preview.setFixedWidth(120)
      vbox.addWidget(self.preview)
      vbox.addStretch()
      title.setLayout(vbox)
      layout.addWidget(title, 1, layout.columnCount())
      #Signaux et slots
      self.connect(self, SIGNAL("currentChanged(QString)"), self.showPreview)

    def showPreview(self, urlim) :
      if not os.path.isdir(unicode(urlim)) :
        prev = QPixmap(unicode(urlim))
        try : self.preview.setPixmap(prev.scaledToWidth(120))
        except : None

class stopObject(QLabel) :
    def __init__(self, boxItem, pix, idf, parent=None) :
      super(stopObject, self).__init__(parent)
      self.boxItem = boxItem
      self.setPixmap(pix)
      self.setScaledContents(True)
      self.idf = idf

    def getBoxItem(self) :
      return self.boxItem

    def setBoxItem(self, boxRect) :
      self.boxItem = boxRect

    def getIdf(self) :
      return self.idf

    def copy(self) :
      cp = stopObject(self.boxItem, self.pixmap(), self.idf)
      return cp

    def getProperties(self) :
      prop = unicode(self.idf)+u":"+unicode(self.boxItem.x())+u":"+unicode(self.boxItem.y())+u":"+unicode(self.boxItem.width())+u":"+unicode(self.boxItem.height())
      return prop

#-------------------------------------------------------------------------------------------------------------------------

class checkSoxEncoding(QWidget) :
  """checkSoxEncoding est une class pour vérifier les possibilités de Sox pour l'encodage du format mp2/mp3. Si ce n'est pas le cas, retourne 0 -> adaptation de l'interface pour supprimer ces possibilités"""
  def __init__(self, listeformat, parent=None) :
    super(checkSoxEncoding, self).__init__(parent)
    self.hide()
    self.listeFormat = listeformat
    self.parent = parent
    self.index = 0
    self.checkListeFormat = []

  def run(self) :
    self.soxP = QProcess(self.parent)
    self.connect(self.soxP, SIGNAL('finished(int)'), self.finProcess)
    self.write = 0
    commande = u"sox -n -t %s %s trim 00:00:00.000 00:00:01.000" % (self.listeFormat[self.index], os.path.expanduser("~")+os.sep+u"checkSoxEssai."+self.listeFormat[self.index])
    self.soxP.setProcessChannelMode(QProcess.MergedChannels)
    self.soxP.start(commande)

  def finProcess(self,statut) :
    # Test if the command has been correctly executed
    if not statut :
      # If OK -> Add the extension to the list of format which are supported in encoding by sox
      self.checkListeFormat.append((self.listeFormat[self.index],True))
      os.remove(os.path.expanduser("~")+os.sep+u"checkSoxEssai."+self.listeFormat[self.index])
    else :
      # if not OK, add the extension with status unusable
      self.checkListeFormat.append((self.listeFormat[self.index],False))
    # Incrémentation du compteur pour explorer tous les formats à tester
    self.index += 1
    # If the check process reach the end of the format list to test, send the end signal with the list
    if self.index == len(self.listeFormat) :
      self.emit(SIGNAL("checkSox"), self.checkListeFormat)
    else :
      self.run()


class QComboTable(QComboBox) :
    def __init__(self,row=-1,parent=None) :
      super(QComboTable,self).__init__(parent)
      self.row=row
      self.connect(self,SIGNAL("currentIndexChanged(int)"),self.sigChanged)

    def setRow(self,row) :
      self.row=row

    def sigChanged(self) :
      self.index=self.currentIndex()
      self.emit(SIGNAL("QCBchanged"),self.index,self.row)

#---------------------------------------------------------------------------------------------------------------------------------------------------------------

class ZoomPointItem(QLabel) :
    def __init__(self,x,y,w,h,timeFixe, zoom, timeToTravel, VideoporamaInstance,TextToAdd,NumZoomPoint,ImageItem,parent=None) :
      super(ZoomPointItem,self).__init__(parent)
      self.VideoporamaInstance = VideoporamaInstance
      self.VideoporamaInstance.StopMAJSpinbox = False

      self.x            = float(x)
      self.y            = float(y)
      self.w            = float(w)      # for render in the tablewidget
      self.h            = float(h)      # for render in the tablewidget
      self.zoom         = float(zoom)
      self.XMLText      = TextToAdd     # XML Document containing zoompoint text
      self.NumZoomPoint = NumZoomPoint  # Number of zoompoint item
      self.ImageItem    = ImageItem     # Image item (parent)
      self.CacheThumb   = None          # Cache of thumbnail to speed interface
      self.timeFixe = float(timeFixe)
      self.timeToTravel = float(timeToTravel)

    def updatePix(self) :
      if self.CacheThumb==None : self.CacheThumb,Unused=self.ImageItem.ToRenderImageForDisplay(self.NumZoomPoint,self.w,self.h,0,0,0,0,False,False,False)
      dessin=self.CacheThumb.copy()

      # Init a QPainter object
      p=QPainter(dessin)

      # Fill the area with lightGray or White backgroundcolor if is selected
      row=self.VideoporamaInstance.win.TableZoomPoint.currentRow()
      if row!=-1 : item=self.VideoporamaInstance.win.TableZoomPoint.cellWidget(row,0)
      else : item=None
      if (item==self) :
        #define a pen for the rectangle
        pen=QPen(QtCore.Qt.blue)
        pen.setWidth(6)
        p.setPen(pen)
        #draw select rectangle
        p.drawRect(QRect(0,0,self.w,self.h))

      # Close QPainter object
      p.end()

      self.setPixmap(QPixmap.fromImage(dessin))

    def SetupInterface(self):
      if self.VideoporamaInstance.StopMAJSpinbox: return
      self.VideoporamaInstance.StopMAJSpinbox=True
      if self.VideoporamaInstance.ConfDisplayUnit=="0" :
        # Define the value and max value (in %)
        self.VideoporamaInstance.win.ZoomPointXValue.setRange(0,99-self.zoom)
        self.VideoporamaInstance.win.ZoomPointXValue.setValue(self.x*100)
        self.VideoporamaInstance.win.ZoomPointXValue.setSingleStep(int(100/20)) 
        self.VideoporamaInstance.win.ZoomPointYValue.setRange(0,99-self.zoom)
        self.VideoporamaInstance.win.ZoomPointYValue.setValue(self.y*100)
        self.VideoporamaInstance.win.ZoomPointYValue.setSingleStep(int(100/20)) 
        self.VideoporamaInstance.win.ZoomPointZoomValue.setRange(1,100)
        self.VideoporamaInstance.win.ZoomPointZoomValue.setValue(self.zoom)
        self.VideoporamaInstance.win.ZoomPointZoomValue.setSingleStep(int(100/20)) 
        # Setup label associated with each edit
        self.VideoporamaInstance.win.ZoomPointXLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        self.VideoporamaInstance.win.ZoomPointYLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
        self.VideoporamaInstance.win.ZoomPointZoomLabel.setText(self.VideoporamaInstance.qtapp.translate("main","%"))
      else :
        # Define the value and max value (in pixel)
        w=self.ImageItem.xmax*self.zoom/100
        h=self.ImageItem.ymax*self.zoom/100
        self.VideoporamaInstance.win.ZoomPointXValue.setRange(0,self.ImageItem.xmax-w)
        self.VideoporamaInstance.win.ZoomPointXValue.setValue(self.x*self.ImageItem.xmax)
        self.VideoporamaInstance.win.ZoomPointXValue.setSingleStep(int(self.ImageItem.xmax/20))
        self.VideoporamaInstance.win.ZoomPointYValue.setRange(0,self.ImageItem.ymax-h)
        self.VideoporamaInstance.win.ZoomPointYValue.setValue(self.y*self.ImageItem.ymax)
        self.VideoporamaInstance.win.ZoomPointYValue.setSingleStep(int(self.ImageItem.ymax/20))
        self.VideoporamaInstance.win.ZoomPointZoomValue.setRange(1,self.ImageItem.xmax)
        self.VideoporamaInstance.win.ZoomPointZoomValue.setValue(self.ImageItem.xmax*(self.zoom/100)) 
        self.VideoporamaInstance.win.ZoomPointZoomValue.setSingleStep(int(self.ImageItem.xmax/20)) 
        # Setup label associated with each edit
        self.VideoporamaInstance.win.ZoomPointXLabel.setText("/"+unicode(int(self.ImageItem.xmax-w)))
        self.VideoporamaInstance.win.ZoomPointYLabel.setText("/"+unicode(int(self.ImageItem.ymax-h)))
        self.VideoporamaInstance.win.ZoomPointZoomLabel.setText("/"+unicode(int(self.ImageItem.xmax)))
 
      self.VideoporamaInstance.win.ZoomPointTimeFixe.setValue(self.timeFixe)
      self.VideoporamaInstance.win.ZoomPointTimeTravel.setValue(self.timeToTravel)
      self.VideoporamaInstance.StopMAJSpinbox=False

    def copy(self) :
      doc=Document()
      if self.XMLText!=None: newXML=doc.importNode(self.XMLText,True)
      else: newXML=None
      cp=ZoomPointItem(self.x,self.y,self.w,self.h,self.timeFixe,self.zoom,self.timeToTravel,self.VideoporamaInstance,newXML,self.NumZoomPoint,self.ImageItem)
 
      return cp

#---------------------------------------------------------------------------------------------------------------------------------------------------------------

class myLabel(QLabel) :
    def __init__(self,urlim,bgfile,bgcolor,typet,opttransi,speedt,Orientation,VideoporamaInstance,ObjectType=1,parent=None) :
      super(myLabel,self).__init__(parent)
      if ObjectType!=2:
        if urlim=="": ObjectType=0
        else: ObjectType=1
      self.VideoporamaInstance  = VideoporamaInstance
      self.ObjectType           = ObjectType           # ObjectType = 0:Title,1:Image,2:Movie
      self.RealImageSizeWidth   = 0                    # Real image size
      self.RealImageSizeHeight  = 0                    # Real image size
      self.ImageLoaded          = None                 # Cache image for display
      self.ImageCacheMovie      = None                 # Cache image for movie generation
      self.StateSelected        = False                # True if selected
      self.urlim                = urlim                # Filepath to the image
      self.bgfile               = bgfile               # Background file
      self.bgcolor              = bgcolor              # Background color
      self.typet                = int(typet)           # Transition type
      self.opttransi            = int(opttransi)       # Transition option
      self.speedt               = speedt               # Transition duration
      self.NbrZoomPoint         = 0                    # Number Of ZoomPointItem (shot)
      self.CacheThumb           = None                 # Cache of Thumbnail to speed interface
      self.xmax                 = -1                   # Size of the full image use by pixel display mode
      self.ymax                 = -1                   # Size of the full image use by pixel display mode
      self.ZoomPointList        = None                 # ZoomPointList XMLDocument
      self.XMLText              = None                 # Background text XMLDocument

      #Specific for movie
      self.StartVideo           = QTime(0,0,0,0)       # Movie start time
      self.EndVideo             = QTime(0,0,0,0)       # Movie end time
      self.DurationVideo        = QTime(0,0,0,0)       # Movie duration
      self.InitialDurationVideo = QTime(0,0,0,0)       # Total Movie duration
      self.InfoVideo            = QString()            # Movie video informations
      self.InfoAudio            = QString()            # Movie Audio informations
      self.MoviePPMSize         = 0                    # Size of a movie ppm image
      self.MovieGeometry        = "4:3"                # Geometry of the movie
      self.MovieSeekAtCodecLevel= False                # True if ffmpeg can't seek this movie at container level

      # --- EXIF DATA
      if Orientation=="": Orientation=-1
      self.EXIF_Orientation    = int(Orientation)     # Image rotation (EXIF)
      self.EXIF_OrigDatetime   = ""                   # Date/time of the image taken (EXIF)
      self.EXIF_Description    = ""                   # Image description (EXIF)
      self.EXIF_Camera         = ""                   # Camera (EXIF)
      self.EXIF_Artist         = ""                   # Artist/Copyright (EXIF)
      self.EXIF_Size           = ""                   # Size (x*y) (EXIF)
      self.EXIF_ISO            = ""                   # ISO (EXIF)
      self.EXIF_Focal          = ""                   # Focal aperture (EXIF)
      self.EXIF_ExposureTime   =""                    # Exposure time (EXIF)
      
      #Init ZoomPointList to an empty XML
      self.ZoomPointList = Document()
      xmltag = self.ZoomPointList.createElement(u"ZoomPointTable")
      self.ZoomPointList.appendChild(xmltag)

    # Obtain the movie informations
    def LoadMovieInfo(self) :
      self.MovieGeometry="4:3"
      commande = "\""+unicode(self.VideoporamaInstance.I)+u"ffmpeg\" -i \""+self.urlim+"\""
      Process=QProcess()
      Process.start(commande)
      Process.waitForStarted()
      Process.waitForFinished()
      Info=QString(Process.readAllStandardError())
      # Get informations about video track
      if Info.contains("Video:",Qt.CaseInsensitive)==True:
        self.InfoVideo=Info.mid(Info.indexOf("Video:")+6)
        if self.InfoVideo.contains("\n")==True: self.InfoVideo=self.InfoVideo.mid(1,self.InfoVideo.indexOf("\n")-1)
        # format is : video_codec, image_codec, size XxY [eventualy geometry], frame rate informations ...
        VideoCodec="Unknown"
        SizeImg   ="Unknown"
        PointSize ="1:1"
        Geometry  ="4:3"

        if self.InfoVideo.contains(",")==True:
          VideoCodec=self.InfoVideo.mid(0,self.InfoVideo.indexOf(","))
          Other=self.InfoVideo.mid(self.InfoVideo.indexOf(",")+2)
          if Other.contains(",")==True:
            ImageCodec=Other.mid(0,Other.indexOf(","))
            Other=Other.mid(Other.indexOf(",")+2)
            if Other.contains(",")==True:
              SizeImg=Other.mid(0,Other.indexOf(","))
              # if [PAR x:y DAR 16:9] exist then the movie is forced to 16/9 geometry
              if SizeImg.contains("[")==True:
                PointSize=SizeImg.mid(Other.indexOf("PAR")+4)
                if PointSize.contains(" ")==True: PointSize=PointSize.mid(0,PointSize.indexOf(" "))
                Geometry=SizeImg.mid(Other.indexOf("DAR")+4)
                if Geometry.contains("]")==True: Geometry=Geometry.mid(0,Geometry.indexOf("]"))
                if SizeImg.contains(" ")==True: SizeImg=SizeImg.mid(0,SizeImg.indexOf(" "))
                XS=SizeImg.mid(0,SizeImg.indexOf("x"))
                YS=SizeImg.mid(SizeImg.indexOf("x")+1)
                #Special case : same camera use 1920x1088 instead of 1920x1080
                if YS=="1088": YS="1080"
              else:
                PointSize="1:1"
                if SizeImg.contains("x")==True: 
                  XS=SizeImg.mid(0,SizeImg.indexOf("x"))
                  YS=SizeImg.mid(SizeImg.indexOf("x")+1)
                  #Special case : same camera use 1920x1088 instead of 1920x1080
                  if YS=="1088": YS="1080"
                  if ((int(XS)/16)*9)==int(YS): Geometry="16:9"
                  else :                        Geometry="4:3"
                else :                          Geometry="4:3"
              self.InfoVideo="%s - %sx%s - %s" % (VideoCodec,XS,YS,Geometry)
        self.MovieGeometry=Geometry
      # Get informations about audio track
      if Info.contains("Audio:",Qt.CaseInsensitive)==True:
        self.InfoAudio=Info.mid(Info.indexOf("Audio:")+6)
        if self.InfoAudio.contains("\n")==True: self.InfoAudio=self.InfoAudio.mid(1,self.InfoAudio.indexOf("\n")-1)

      # Get informations about duration
      if Info.contains("Duration:",Qt.CaseInsensitive)==True:
        Duration=Info.mid(Info.indexOf("Duration:")+9)
        if Duration.contains(",")==True: Duration=Duration.mid(1,Duration.indexOf(",")-1)
        self.InitialDurationVideo=QTime().fromString(Duration,"hh:mm:ss.z")

      # Update some variables
      if self.EXIF_Orientation==-1: self.EXIF_Orientation=1
      if self.StartVideo.isNull()==True: self.StartVideo=QTime(0,0,0,0)
      if self.EndVideo.isNull()==True or self.EndVideo==QTime(0,0,0,0): self.EndVideo=self.InitialDurationVideo
      self.DurationVideo=QTime(0,0,0,0).addMSecs(self.StartVideo.msecsTo(self.EndVideo))

    # Obtain the exif data
    def LoadEXIF(self) :
      #----------------------------------------------------------------------------
      # Il y a 2 versions de pyexiv2 avec des syntaxes différentes !
      #----------------------------------------------------------------------------
      EXIF_Orientation=-1
      try:
        exif = pyexiv2.ImageMetadata(unicode(self.urlim))
      except : 
        try:
          exif = pyexiv2.Image(unicode(self.urlim))
        except:
          return

      try:
        exif.read()
      except : 
        try:
          exif.readMetadata()
        except:
          return

      # Image rotation (EXIF)
      try:
        EXIF_Orientation=exif['Exif.Image.Orientation']
        try:    EXIF_Orientation=exif['Exif.Image.Orientation'].value
        except: None
      except:
        EXIF_Orientation=1

      # Date/time of the image taken (EXIF)
      try:
        self.EXIF_OrigDatetime=exif['Exif.Photo.DateTimeOriginal'].value.strftime('%A %d %B %Y, %H:%M:%S')
      except:
        try:
          self.EXIF_OrigDatetime=exif['Exif.Photo.DateTimeOriginal']
          DT=QDate(self.EXIF_OrigDatetime.year,self.EXIF_OrigDatetime.month,self.EXIF_OrigDatetime.day)
          TM=QTime(self.EXIF_OrigDatetime.hour,self.EXIF_OrigDatetime.minute,self.EXIF_OrigDatetime.second)
          self.EXIF_OrigDatetime=DT.toString()+" "+TM.toString()
        except: 
          self.EXIF_OrigDatetime=""

      # Image description (EXIF)
      try:
        self.EXIF_Description=exif['Exif.Image.ImageDescription']
        try:    EXIF_Description=EXIF_Description.raw_value
        except: None
      except: self.EXIF_Description=""

      # Camera (EXIF)
      try:
        Make=exif['Exif.Image.Make']
        try:    Make=Make.raw_value
        except: None
      except: Make=""
      try:
        Model=exif['Exif.Image.Model']
        try:    Model=Model.raw_value
        except: None
      except: Model=""
      if QString(Model).indexOf(Make,0,Qt.CaseInsensitive)==-1:
        self.EXIF_Camera=Make+" "+Model
      else :
        self.EXIF_Camera=Model

      # Artist/Copyright (EXIF)
      try:
        Artist=exif['Exif.Image.Artist']
        try:    Artist=Artist.raw_value
        except: None
      except: Artist=""
      
      try:
        Copyright=exif['Exif.Image.Copyright']
        try:    Copyright=Copyright.raw_value
        except: None
      except: Copyright=""
      self.EXIF_Artist=Artist+" "
      if Copyright!="": self.EXIF_Artist=self.EXIF_Artist+"(c) "+Copyright

      # ISO (EXIF)
      try:
        self.EXIF_ISO=exif['Exif.Photo.ISOSpeedRatings']
        try:    self.EXIF_ISO=self.EXIF_ISO.raw_value
        except: self.EXIF_ISO=str(self.EXIF_ISO)
      except: self.EXIF_ISO=""

      # Size (x*y) (EXIF)
#      try:
#        ImageWidth=exif['Exif.Image.ImageWidth']
#        try:    ImageWidth=ImageWidth.value
#        except: None
#      except: 
#        try :
#          ImageWidth  =exif['Exif.Photo.PixelXDimension']
#          try:    ImageWidth=ImageWidth.value
#          except: None
#        except: ImageWidth=""
#      try:
#        ImageHeight=exif['Exif.Image.ImageLength']
#        try:    ImageHeight=ImageHeight.value
#        except: None
#      except:
#        try :
#          ImageHeight =exif['Exif.Photo.PixelYDimension']
#          try:    ImageHeight=ImageHeight.value
#          except: None
#        except: ImageHeight=""
#      self.EXIF_Size=str(ImageWidth)+" x "+str(ImageHeight)

      # Focal informations (EXIF)
      try:
        ApertureValue=exif['Exif.Photo.ApertureValue']
        try:    ApertureValue=ApertureValue.value
        except: None
        self.EXIF_Focal=u"%.1f EV" % (float(ApertureValue.numerator)/float(ApertureValue.denominator))
      except: 
        self.EXIF_Focal=""
      
      try: 
        ExpT=exif['Exif.Photo.ExposureTime']
        try:    ExpT=ExpT.value
        except: None
        self.EXIF_ExposureTime=str(ExpT.numerator)+"/"+str(ExpT.denominator)+" sec"
      except: self.EXIF_ExposureTime=""
        
#        try: 
#          Lens=exif['Xmp.aux.Lens']
#        except: Lens=""
#        try:
#          FocalL=exif['Exif.Photo.FocalLength']
#          FocalLength=u"%.1f mm" % (float(FocalL.numerator)/float(FocalL.denominator))
#        except:
#          None
#        try: FNumber =exif['Exif.Photo.FNumber']
#        except: None
#        try: ExposureBiasValue  =exif['Exif.Photo.ExposureBiasValue']
#        except: None
#        try: MeteringMode  =exif['Exif.Photo.MeteringMode']
#        except: None
#        # GPS coordonates
#        try: GPSTag          =exif['Exif.Image.GPSTag']
#        except: None
#        try: LightSource  =exif['Exif.Photo.LightSource']
#        except: None
#        try: Flash  =exif['Exif.Photo.Flash']
#        except: None
#        try: ComponentsConfiguration  =exif['Exif.Photo.ComponentsConfiguration']
#        except: None
#        try: CompressedBitsPerPixel  =exif['Exif.Photo.CompressedBitsPerPixel']
#        except: None

      # Do not use read value for EXIF_Orientation if a value is define in the XML
      if self.EXIF_Orientation==-1:
        self.EXIF_Orientation=EXIF_Orientation
      if self.EXIF_Orientation==-1:
        self.EXIF_Orientation=1

    def copy(self) :
      cp=myLabel(self.urlim,self.bgfile,self.bgcolor,self.typet,self.opttransi,self.speedt,self.EXIF_Orientation,self.VideoporamaInstance,self.ObjectType)
      cp.ZoomPointList        = self.ZoomPointList
      cp.XMLText              = self.XMLText
      cp.RealImageSizeWidth   = self.RealImageSizeWidth
      cp.RealImageSizeHeight  = self.RealImageSizeHeight
      cp.StartVideo           = self.StartVideo
      cp.EndVideo             = self.EndVideo
      cp.DurationVideo        = self.DurationVideo
      cp.InfoVideo            = self.InfoVideo
      cp.InfoAudio            = self.InfoAudio
      cp.InitialDurationVideo = self.InitialDurationVideo
      cp.MoviePPMSize         = self.MoviePPMSize
      cp.MovieGeometry        = self.MovieGeometry
      cp.EXIF_Orientation     = self.EXIF_Orientation
      cp.EXIF_OrigDatetime    = self.EXIF_OrigDatetime
      cp.EXIF_Description     = self.EXIF_Description
      cp.EXIF_Camera          = self.EXIF_Camera
      cp.EXIF_Artist          = self.EXIF_Artist
      cp.EXIF_Size            = self.EXIF_Size
      cp.EXIF_ISO             = self.EXIF_ISO
      cp.EXIF_Focal           = self.EXIF_Focal
      cp.EXIF_ExposureTime    = self.EXIF_ExposureTime
      cp.ImageLoaded          = self.ImageLoaded.copy()
      cp.CacheThumb           = self.CacheThumb.copy()
      cp.MakeTableZoomPointFromXML()
      return cp

    # Calc which number item is for this item
    def GetSeqNumber(self) :
      SeqNumber=0
      k=0
      while k<self.VideoporamaInstance.win.timeline.columnCount() :
        if self==self.VideoporamaInstance.win.timeline.cellWidget(0,k) : 
          SeqNumber=k
          k=self.VideoporamaInstance.win.timeline.columnCount() # Stop searching
        k=k+1
      if self==self.VideoporamaInstance.win.timeline.cellWidget(0,SeqNumber) :
        return SeqNumber
      else : return -1

    #add a zoompoint item and insert it in last position on the and in the xml (ZoomPointList)
    def AddZoomPointItem(self,x,y,timeFixe,zoom,timeToTravel=0.0, MakeList=True,MakeTableWidget=True,TextToAdd=None):
      w=self.VideoporamaInstance.win.TableZoomPoint.width()-18
      if self.VideoporamaInstance.imgformat == 1 : h=w*9/16
      else : h=w*3/4
      if MakeTableWidget: 
        count=self.VideoporamaInstance.win.TableZoomPoint.rowCount()
        ZoomPoint=ZoomPointItem(x,y,w,h,timeFixe, zoom,timeToTravel,self.VideoporamaInstance,TextToAdd,count,self)
        self.VideoporamaInstance.win.TableZoomPoint.insertRow(count)
        self.NbrZoomPoint+=1
        self.VideoporamaInstance.win.TableZoomPoint.setCellWidget(count,0,ZoomPoint)
        self.VideoporamaInstance.win.TableZoomPoint.setRowHeight(count,ZoomPoint.h)
        self.VideoporamaInstance.win.TableZoomPoint.repaint()
        if MakeList: 
          self.MakeXMLZoomPointList()
          self.VideoporamaInstance.win.TableZoomPoint.setCurrentCell(count,0)
      else:
        #Count number of item
        i=0
        while LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")!="": i+=1
        #Add new item
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",unicode(x),u"ZoomPointTable")
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"y",unicode(y),u"ZoomPointTable")
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"zoom",unicode(zoom),u"ZoomPointTable")
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeFixe",unicode(timeFixe),u"ZoomPointTable")
        UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeToTravel",unicode(timeToTravel),u"ZoomPointTable")
        if TextToAdd!=None:
          xmlPoint=self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(i))[0]
          xmlPoint.appendChild(TextToAdd)

        self.NbrZoomPoint+=1

    def ExportSequenceToXML(self) :
      doc=Document()
      xmlRoot=doc.createElement(u"SaveXML")
      doc.appendChild(xmlRoot)
      xmlChild=doc.createElement(u"Sequence")
      xmlChild.setAttribute(u'ObjectType',unicode(self.ObjectType))
      xmlChild.setAttribute(u'transition',unicode(self.typet))
      xmlChild.setAttribute(u'tr_option',unicode(self.opttransi))
      xmlChild.setAttribute(u'speedt',unicode(self.speedt))
      xmlChild.setAttribute(u'bgcolor',unicode(self.bgcolor))
      xmlChild.setAttribute(u'bgfile',unicode(self.bgfile))
      xmlChild.setAttribute(u'urlimage',unicode(self.urlim))
      xmlChild.setAttribute(u'EXIF_Orientation',unicode(self.EXIF_Orientation))
      xmlChild.setAttribute(u'EndVideo',unicode(self.EndVideo.toString("HH:mm:ss.zzz")))
      xmlChild.setAttribute(u'StartVideo',unicode(self.StartVideo.toString("HH:mm:ss.zzz")))

      #Transfert image text to XMLFile
      xmlText=xmlChild.getElementsByTagName(u"Text")
      if self.XMLText!=None:
        xmlText=self.XMLText.getElementsByTagName(u"Text")
        if xmlText.length>0 :
          xmlText=xmlText[0]
          TextToAdd=self.XMLText.importNode(xmlText,True)
          xmlChild.appendChild(TextToAdd)

      #Transfert XML ZoomPointList of each item to XMLFile
      j=0
      x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(j),u"x",u"ZoomPointTable")
      while x!="":
        y           =LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(j),u"y",u"ZoomPointTable")
        zoom        =LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(j),u"zoom",u"ZoomPointTable")
        timeFixe    =LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(j),u"timeFixe",u"ZoomPointTable")
        timeToTravel=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(j),u"timeToTravel",u"ZoomPointTable")
        
        # add zoompoint to xml
        xmlSubChild=doc.createElement(u"Point-"+unicode(j))
        xmlSubChild.setAttribute(u'x',unicode(x))
        xmlSubChild.setAttribute(u'y',unicode(y))
        xmlSubChild.setAttribute(u'zoom',unicode(zoom))
        xmlSubChild.setAttribute(u'timeFixe',unicode(timeFixe))
        xmlSubChild.setAttribute(u'timeToTravel',unicode(timeToTravel))
        
        # Transfert ZoompointText item(s)
        xmlPoint=self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(j))[0]
        xmlText=xmlPoint.getElementsByTagName(u"Text")
        if xmlText.length>0 :
          xmlText=xmlText[0]
          xmlSubChild.appendChild(self.ZoomPointList.importNode(xmlText,True))

        xmlChild.appendChild(xmlSubChild)
        j+=1
        x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(j),u"x",u"ZoomPointTable")

      xmlRoot.appendChild(xmlChild)
      return doc

    #Construct TableZoomPoint by scanning ZoomPointList
    def MakeTableZoomPointFromXML(self):
      #Clean TableZoomPoint
      i=0
      while i<self.VideoporamaInstance.win.TableZoomPoint.rowCount() : self.VideoporamaInstance.win.TableZoomPoint.removeRow(i)
      self.NbrZoomPoint=0
      if self.ObjectType!=2:
        i=0
        x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")
        while x!="":
          y            = LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"y",u"ZoomPointTable")
          zoom         = LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"zoom",u"ZoomPointTable")
          timeFixe     = LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeFixe",u"ZoomPointTable")
          timeToTravel = LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeToTravel",u"ZoomPointTable")
           # Text
          xmlPoint=self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(i))[0]
          xmlText=xmlPoint.getElementsByTagName(u"Text")
          if xmlText.length>0 :
            xmlText=xmlText[0]
            TextToAdd=Document()
            xmlRoot=TextToAdd.createElement(u"SaveXML")
            TextToAdd.appendChild(xmlRoot)
            xmlRoot.appendChild(self.ZoomPointList.importNode(xmlText,True))
          else:
            TextToAdd=None
          self.AddZoomPointItem(float(x),float(y),float(timeFixe),float(zoom), float(timeToTravel),False,True,TextToAdd)

          i+=1
          x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")

    #Construct ZoomPointList by scanning TableZoomPoint
    def MakeXMLZoomPointList(self):
      self.ZoomPointList = Document()
      xmltag = self.ZoomPointList.createElement(u"ZoomPointTable")
      self.ZoomPointList.appendChild(xmltag)
      if self.ObjectType!=2:
        i=0
        while i<self.VideoporamaInstance.win.TableZoomPoint.rowCount():
          item=self.VideoporamaInstance.win.TableZoomPoint.cellWidget(i,0)
          if item!=None : 
            UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",unicode(item.x),u"ZoomPointTable")
            UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"y",unicode(item.y),u"ZoomPointTable")
            UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"zoom",unicode(item.zoom),u"ZoomPointTable")
            UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeFixe",unicode(item.timeFixe),u"ZoomPointTable")
            UpdateAttributXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeToTravel",unicode(item.timeToTravel),u"ZoomPointTable")
            # Text
            if item.XMLText!=None:
              xmlPoint=self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(i))[0]
              xmlText=item.XMLText.getElementsByTagName(u"Text")
              if xmlText.length>0 :
                xmlText=xmlText[0]
                TextToAdd=item.XMLText.importNode(xmlText,True)
                xmlPoint.appendChild(TextToAdd)
          i+=1

    def ResetThumb(self):
      self.CacheThumb=None
      self.ImageLoaded=None
      self.updatePix()
      i=0
      while (i<self.VideoporamaInstance.win.TableZoomPoint.rowCount()):
        self.VideoporamaInstance.win.TableZoomPoint.cellWidget(i,0).CacheThumb=None
        self.VideoporamaInstance.win.TableZoomPoint.cellWidget(i,0).updatePix()
        i+=1
      
    def updatePix(self) :
      hpix=self.VideoporamaInstance.win.timeline.height()-18
      if self.VideoporamaInstance.imgformat == 1 : wpix=(hpix-4)*16/9+34
      else : wpix=(hpix-4)*4/3+34

      dessin=QPixmap(wpix,hpix)
      
      # Init a QPainter object
      p=QPainter(dessin)
      
      # Fill the area with lightGray or White backgroundcolor if is selected
      p.fillRect(QRect(0,0,wpix+1,hpix+1), QColor(QtCore.Qt.lightGray))

      # Display the rendered image
      if self.CacheThumb==None:
        self.ImageLoaded=None
        Image,Unused=self.ToRenderImageForDisplay(0,wpix-38,hpix-4,0,0,0,0,False,False,False)
        self.CacheThumb=Image
      else: Image=self.CacheThumb
      p.drawImage(2,2,Image)

      # Display border around image
      p.setPen(QtCore.Qt.black)
      p.drawLine(2, 2, wpix-38+1, 2)
      p.drawLine(wpix-38+1, 2, wpix-38+1, hpix-3)
      p.drawLine(wpix-38+1, hpix-3, 2, hpix-3)
      p.drawLine(2, hpix-3, 2, 2)

      # Display the image time and transition time
      p.setFont(QtGui.QFont('Decorative', 7))
      timeT    = self.CalcImageTime()[0]
      p.setPen(QtCore.Qt.black)
      AffDuree = u"%.2f" % float(timeT)
      p.drawText(QRectF(wpix-35, 35, 33,10), QtCore.Qt.AlignCenter | QtCore.Qt.AlignTop, AffDuree)

      # Define the transition icon name
      if (self.typet==7):
        b=lumaList()[1]
        FNameTr="iconstr/"+b[int(self.opttransi)]
      else:
        FNameTr="iconstr/tr-0"+unicode(self.typet)+"-0"+unicode(self.opttransi)+".png"

      try: # Add transition icon
        pixTr=QImage(FNameTr)
        p.drawImage(wpix-35+1, 2, pixTr)
      except:
        None
       
      # Display image file name
      filename= basename = self.urlim.split('/')[-1]
      p.setPen(QtGui.QColor(0,0,0))
      p.drawText(QRectF(5, hpix-30-3, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)
      p.drawText(QRectF(3, hpix-30-3, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)
      p.drawText(QRectF(5, hpix-30-5, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)
      p.drawText(QRectF(3, hpix-30-5, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)
      p.setPen(QtGui.QColor(255,255,255))
      p.drawText(QRectF(4, hpix-30-4, wpix-40, 30), QtCore.Qt.AlignLeft | QtCore.Qt.TextWrapAnywhere | QtCore.Qt.AlignBottom, filename)

      # Display Zoom icon if zoom is define
      if self.NbrZoomPoint >= 2 :
        zico = QImage("icons/zoom.png")
        p.drawImage(5, 5, zico)

      # Display Movie icon if it's amovie
      if self.ObjectType   == 0 : zico = QImage("icons/Frame_TextOnly.png")
      elif self.ObjectType == 1 : zico = QImage("icons/image.png")
      elif self.ObjectType == 2 : zico = QImage("icons/film.png")
      p.drawImage(wpix-35+(35-zico.width())/2, hpix-3-zico.height(), zico)

      if (self.StateSelected==True) :
        #define a pen for the rectangle
        pen=QPen(QtCore.Qt.blue)
        pen.setWidth(6)
        p.setPen(pen)
        #draw select rectangle
        p.drawRect(QRect(0,0,wpix,hpix))

      # Close QPainter object  
      p.end()
      self.setPixmap(dessin)

    #-------------------------------------------------------------------------------------------------------------
    # Render functions
    #-------------------------------------------------------------------------------------------------------------
    #ToRenderImageForMovie use self.ImageCacheMovie as cache image with no max
    #Cache image must be free as soon as possible !
    #-------------------------------------------------------------------------------------------------------------
    def ToRenderImageForMovie(self,NumZoomPoint,OuputWidth,OutputHeight,fx=0,fy=0,fw=0,fh=0,StopAtFullImage=False,DontRenderImageText=False,DontRenderZoomPointText=False,TheCacheRender=None):
      # For movie, process is in the renderdlg code
      if self.ObjectType==2 : return

      # Be sure size are float
      OuputWidth  =float(OuputWidth)
      OutputHeight=float(OutputHeight)

      if TheCacheRender==None:
        # Load source image from disk and prepare it with background and correct geometry
        # and calcul xmax and ymax for pixel display mode
        if self.ImageCacheMovie==None:
          self.LoadEXIF() # It's time to load EXIF data
          self.ImageCacheMovie,tempxmax,tempymax=LoadAndPrepareImage(self.urlim,self.VideoporamaInstance.ConfAutoRotate,self.bgfile,self.bgcolor,self.VideoporamaInstance.imgformat,self.EXIF_Orientation)
        SourceImage=self.ImageCacheMovie.copy()

        # Apply image text item
        if DontRenderImageText==False and self.XMLText!=None : SourceImage=ApplyTextToQImage(SourceImage,self.XMLText.getElementsByTagName(u"SaveXML")[0])

        # Scale source image using ZoomPoint if needed
        if StopAtFullImage==False and NumZoomPoint!=-1:
          #Crop image to zoompoint rectangle (if needed)
          x   =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"x",u"ZoomPointTable"))
          y   =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"y",u"ZoomPointTable"))
          zoom=float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"zoom",u"ZoomPointTable"))/100
          if (x!=0 or y!=0 or zoom!=1):
            SourceImage=SourceImage.copy(x*float(SourceImage.width()),y*float(SourceImage.height()),zoom*float(SourceImage.width()),zoom*float(SourceImage.height()))
        TheCacheRender=SourceImage
       
      if StopAtFullImage and NumZoomPoint!=-1 : SourceImage = TheCacheRender.copy(fx, fy, fw, fh) 
      else : SourceImage=TheCacheRender

      # Scale image to correct size (aspect ratio must be correct !)
      SourceImage=SourceImage.scaled(OuputWidth,OutputHeight,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)

      # Apply Zoompoint text item
      if DontRenderZoomPointText==False:
        SourceImage=ApplyTextToQImage(SourceImage,self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(NumZoomPoint))[0])

      return SourceImage,TheCacheRender
    #-------------------------------------------------------------------------------------------------------------
    #ToRenderImageForDisplay use self.ImageLoaded as cache image with a max à 720 row
    #Cache image stay valid all time
    #-------------------------------------------------------------------------------------------------------------
    def ToRenderImageForDisplay(self,NumZoomPoint,OuputWidth,OutputHeight,fx=0,fy=0,fw=0,fh=0,StopAtFullImage=False,DontRenderImageText=False,DontRenderZoomPointText=False,TheCacheRender=None):
      # Be sure size are float
      OuputWidth  =float(OuputWidth)
      OutputHeight=float(OutputHeight)

      if TheCacheRender==None:
        # Load source image from disk and prepare it with background and correct geometry
        # and calcul xmax and ymax for pixel display mode
        if self.ImageLoaded==None:
          if self.ObjectType==2:
            self.LoadMovieInfo()
            Process=QProcess()
            self.MovieSeekAtCodecLevel=False
            # Note : for ffmpeg seek faster it's necessary -ss was place before -i for it seek at the container level rather than the decoder level
            Commande = "\""+self.VideoporamaInstance.I+"ffmpeg\" -y -ss "+self.StartVideo.toString("HH:mm:ss.zzz")+" -i \""+self.urlim+"\" -qscale 2 -vframes 1 -r 1 -f image2pipe -vcodec ppm -"
            Process.setProcessChannelMode(QProcess.SeparateChannels)
            Process.setReadChannel(QProcess.StandardOutput)
            Process.start(Commande)
            # Wait until encoding is ready  
            Process.waitForStarted()
            Process.waitForReadyRead()
            # Wait ffmpeg is finished
            Process.waitForFinished()
            # Keep size of a movie image
            self.MoviePPMSize=Process.bytesAvailable()
            if self.MoviePPMSize==0:
              # Error during seek - maybe this file have an invalid dts/pts combination
              # Retry with -ss in codec mode (very slow)
              Commande = "\""+self.VideoporamaInstance.I+"ffmpeg\" -y -i \""+self.urlim+"\" -qscale 2 -vframes 1 -r 1 -ss "+self.StartVideo.toString("HH:mm:ss.zzz")+" -f image2pipe -vcodec ppm -"
              Process.setProcessChannelMode(QProcess.SeparateChannels)
              Process.setReadChannel(QProcess.StandardOutput)
              Process.start(Commande)
              Process.waitForStarted()                    # Wait until encoding is ready
              Process.waitForReadyRead()
              Process.waitForFinished()                   # Wait ffmpeg is finished
              self.MoviePPMSize=Process.bytesAvailable()  # Keep size of a movie image
              self.MovieSeekAtCodecLevel=True             # Keep this information
            self.ImageLoaded=QImage()
            # Read Image from pipe & Prepare the image
            if self.ImageLoaded.load(Process,"PPM")==True:
              # if MovieGeometry is 16/9, verify image is 16/9 and scale image if it's not correct
              if self.MovieGeometry=="16:9":
                XS=self.ImageLoaded.width()
                YS=self.ImageLoaded.height()
                if YS=="1088": YS="1080"  #Special case : same camera use 1920x1088 instead of 1920x1080
                if ((int(XS)/16)*9)!=int(YS): self.ImageLoaded=self.ImageLoaded.scaled(int(16*(float(YS)/9)),YS,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
              self.ImageLoaded,self.xmax,self.ymax=LoadAndPrepareImage("PIPE",self.VideoporamaInstance.ConfAutoRotate,self.bgfile,self.bgcolor,self.VideoporamaInstance.imgformat,self.EXIF_Orientation,self.ImageLoaded)
            else:
              self.ImageLoaded,self.xmax,self.ymax=LoadAndPrepareImage("",self.VideoporamaInstance.ConfAutoRotate,self.bgfile,self.bgcolor,self.VideoporamaInstance.imgformat,self.EXIF_Orientation)
          else:
            self.LoadEXIF() # It's time to load EXIF data
            self.ImageLoaded,self.xmax,self.ymax=LoadAndPrepareImage(self.urlim,self.VideoporamaInstance.ConfAutoRotate,self.bgfile,self.bgcolor,self.VideoporamaInstance.imgformat,self.EXIF_Orientation)
          self.RealImageSizeWidth=self.xmax
          self.RealImageSizeHeight=self.ymax
          # For memory and speed, be sure cache image is not >720 pt
          if self.ymax>720:
            if self.VideoporamaInstance.imgformat==1 :
              self.xmax=1280
              self.ymax=720
            else :
              self.xmax=960
              self.ymax=720
            self.ImageLoaded=self.ImageLoaded.scaled(self.xmax,self.ymax,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)
        SourceImage=self.ImageLoaded.copy()

        # Apply image text item
        if DontRenderImageText==False and self.XMLText!=None : SourceImage=ApplyTextToQImage(SourceImage,self.XMLText.getElementsByTagName(u"SaveXML")[0])

        # Scale source image using ZoomPoint if needed
        if self.ObjectType!=2 and StopAtFullImage==False and NumZoomPoint!=-1:
          #Crop image to zoompoint rectangle (if needed)
          x   =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"x",u"ZoomPointTable"))
          y   =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"y",u"ZoomPointTable"))
          zoom=float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"zoom",u"ZoomPointTable"))/100
          if (x!=0 or y!=0 or zoom!=1): SourceImage=SourceImage.copy(x*float(SourceImage.width()),y*float(SourceImage.height()),zoom*float(SourceImage.width()),zoom*float(SourceImage.height()))
        TheCacheRender=SourceImage

      if StopAtFullImage and NumZoomPoint!=-1 : SourceImage = TheCacheRender.copy(fx, fy, fw, fh) 
      else : SourceImage=TheCacheRender

      # Scale image to correct size (aspect ratio must be correct !)
      SourceImage=SourceImage.scaled(OuputWidth,OutputHeight,Qt.IgnoreAspectRatio,Qt.SmoothTransformation)

      # Apply Zoompoint text item
      if self.ObjectType!=2 and DontRenderZoomPointText==False: SourceImage=ApplyTextToQImage(SourceImage,self.ZoomPointList.getElementsByTagName(u"Point-"+unicode(NumZoomPoint))[0])

      return SourceImage,TheCacheRender

    #-------------------------------------------------------------------------------------------------------------
    # Function to calc time and transition time in frame and in second
    #-------------------------------------------------------------------------------------------------------------
    def CalcImageTime(self,imgpsec=25,StopAtShotNumber=-1) :
      ItemNumber = self.GetSeqNumber()                          # Current item number

      if ItemNumber==-1: return 0,0,0,0,0,0                     # When empty timeline, ItemNumber is -1

      SeqTime    = float(0)                                     # SeqTime = total time in second
      dicspeed   = {"0":4,"1":2,"2":1,"3":0.8,"4":0.4,"5":0.2}  # Transition duration in second

      # Special case for NTSC
      if imgpsec==30 : ips = float(30000/1001)
      else :           ips = float(imgpsec)

      # Calc in transition time
      if ItemNumber>0:
        PrevItem  =self.VideoporamaInstance.win.timeline.cellWidget(0,ItemNumber-1)
        if PrevItem!=None:
          PrevTypeT =PrevItem.typet
          PrevSpeedT=PrevItem.speedt
          if PrevTypeT < 1 :
            InTrTime   =float(0)     # InTrTime     = IN transition time in second
            InTrFramNbr=float(0)     # InTrFramNbr  = number of IN transition frame
          else :
            InTrTime   =float(dicspeed[unicode(PrevItem.speedt)])  # InTrTime    = IN transition time in second
            InTrFramNbr=ips*InTrTime                               # InTrFramNbr = number of IN transition frame
        else :
          InTrTime   =float(0)
          InTrFramNbr=float(0)
      else:
        # Special case for first transition
        InTrTime   =float(dicspeed[unicode("1")])     # InTrFramNbr  = number of IN transition frame
        InTrFramNbr=ips*InTrTime                      # InTrTime     = IN transition time in second

      # Calc out transition time
      if self.typet < 1 :
        OutTrTime   =float(0)     # OutTrTime     = OUT transition time in second
        OutTrFramNbr=float(0)     # OutTrFramNbr  = number of OUT transition frame
      else :
        OutTrTime   =float(dicspeed[unicode(self.speedt)])  # OutTrTime    = OUT transition time in second
        OutTrFramNbr=ips*OutTrTime                          # OutTrFramNbr = number of OUT transition frame

      # Calc real sequence time
      if self.ObjectType!=2 :
        i=0
        x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")
        # if StopAtShotNumber>=0 then calc time at the begining of the StopAtShotNumber shot
        while x!="" and ((StopAtShotNumber==-1) or (i<StopAtShotNumber)):
          SeqTime=SeqTime+float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeFixe",u"ZoomPointTable"))
          if i!=0: SeqTime=SeqTime+float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"timeToTravel",u"ZoomPointTable"))
          i += 1
          x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(i),u"x",u"ZoomPointTable")
      else:
        # if StopAtShotNumber==0 then calc time at the begining of the sequence
        if StopAtShotNumber==0: SeqTime=0
        else :                  SeqTime=(float(self.DurationVideo.hour())*60+float(self.DurationVideo.minute()))*60+float(self.DurationVideo.second())+float(self.DurationVideo.msec())/1000

      # Adjust sequence time for the two transitions was full
      if StopAtShotNumber==-1:
        if SeqTime<(InTrTime+OutTrTime) : SeqTime=InTrTime+OutTrTime

      SeqFramNbr=int(SeqTime*ips)    # SeqFramNbr = number of frame to show sequence
      return (SeqTime,int(SeqFramNbr),InTrTime,int(InTrFramNbr),OutTrTime,int(OutTrFramNbr))

    #-------------------------------------------------------------------------------------------------------------
    # Function to generate a specific frame base on frame number
    #    frameNbr = number of wanted frame (from 0 to number of frame with this image source)
    #    outputW = Width of output image
    #    outputH = Height of output image
    #    frImg = number of frame to show image without transition
    #    frTransi = Current transition position (from 0 to number of frame in transition periode)
    #    Return an image in PIL format""", the number of next identical frame
    #-------------------------------------------------------------------------------------------------------------
    def getFrameImage(self,imgpsec,frameNbr,outputW,outputH,IsPreview=False,RenderMobileOptimisation=None) :
      if RenderMobileOptimisation==None :
        if IsPreview==False:
          #Be sur imageCacheMovie is ok
          if self.ImageCacheMovie==None:
            self.LoadEXIF() # It's time to load EXIF data
            self.ImageCacheMovie,tempxmax,tempymax=LoadAndPrepareImage(self.urlim,self.VideoporamaInstance.ConfAutoRotate,self.bgfile,self.bgcolor,self.VideoporamaInstance.imgformat,self.EXIF_Orientation)

        time                 = 0
        CurrentZoomPoint     = 0
        SeqFrameStart        = 0
        SeqFrameDuration     = 0
        CurrentAnimationPart = 0

        # if first static shot duration is 0 : go to 2nd mobile shot
        TestTime1=int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"timeFixe",u"ZoomPointTable")))
        if TestTime1==0: TestTime2=int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint+1),u"timeFixe",u"ZoomPointTable")))
        else: TestTime2=0
        if TestTime1==0 and frameNbr<=TestTime2:
          CurrentZoomPoint    =1
          CurrentAnimationPart=1
          SeqFrameStart       =time
          SeqFrameDuration    =int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"timeToTravel",u"ZoomPointTable")))
          time                +=SeqFrameDuration
        else :
          x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"x",u"ZoomPointTable")
          while x!="" and frameNbr>=time :
            # start by animated plan
            if CurrentZoomPoint!=0:
              CurrentAnimationPart=1
              SeqFrameStart    =time
              SeqFrameDuration =int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"timeToTravel",u"ZoomPointTable")))
              time            +=SeqFrameDuration
            # Check if we need to continu
            if frameNbr>time or SeqFrameDuration==0 :
              # fixe plan
              CurrentAnimationPart=0
              SeqFrameStart    =time
              SeqFrameDuration =int(imgpsec*float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint),u"timeFixe",u"ZoomPointTable")))
              time            +=SeqFrameDuration
              #Check if we need to continu
              if frameNbr>time :
                x=LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(CurrentZoomPoint+1),u"x",u"ZoomPointTable")
                #if x=="" then we have reach the last frame for this sequence 
                if x!="" :
                  CurrentZoomPoint += 1
              else:
                x=""
            else:
              x=""
          
      # If nothing found
      if RenderMobileOptimisation==None and CurrentAnimationPart==0 : # Fixe part
        # Render zoompoint with text (if exist)
        if IsPreview==False: img,UnusedCacheRender = self.ToRenderImageForMovie(CurrentZoomPoint,outputW,outputH,StopAtFullImage=False,DontRenderImageText=False,DontRenderZoomPointText=False)
        else :               img,UnusedCacheRender = self.ToRenderImageForDisplay(CurrentZoomPoint,outputW,outputH,StopAtFullImage=False,DontRenderImageText=False,DontRenderZoomPointText=False)
        #Optimisation des rendus : Calcul le nombre de frame identique à partir d'ici !
        NbrFrameEqual =time-frameNbr
        NbrFrameMobile=0
      else : # Mobile part
        if RenderMobileOptimisation==None :
          #Save value for next use
          RenderMobileOptimisation=cRenderMobileOptimisation(self,IsPreview,CurrentZoomPoint,time,SeqFrameStart,SeqFrameDuration)

        NbrFrameEqual =0
        NbrFrameMobile=RenderMobileOptimisation.time-frameNbr

        if RenderMobileOptimisation.SeqFrameDuration!=0 : progImg = float(frameNbr-RenderMobileOptimisation.SeqFrameStart)/float(RenderMobileOptimisation.SeqFrameDuration)
        else : progImg = 0

        # à changer pour repasser en linéaire
        if 1==1: progImg=math.sin(math.radians(90)*progImg)

        # Coordinate intermediaire
        Xi = (RenderMobileOptimisation.end[0]-RenderMobileOptimisation.start[0])*progImg+RenderMobileOptimisation.start[0]
        Yi = (RenderMobileOptimisation.end[1]-RenderMobileOptimisation.start[1])*progImg+RenderMobileOptimisation.start[1]
        Wi = (RenderMobileOptimisation.end[2]-RenderMobileOptimisation.start[2])*progImg+RenderMobileOptimisation.start[2]
        Hi = (RenderMobileOptimisation.end[3]-RenderMobileOptimisation.start[3])*progImg+RenderMobileOptimisation.start[3]

        # Render zoompoint without text (StopAtFullImage=True)
        if IsPreview==False: img,RenderMobileOptimisation.CacheRender = self.ToRenderImageForMovie(RenderMobileOptimisation.CurrentZoomPoint,outputW,outputH,Xi,Yi,Wi,Hi,StopAtFullImage=True,DontRenderImageText=False,DontRenderZoomPointText=True,TheCacheRender=RenderMobileOptimisation.CacheRender)
        else :               img,RenderMobileOptimisation.CacheRender = self.ToRenderImageForDisplay(RenderMobileOptimisation.CurrentZoomPoint,outputW,outputH,Xi,Yi,Wi,Hi,StopAtFullImage=True,DontRenderImageText=False,DontRenderZoomPointText=True,TheCacheRender=RenderMobileOptimisation.CacheRender)

      #return QImageToPil(img),NbrFrameEqual,NbrFrameMobile,RenderMobileOptimisation
      return img,NbrFrameEqual,NbrFrameMobile,RenderMobileOptimisation

    def GetXYWH(self,NumZoomPoint,xmax,ymax):
      x    =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"x",u"ZoomPointTable"))*xmax
      y    =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"y",u"ZoomPointTable"))*ymax
      zoom =float(LoadAttributFromXMLFile(self.ZoomPointList,u"Point-"+unicode(NumZoomPoint),u"zoom",u"ZoomPointTable"))/100
      w    =zoom*xmax
      h    =zoom*ymax
      return x,y,w,h

    def getTimeImage(self, ips, last=0) :
      time = self.CalcImageTime(ips)
      timeImage = imgTimelineObj(time, self.CacheThumb, last)
      timeImage.drawPix()
      return timeImage

#----------------------------------------------------------------------------------------------------------
# Class to cache xml information for render optimisation of mobile shot
#----------------------------------------------------------------------------------------------------------
class cRenderMobileOptimisation :
  def __init__(self,myLabelObject,IsPreview,CurrentZoomPoint,time,SeqFrameStart,SeqFrameDuration) :
    self.myLabelObject    =myLabelObject
    self.IsPreview        =IsPreview
    self.CurrentZoomPoint =CurrentZoomPoint
    self.time             =time
    self.SeqFrameStart    =SeqFrameStart
    self.SeqFrameDuration =SeqFrameDuration
    self.CacheRender      =None
    
    # Get value from prev zoompoint to this zoompoint
    if self.IsPreview==False:
      self.start   = myLabelObject.GetXYWH(self.CurrentZoomPoint-1,myLabelObject.ImageCacheMovie.width(),myLabelObject.ImageCacheMovie.height())
      self.end     = myLabelObject.GetXYWH(self.CurrentZoomPoint,myLabelObject.ImageCacheMovie.width(),myLabelObject.ImageCacheMovie.height())
    else :
      self.start   = myLabelObject.GetXYWH(self.CurrentZoomPoint-1,myLabelObject.ImageLoaded.width(),myLabelObject.ImageLoaded.height())
      self.end     = myLabelObject.GetXYWH(self.CurrentZoomPoint,myLabelObject.ImageLoaded.width(),myLabelObject.ImageLoaded.height())

#----------------------------------------------------------------------------------------------------------
# Class to define object image to show scaled timeline of montage"""
#----------------------------------------------------------------------------------------------------------
class imgTimelineObj(QLabel) :
    # Attributes
    imageTime = 0.0 # Time in second
    pixmapImg = None 		# QPixmap of base image
    
    def __init__(self, imageTime, pixmapImg, last, parent = None) :
      super(imgTimelineObj, self).__init__(parent)
      self.imageTime = imageTime
      self.pixmapImg = pixmapImg
      self.last = last
      
    def drawPix(self) :
      """Update scaled pixmap of sound object. 1 sec = 40 pixels"""
      if self.last :
        self.timeTot = self.imageTime[0]
      else :
        self.timeTot = self.imageTime[0]-self.imageTime[4]
      pixmap = QPixmap(int(self.timeTot*40), 100)
      pixmap.fill(Qt.green)
      compose = QPainter(pixmap)
      compose.setCompositionMode(QPainter.CompositionMode_SourceOver)
      compose.setPen(QPen(QColor(250,250,0)))
      compose.setBrush(QBrush(QColor(250,250,0)))
      compose.drawRect(0,0, self.imageTime[2]*40,100)
      if self.last :
        compose.drawRect((self.imageTime[0]-self.imageTime[4])*40,0, self.imageTime[0]*40,100)
      if self.pixmapImg :
        compose.drawImage(5,0, self.pixmapImg.scaledToHeight(85))
      compose.setFont(QFont(QString("arial"), 8))
      compose.setPen(QPen(QColor(0,0,0)))
      compose.drawText(5, 96, QString(secondToPos(self.timeTot)))
      compose.end()
      self.setPixmap(pixmap)
