#ifndef INCLUDED_VIEW3DS_MAINWND_H 
#define INCLUDED_VIEW3DS_MAINWND_H 
/*
 * The 3D Studio File Format Library
 * Copyright (C) 1996-2001 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mainwnd.h,v 1.4 2001/01/15 10:56:12 jeh Exp $
 */

#include <qmainwindow.h>

class Document;
class Viewport;
class QSlider;
class QLineEdit;
class QComboBox;

/*!
 * Main window.
 */
class MainWnd : public QMainWindow {
  private:
    Q_OBJECT
    Document *d_doc;
    QString d_filename;
    Viewport *d_viewport;
    QSlider *d_slider;
    QLineEdit *d_edit;
    QComboBox *d_cameras;
  public:
    MainWnd(Document *doc, QWidget* parent=0, const char *name=0);
    virtual ~MainWnd();

  protected slots:
    void about();
    void aboutQt();
    void newDoc();
    void load();
    void save();
    void saveAs();
    void documentChanged();
    void currentChanged();
};

#endif // INCLUDED_VIEW3DS_VIEWPORT_H 



