
// created 06.2003 by Stefan Kleine Stegemann
// 
// licensed under GPL

#include "DocumentWindowController.h"

#include "AppController.h"
#include "DocumentWindow.h"

#include <Foundation/NSBundle.h>
#include <Foundation/NSDictionary.h>
#include <Foundation/NSException.h>
#include <Foundation/NSString.h>
#include <AppKit/NSMatrix.h>
#include <AppKit/NSMenuItem.h>
#include <AppKit/NSNibLoading.h>
#include <AppKit/NSPopUpButton.h>
#include <AppKit/NSTextField.h>

/*
 * Non-Public methods of DocumentWindowController
 */
@interface DocumentWindowController(PageLayoutPrivate)
@end


/*
 * The part of DocumentWindowController that supports
 * page layout configuration.
 */
@implementation DocumentWindowController(PageLayout)

/*
 * Display a panel to adjust the page layout of the
 * displayed document.
 */
- (void) showPageLayoutPanel: (id)sender
{
   NSArray*      papersizes;
   NSEnumerator* e;
   NSString*     aPapersize;


   if (!pageLayoutPanel)
   {
      [NSBundle loadNibNamed: @"pagelayout.gorm" owner: self];
   }

   NSAssert(pageLayoutPanel, @"could not load page layout panel");

   // init papersizes
   [paperSizesPopup removeAllItems];

   papersizes = [[[[AppController sharedController] papersizes] allKeys]
                   sortedArrayUsingSelector: @selector(caseInsensitiveCompare:)];

   e = [papersizes objectEnumerator];
   while ((aPapersize = [e nextObject]))
   {
      [paperSizesPopup addItemWithTitle: aPapersize];
      [[paperSizesPopup itemWithTitle: aPapersize] setTarget: self];
      [[paperSizesPopup itemWithTitle: aPapersize] 
         setAction: @selector(paperSizeSelected:)];
   }
   
   [paperSizesPopup selectItemWithTitle: currentPaperSizeName];

   // init page orientation
   [[pageOrientationButtons cellWithTag: TAG_PORTRAIT] 
      setState: (currentPageOrientation == TAG_PORTRAIT ? NSOnState: NSOffState)];
   [[pageOrientationButtons cellWithTag: TAG_LANDSCAPE] 
      setState: (currentPageOrientation == TAG_LANDSCAPE ? NSOnState : NSOffState)];
   
   // display panel
   [pageLayoutPanel setTitle: [NSString stringWithFormat: @"%@ (%@)",
                                        [pageLayoutPanel title],
                                        [(NSWindow*)[self window] title]]];

   [pageLayoutPanel orderFrontRegardless];
   [pageLayoutPanel makeKeyWindow];
   [pageLayoutPanel display];
}


/*
 * Invoked whenever the user selects a papersize from the
 * menu.
 */
- (void) paperSizeSelected: (id)sender
{
   NSDictionary* sizeDict;
   NSString*     selectedSizeName = [sender title];
   
   sizeDict = [[[AppController sharedController] papersizes]
                 objectForKey: selectedSizeName];

   NSAssert(sizeDict != nil, @"Papersize not found");

   if ([selectedSizeName isEqualToString: DEFAULT_PAPERSIZE])
   {
      [pageWidthText setStringValue: @""];
      [pageHeightText setStringValue: @""];
   }
   else if (![selectedSizeName isEqualToString: USER_DEFINED_PAPERSIZE])
   {
      [pageWidthText setFloatValue: [[sizeDict objectForKey: @"w"] floatValue]];
      [pageHeightText setFloatValue: [[sizeDict objectForKey: @"h"] floatValue]];
   }
}


/*
 * Apply the settings from the page layout panel
 * to the controllers document.
 */
- (void) applyPageLayout: (id)sender
{
   NSString* selectedPaperSize = [[paperSizesPopup selectedItem] title];
   int selectedOrientation;
   NSSize    newPaperSize;
   NSSize    userSize;

   if ([[pageOrientationButtons cellWithTag: TAG_PORTRAIT] state] == NSOnState)
   {
      selectedOrientation = TAG_PORTRAIT;
   }
   else
   {
      selectedOrientation = TAG_LANDSCAPE;
   }

   // apply paper size
   if ([selectedPaperSize isEqualToString: USER_DEFINED_PAPERSIZE])
   {
      newPaperSize =
         NSMakeSize([pageWidthText floatValue], [pageHeightText floatValue]);
   }
   else
   {
      NSDictionary* sizeDict = [[[AppController sharedController] papersizes]
                                  objectForKey: selectedPaperSize];

      NSAssert(sizeDict != nil, @"Papersize not found");

      newPaperSize = NSMakeSize([[sizeDict objectForKey: @"w"] floatValue],
                                [[sizeDict objectForKey: @"h"] floatValue]);
   }

   //TODO: [[self document] setPapersize: newPaperSize];

   // TODO: apply page orientation
   //[(ViewableDocument*)[self document] setPageOrientation:
   //                       (selectedOrientation == TAG_PORTRAIT ?
   //                        PageOrientation_Portrait : PageOrientation_Landscape)];



   if ((!NSEqualSizes(currentPaperSize, newPaperSize)) ||
       (selectedOrientation != currentPageOrientation))
   {
      currentPaperSizeName = selectedPaperSize;
      currentPaperSize = newPaperSize;
      currentPageOrientation = selectedOrientation;
      [self updatePageImage];
   }
}

@end
