/* vifm
 * Copyright (C) 2001 Ken Steen.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<errno.h>
#include<ncurses.h>
#include<signal.h>
#include<unistd.h> /* alarm() */
#include<sys/stat.h> /* stat */
#include<sys/time.h> /* timeval */
#include<sys/types.h> /* waitpid */
#include<sys/wait.h> /* waitpid */
#include<time.h>
#include<pthread.h>

#include"background.h"
#include"file_info.h"
#include"filelist.h"
#include"filetype.h"
#include"keys.h"
#include"menus.h"
#include"signals.h"
#include"status.h"
#include"config.h"
#include"ui.h"


/* Handle term resizing in X */
static void
received_sigwinch()
{
	if(!isendwin())
	{
		if (curr_stats.menu)
			curr_stats.redraw_menu = 1;
		else
			redraw_window();
	}
	else
		curr_stats.need_redraw = 1;
}

/* This just causes a core dump when there is a memory access error.
 * Only needed for debugging 
static void
received_sigsegv()
{
	int pid = -1;

	if ((pid == fork()) == -1)
	{
	}

	if (pid == 0)
	{
		_exit(0);

	}
	else
		fprintf(stdout, "This should cause a core dump");
	
}
*/
static void
received_sigchld()
{
	int status;
	pid_t pid;

	pid = waitpid(-1, &status, WNOHANG);

	remove_background_job(pid);
}

void
switch_views(void)
{
	FileView *tmp = curr_view;
	curr_view = other_view;
	other_view = tmp;
}

/* Checks if the vifmrc config file has changed. */

/* There is a problem with automatically updating the config file when 
 * running multiple sessions of vifm.  So this is commented out until 
 * I can get it fixed.
 *
static void
check_config_file(void)
{
	char buf[256];
	struct stat stat_buf;
	snprintf(buf, sizeof(buf), "%s/vifmrc%.1f", cfg.config_dir, VERSION);
	if(stat(buf, &stat_buf) == 0)
	{
		if(stat_buf.st_mtime > curr_stats.config_file_mtime)
		{
			clear_filetypes();
			read_config_file();
			curr_stats.config_file_mtime = stat_buf.st_mtime;
		}
	}
}
*/


/*
 * This checks the modified times of the directories.
 */
static void
check_for_file_changes(void)
{
	struct stat s;

	stat(other_view->curr_dir, &s);
	if((s.st_mtime != other_view->dir_mtime) && !cfg.show_full)
		curr_stats.reload_other_window = 1;

	stat(curr_view->curr_dir, &s);
	if(s.st_mtime  != curr_view->dir_mtime)
		curr_stats.reload_current_window = 1;

}

void
show_progress(void)
{
	static int count = 0;
				
	switch(count)
	{
		case 0:
			status_bar_message("Loading Menu |");
			break;
		case 1:
			status_bar_message("Loading Menu /");
			break;
		case 2: 
			status_bar_message("Loading Menu -");
			break;
		case 3:
			status_bar_message("Loading Menu \\");
			count = -1;
			break;
		default:
			count = -1;
			break;
	}

	wrefresh(status_bar);

	count++;
}

void
update_file_list(void *ptr)
{
	while(1)
	{
		sleep(1);

		if(!curr_stats.block_timer_thread || isendwin())
		{
			check_for_file_changes();
			/* check_config_file(); */
		}

		if (curr_stats.search)
				show_progress();
	}
}

void
start_timed_update_thread(void)
{
	if(cfg.auto_update)
	{
		pthread_t update_thread;
		pthread_create(&update_thread, NULL, (void *)&update_file_list, NULL);
	}
}


void
setup_signals(void)
{
	struct sigaction resize_action;
	struct sigaction sigchld_action;
	//struct sigaction sigsegv_action;

	resize_action.sa_handler = received_sigwinch;
	sigemptyset(&resize_action.sa_mask);
	resize_action.sa_flags = SA_RESTART;
	sigaction(SIGWINCH, &resize_action, NULL);

	sigchld_action.sa_handler = received_sigchld;
	sigemptyset(&sigchld_action.sa_mask);
	sigchld_action.sa_flags = SA_RESTART;
	sigaction(SIGCHLD, &sigchld_action, NULL);

	/* Needed for debugging.  The threads stop the program from creating a 
	 * core dump.  So start a new fork which will dump when it returns.
	sigchld_action.sa_handler = received_sigsegv;
	sigemptyset(&sigsegv_action.sa_mask);
	sigsegv_action.sa_flags = SA_RESTART;
	sigaction(SIGSEGV, &sigsegv_action, NULL);
	*/
}
