/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef NAVIGATIONWINDOW_H
#define NAVIGATIONWINDOW_H

#include <ListViewItem.h>
#include <SubstrateDefinition.h>

#include <qlistview.h>
#include <qobject.h>
#include <qguardedptr.h> 

class QPopupMenu;
class ListViewItem;
class GraphDefinition;
class ResultDefinition;
class ModifyGridWindow;
class ModifySmithWindow;
class ModifySweepWindow;
class SetDimensionValueWindow;
class ModifyOutputParameterWindow;

class NavigationWindow : public QListView
{
  Q_OBJECT
public:
  NavigationWindow( QWidget* parent );
  virtual ~NavigationWindow();

  static NavigationWindow* instance();

  void filenameChanged( const QString& filename );

  void addSchematic( const QString& name );
  void removeSchematic( const QString& name );

  void addFileBlock( const QString& name );
  void removeFileBlock( const QString& name );
  
  void addVariable( const QString& name, const QString& value );
  void updateVariable( const QString& name, const QString& value );
  void removeVariable( const QString& name );

  void updateSubstrate( const QString& name,
			SubstrateDefinition::SubstrateType type );
  void removeSubstrate( const QString& name );

  void addGraph( const GraphDefinition& graph );
  void modifyGraph( const QString& name );
  void removeGraph( const QString& name );
  void renameGraph( const QString& oldName, const QString& newName );
  
  void showModifyOutputParameterWindow( const QString& graphname, 
					ResultDefinition* definition = 0 );
  void updateOutputDefinition( const QString& graphName, ResultDefinition& definition );

  void updateDimension( const QString& name, const QString& value );
  void updateSweep();

  void reset();

  

private:
  void createNavigationTree();
  void createPopupMenu();

  void emptyBranch( ListViewItem* parent );
  void removeListItemFromBranch( ListViewItem* branch,
				 const QString& name );
  QListViewItem* addListItemToBranch( ListViewItem::ItemType type,
				      QListViewItem* branch,
				      const QString& name );
  ListViewItem* findListItemInBranch( ListViewItem* branch,
				      const QString& name );
  virtual void resizeEvent( QResizeEvent* );

  void createDimensionList();
  void createSweepList();

private slots:
  void itemSelectedSlot( QListViewItem* item );
  void popupMenuSlot( QListViewItem*, const QPoint&, int );

  void newItemSlot();
  void changeItemSlot();
  void renameItemSlot();
  void deleteItemSlot();

private:
  static NavigationWindow* instance_;

  ListViewItem* root_;
  ListViewItem* sweep_;
  ListViewItem* sweepType_;
  ListViewItem* sweepStart_;
  ListViewItem* sweepStop_;
  ListViewItem* sweepPoints_;
  ListViewItem* schematics_;
  ListViewItem* graphs_;
  ListViewItem* variables_;
  ListViewItem* dimensions_;
  ListViewItem* substrates_;
  ListViewItem* dataFiles_;

  QGuardedPtr<ModifySweepWindow> sweepWindow_;
  QGuardedPtr<SetDimensionValueWindow> editWindow_;
  QGuardedPtr<ModifyGridWindow> gridWindow_;
  QGuardedPtr<ModifySmithWindow> smithWindow_;
  QGuardedPtr<ModifyOutputParameterWindow> outputWindow_;

  //Popup menu
  QPopupMenu* menu_;
  int newMenuID_;
  int changeMenuID_;
  int renameMenuID_;
  int deleteMenuID_;
};

#endif

