#include <HelpWindow.h>

#include "images/home.xpm"
#include "images/back.xpm"
#include "images/forward.xpm"

#include <qdir.h>
#include <qmime.h>
#include <qframe.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qtextbrowser.h>
#include <qstringlist.h>

#include <stdlib.h>
#include <iostream>

using namespace std;

//----------------------------------------------------------------------------
HelpWindow::HelpWindow( QWidget* parent, const char* name, WFlags f )
    : QDialog(parent, name, FALSE, f),
    helpBrowser_(0),
    home_("")
{
  setCaption( name );

  QVBoxLayout* layout = new QVBoxLayout(this);

  QFrame* frame = new QFrame( this );
  frame->setFixedHeight( 30 );
  layout->addWidget( frame );

  QDir dir;
  QString vipecHome = QString(getenv("VIPECHOME"));
  if ( vipecHome.isEmpty() )
    {
#ifdef VIPECHOME
      vipecHome = QString(VIPECHOME);
      if (vipecHome.isEmpty())
        {
	  vipecHome = dir.absPath();
        }
#else
      vipecHome = dir.absPath();
#endif
    }
  home_ = vipecHome + "/help/index.html";
  const QStringList currentDir(".");
  helpBrowser_ = new QTextBrowser( this );
  helpBrowser_->setMimeSourceFactory ( QMimeSourceFactory::defaultFactory() );
  helpBrowser_->mimeSourceFactory()->setFilePath(currentDir);
  helpBrowser_->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  helpBrowser_->setSource( home_ );
  layout->addWidget( helpBrowser_ );

  QHBoxLayout* layout2 = new QHBoxLayout( frame );
  QToolButton* indexButton = new QToolButton( frame, "index" );
  indexButton->setPixmap( QPixmap(home_xpm) );
  connect( indexButton, SIGNAL( clicked() ),
           this, SLOT( index() ) );
  layout2->addWidget( indexButton );

  backButton_ = new QToolButton( frame, "back" );
  backButton_->setPixmap( QPixmap(back_xpm) );
  connect( backButton_, SIGNAL( clicked() ),
           helpBrowser_, SLOT( backward() ) );
  layout2->addWidget( backButton_ );

  forwardButton_ = new QToolButton( frame, "forward" );
  forwardButton_->setPixmap( QPixmap(forward_xpm) );
  connect( forwardButton_, SIGNAL( clicked() ),
           helpBrowser_, SLOT( forward() ) );
  layout2->addWidget( forwardButton_ );

  connect( helpBrowser_, SIGNAL( backwardAvailable( bool ) ),
           this, SLOT( setBackwardAvailable( bool ) ) );
  connect( helpBrowser_, SIGNAL( forwardAvailable( bool ) ),
           this, SLOT( setForwardAvailable( bool ) ) );

  resize(500, 550);

}

//----------------------------------------------------------------------------
HelpWindow::~HelpWindow()
{}

//----------------------------------------------------------------------------
void HelpWindow::index()
{
  helpBrowser_->setSource( home_ );
}

//----------------------------------------------------------------------------
void HelpWindow::setBackwardAvailable( bool b)
{
  backButton_->setEnabled( b );
}

//----------------------------------------------------------------------------
void HelpWindow::setForwardAvailable( bool b)
{
  forwardButton_->setEnabled( b );
}
