/* -*- C++ -*-
   
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef TABLEFRAME_H
#define TABLEFRAME_H

#include <qwidget.h>
#include <qtable.h>

class GraphView;

class TableFrame : public QTable
{
  Q_OBJECT
public:
  TableFrame(GraphView& parent, const char *name=0);
  virtual ~TableFrame();

  void reDraw();

  void setSize( int cols, int rows );
  void setHeader( int col, const QString& text );
  void setRowHeader( int row, const QString& text );
  void setCell( int col, int row, const QString& text );

protected:
  void drawContents( QPainter* p );

private:
  int indexOf( int row, int col ) const;
  
private:
  GraphView& view_;
  int curCol_;
  int curRow_;
};

#endif
