from dolfin import *
import math

class PlotFunction(Function):
    """Simple dolfin::Function to be plot using viper"""

    def __init__(self, element, mesh):
        Function.__init__(self, element, mesh)

    def eval(self, values, x):
        values[0] = sin(math.pi*x[0])*cos(math.pi*x[1])

class PlotFunction2(Function):
    """Simple 3d dolfin::Function to be plot using viper"""

    def __init__(self, element, mesh):
        Function.__init__(self, element, mesh)

    def eval(self, values, x):
        values[0] = sin(math.pi*x[0])*cos(math.pi*x[1])*exp(x[2])


if __name__ == "__main__":
    mesh = UnitSquare(25, 25) # Construct mesh
    fe = FiniteElement("Lagrange", "triangle", 1) # Define finite element
    u = PlotFunction(fe, mesh) # Construct function given mesh and finite element
    plot(u) # Plot function
    interactive()

    mesh = UnitCube(15,15,15)
    fe = FiniteElement("Lagrange", "tetrahedron", 1) # Define finite element
    u = PlotFunction2(fe, mesh) # Construct function given mesh and finite element
    plot(u) # Plot function
    interactive()

