/* @(#) Turn XYZ to Lab colourspace. 
 * @(#) 
 * @(#) Usage: 	
 * @(#) 	im_XYZ2Lab( imagein, imageout )
 * @(#) 	IMAGE *imagein, *imageout;
 * @(#) 
 * @(#) Float in, float out.
 * @(#) 
 * @(#) Returns: -1 on error, else 0
 * Modifed:
 * 16/11/94 JC
 *	- uses im_wrapone()
 *	- in-line conversion
 * 27/1/03 JC
 *	- swapped cbrt() for pow(), more portable
 */

/*

    This file is part of VIPS.
    
    VIPS is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/
#include <vips/intl.h>

#include <stdio.h>
#include <math.h>

#include <vips/vips.h>

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Process a buffer of data.
 */
void
imb_XYZ2Lab( float *p, float *q, int n, im_colour_temperature *temp )
{
	int x;

	for( x = 0; x < n; x++ ) {
		double nX = p[0] / temp->X0;
		double nY = p[1] / temp->Y0;
		double nZ = p[2] / temp->Z0;
		double cbx, cby, cbz;
		double L, a, b;

		/* Convert.
		 */
		if( nX < 0.008856 ) 
			cbx = 7.7871 * nX + (16.0 / 116.0);
		else 
			cbx = pow( nX, 1.0 / 3.0 );

		if( nY < 0.008856 ) 
			cby = 7.787 * nY + (16.0 / 116.0);
		else 
			cby = pow( nY, 1.0 / 3.0 );

		if( nZ < 0.008856 ) 
			cbz = 7.787 * nZ + (16.0 / 116.0);
		else 
			cbz = pow( nZ, 1.0 / 3.0 );

		L = 116.0 * cby - 16.0;
		a = 500.0 * (cbx - cby);
		b = 200.0 * (cby - cbz);

		/* Copy to output buffer.
		 */
		q[0] = L;
		q[1] = a;
		q[2] = b;

		p += 3;
		q += 3;
	}
}

int 
im_XYZ2Lab_temp( IMAGE *in, IMAGE *out,
	double X0, double Y0, double Z0 )
{	
	im_colour_temperature *temp = IM_NEW( out, im_colour_temperature );

	/* Check input image.
	 */
	if( !temp )
		return( -1 );
	if( in->Bands != 3 || in->BandFmt != IM_BANDFMT_FLOAT || 
		in->Coding != IM_CODING_NONE ) {
		im_errormsg( "im_XYZ2Lab: 3-band uncoded float only" );
		return( -1 );
	}

	/* Prepare the output image 
	 */
	if( im_cp_desc( out, in) )
		return( -1 );
	out->Type = IM_TYPE_LAB;

	/* Do the processing.
	 */
	temp->X0 = X0;
	temp->Y0 = Y0;
	temp->Z0 = Z0;
	if( im_wrapone( in, out, 
		(im_wrapone_fn) imb_XYZ2Lab, temp, NULL ) )
		return( -1 );

	return( 0 );
}

int 
im_XYZ2Lab( IMAGE *in, IMAGE *out )
{	
	return( im_XYZ2Lab_temp( in, out, D65_X0, D65_Y0, D65_Z0 ) );
}
