/*
   Copyright (c) 2010 Sebastian Trueg <trueg@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include <KApplication>
#include <KCmdLineArgs>
#include <KAboutData>
#include <KUrl>
#include <KLineEdit>
#include <KLocale>
#include <KDialog>

#include "converterdialog.h"

int main( int argc, char *argv[] )
{
    KAboutData aboutData( "virtuosoconverter",
                          "virtuosoconverter",
                          ki18n("Virtuoso Converter"),
                          "1.1",
                          ki18n("Virtuoso V5 to V6 converter"),
                          KAboutData::License_GPL,
                          ki18n("(c) 2010, Sebastian Trüg"),
                          KLocalizedString(),
                          "http://nepomuk.kde.org" );
    aboutData.addAuthor(ki18n("Sebastian Trüg"), ki18n("Maintainer"), "trueg@kde.org");
    aboutData.setProgramIconName( "nepomuk" );

    KCmdLineArgs::init( argc, argv, &aboutData );

    KCmdLineOptions options;
	options.add("auto", ki18n("Automatic mode without user interaction"));
	options.add("nobackup", ki18n("Do not create a backup of the data before converting."));
	options.add("keepdump", ki18n("Keep the dump of the old database."));
    KCmdLineArgs::addCmdLineOptions( options );

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    KApplication app;

    ConverterDialog dlg( args->isSet( "auto" ),
                         args->isSet( "backup" ),
                         args->isSet( "keepdump" ) );
    dlg.show();

    return app.exec();
}
