/*
 * Copyright 2007-2008 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */


package net.java.visualvm.modules.glassfish.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.charts.DynamicSynchronousXYChartModel;

/**
 *
 * @author  Jaroslav Bachorik
 */
public class ConnectionQueuePanel extends javax.swing.JPanel implements Observer {
    private final static class SimulationModel extends Model {
        Random rnd = new Random();
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                while(true) {
                    setChanged();
                    notifyObservers();
                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e) {}
                }
            }
        };

        public SimulationModel() {
            new Thread(updater).start();
        }
        
        @Override
        public long getAverage15min() {
            return rnd.nextInt(200);
        }

        @Override
        public long getAverage1min() {
            return rnd.nextInt(200);
        }

        @Override
        public long getAverage5min() {
            return rnd.nextInt(200);
        }

        @Override
        public int getRefusalRate() {
            return rnd.nextInt(100);
        }

        @Override
        public RangedLong getUtilization() {
            return new RangedLong(0, 200, rnd.nextInt(200));
        }
    }
        
    private Model connQueueStatsModel;
    private Chart chart;
    
    /** Creates new form ConnectionQueuePanel */
    public ConnectionQueuePanel() {
        connQueueStatsModel = new SimulationModel();
//        connQueueStatsModel.addObserver(this);
        initComponents();
        initComponents2();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        labelUtilization = new javax.swing.JLabel();
        lableRefusalRate = new javax.swing.JLabel();
        refusalRate = new com.sun.tools.visualvm.core.ui.components.LevelIndicator();
        jSeparator1 = new javax.swing.JSeparator();
        chartLegend = new javax.swing.JPanel();
        chartPanel = new javax.swing.JPanel();
        utilization = new com.sun.tools.visualvm.core.ui.components.LevelIndicator();
        jLabel1 = new javax.swing.JLabel();

        setBackground(java.awt.Color.white);

        labelUtilization.setLabelFor(utilization);
        labelUtilization.setText(org.openide.util.NbBundle.getMessage(ConnectionQueuePanel.class, "ConnectionQueuePanel.labelUtilization.text")); // NOI18N

        lableRefusalRate.setLabelFor(refusalRate);
        lableRefusalRate.setText(org.openide.util.NbBundle.getMessage(ConnectionQueuePanel.class, "ConnectionQueuePanel.lableRefusalRate.text")); // NOI18N

        refusalRate.setFollowPeak(true);

        javax.swing.GroupLayout refusalRateLayout = new javax.swing.GroupLayout(refusalRate);
        refusalRate.setLayout(refusalRateLayout);
        refusalRateLayout.setHorizontalGroup(
            refusalRateLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 241, Short.MAX_VALUE)
        );
        refusalRateLayout.setVerticalGroup(
            refusalRateLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 11, Short.MAX_VALUE)
        );

        chartLegend.setOpaque(false);
        chartLegend.setLayout(new java.awt.BorderLayout());

        chartPanel.setOpaque(false);
        chartPanel.setLayout(new java.awt.BorderLayout());

        utilization.setFollowPeak(true);

        javax.swing.GroupLayout utilizationLayout = new javax.swing.GroupLayout(utilization);
        utilization.setLayout(utilizationLayout);
        utilizationLayout.setHorizontalGroup(
            utilizationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 241, Short.MAX_VALUE)
        );
        utilizationLayout.setVerticalGroup(
            utilizationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 10, Short.MAX_VALUE)
        );

        jLabel1.setText(org.openide.util.NbBundle.getMessage(ConnectionQueuePanel.class, "ConnectionQueuePanel.jLabel1.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(chartPanel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 366, Short.MAX_VALUE)
                    .addComponent(chartLegend, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 366, Short.MAX_VALUE)
                    .addComponent(jSeparator1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 366, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lableRefusalRate)
                            .addComponent(labelUtilization))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(utilization, javax.swing.GroupLayout.DEFAULT_SIZE, 245, Short.MAX_VALUE)
                            .addComponent(refusalRate, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 245, Short.MAX_VALUE)))
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(labelUtilization)
                    .addComponent(utilization, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(lableRefusalRate)
                    .addComponent(refusalRate, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chartPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 182, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chartLegend, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel chartLegend;
    private javax.swing.JPanel chartPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel labelUtilization;
    private javax.swing.JLabel lableRefusalRate;
    private com.sun.tools.visualvm.core.ui.components.LevelIndicator refusalRate;
    private com.sun.tools.visualvm.core.ui.components.LevelIndicator utilization;
    // End of variables declaration//GEN-END:variables

    public static abstract class Model extends GenericModel {
        public abstract RangedLong getUtilization();
        public abstract int getRefusalRate();
        public abstract long getAverage1min();
        public abstract long getAverage5min();
        public abstract long getAverage15min();
    }

    public Model getModel() {
        return connQueueStatsModel;
    }

    public void setModel(Model connQueueStatsModel) {
        if (this.connQueueStatsModel != null) {
            this.connQueueStatsModel.deleteObserver(this);
        }
        this.connQueueStatsModel = connQueueStatsModel;
        connQueueStatsModel.addObserver(this);
    }

    public void update(Observable o, Object arg) {
        GenericModel.RangedLong utilizationVal = connQueueStatsModel.getUtilization();
        utilization.setMinimum(utilizationVal.min);
        utilization.setMaximum(utilizationVal.max);
        utilization.setValue(utilizationVal.val);
                
        
        refusalRate.setMinimum(0);
        refusalRate.setMaximum(100);
        refusalRate.setValue(connQueueStatsModel.getRefusalRate());

        if (chart != null && chart.getChartModel() != null) {
            long[] values = new long[] {connQueueStatsModel.getAverage1min(), connQueueStatsModel.getAverage5min(), connQueueStatsModel.getAverage15min()};
            chart.getChartModel().addItemValues(System.currentTimeMillis(), values);
        }
        
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                repaint();
            }
        });
    }
    
    private void initComponents2() {
        chart = new Chart() {

            @Override
            protected void setupModel(DynamicSynchronousXYChartModel xyChartModel) {
                xyChartModel.setupModel(new String[]{"1min", "5min", "15min"}, new Color[]{Color.GREEN, Color.YELLOW, Color.BLUE});
            }      
        };
        
        chartPanel.add(chart, BorderLayout.CENTER);
        chartLegend.add(chart.createBigLegend(), BorderLayout.EAST);
    }
}
