/*
 * Copyright 2007-2008 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */


package net.java.visualvm.modules.glassfish.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import org.netbeans.lib.profiler.ui.charts.DynamicSynchronousXYChartModel;

/**
 *
 * @author  Jaroslav Bachorik
 */
public class KeepAlivePanel extends javax.swing.JPanel implements Observer {
    private final static class SimulationModel extends Model {
        Random rnd = new Random();
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                while(true) {
                    setChanged();
                    notifyObservers();
                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e) {}
                }
            }
        };

        public SimulationModel() {
            new Thread(updater).start();
        }
        
        @Override
        public long getRejected() {
            return rnd.nextInt(200);
        }

        @Override
        public long getClosed() {
            return rnd.nextInt(200);
        }

        @Override
        public long getTimedOut() {
            return rnd.nextInt(200);
        }

        @Override
        public RangedLong getUtilization() {
            return new RangedLong(0, 200, rnd.nextInt(200));
        }
    }
    
    private Model keepAliveStatsModel;
    private Chart chart;
    
    /** Creates new form ConnectionQueuePanel */
    public KeepAlivePanel() {
//        keepAliveStatsModel = new SimulationModel();
//        setModel(keepAliveStatsModel);
        initComponents();
        initComponents2();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        labelUtilization = new javax.swing.JLabel();
        utilization = new com.sun.tools.visualvm.core.ui.components.LevelIndicator();
        jSeparator1 = new javax.swing.JSeparator();
        chartLegend = new javax.swing.JPanel();
        chartPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();

        setBackground(java.awt.Color.white);

        labelUtilization.setLabelFor(utilization);
        labelUtilization.setText(org.openide.util.NbBundle.getMessage(KeepAlivePanel.class, "KeepAlivePanel.labelUtilization.text")); // NOI18N

        utilization.setAutoRepaint(false);
        utilization.setFollowPeak(true);

        javax.swing.GroupLayout utilizationLayout = new javax.swing.GroupLayout(utilization);
        utilization.setLayout(utilizationLayout);
        utilizationLayout.setHorizontalGroup(
            utilizationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 281, Short.MAX_VALUE)
        );
        utilizationLayout.setVerticalGroup(
            utilizationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 13, Short.MAX_VALUE)
        );

        chartLegend.setOpaque(false);
        chartLegend.setLayout(new java.awt.BorderLayout());

        chartPanel.setOpaque(false);
        chartPanel.setLayout(new java.awt.BorderLayout());

        jLabel1.setText(org.openide.util.NbBundle.getMessage(KeepAlivePanel.class, "KeepAlivePanel.jLabel1.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(chartPanel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
                    .addComponent(jSeparator1, javax.swing.GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
                    .addComponent(chartLegend, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(labelUtilization)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(utilization, javax.swing.GroupLayout.DEFAULT_SIZE, 285, Short.MAX_VALUE))
                    .addComponent(jLabel1))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(utilization, 0, 17, Short.MAX_VALUE)
                    .addComponent(labelUtilization))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chartPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 216, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chartLegend, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel chartLegend;
    private javax.swing.JPanel chartPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel labelUtilization;
    private com.sun.tools.visualvm.core.ui.components.LevelIndicator utilization;
    // End of variables declaration//GEN-END:variables

    public Model getModel() {
        return keepAliveStatsModel;
    }

    public void setModel(Model model) {
        if (this.keepAliveStatsModel != null) {
            this.keepAliveStatsModel.deleteObserver(this);
        }
        this.keepAliveStatsModel = model;
        model.addObserver(this);
    }
    
    public static abstract class Model extends GenericModel {
        public abstract RangedLong getUtilization();
        public abstract long getRejected();
        public abstract long getClosed();
        public abstract long getTimedOut();
    }

    public Model getConnQueueStatsModel() {
        return keepAliveStatsModel;
    }

    public void setConnQueueStatsModel(Model connQueueStatsModel) {
        if (this.keepAliveStatsModel != null) {
            this.keepAliveStatsModel.deleteObserver(this);
        }
        this.keepAliveStatsModel = connQueueStatsModel;
    }

    public void update(Observable o, Object arg) {
        utilization.setMinimum(keepAliveStatsModel.getUtilization().min);
        utilization.setMaximum(keepAliveStatsModel.getUtilization().max);
        utilization.setValue(keepAliveStatsModel.getUtilization().val);

        if (chart != null && chart.getChartModel() != null) {
            chart.getChartModel().addItemValues(System.currentTimeMillis(), new long[]{keepAliveStatsModel.getRejected(), keepAliveStatsModel.getClosed(), keepAliveStatsModel.getTimedOut()});
        }
        
        repaint();
    }
    
    private void initComponents2() {
        chart = new Chart() {

            @Override
            protected void setupModel(DynamicSynchronousXYChartModel xyChartModel) {
                xyChartModel.setupModel(new String[] { "Refused", "Flushed", "Timed Out" },
                                            new Color[] { Color.RED, Color.BLUE, Color.GREEN });
            }      
        };
        
        chartPanel.add(chart, BorderLayout.CENTER);
        chartLegend.add(chart.createBigLegend(), BorderLayout.EAST);
    }
}
