/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.AttributeNameMapper;
import com.sun.appserv.management.util.jmx.AttributeNameMapperImpl;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.MBeanAttributeInfoComparator;
import com.sun.appserv.management.util.jmx.MBeanGeneratorHook;
import com.sun.appserv.management.util.jmx.MBeanOperationInfoComparator;
import com.sun.appserv.management.util.misc.ClassUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MBeanGenerator
implements MBeanGeneratorHook {
    boolean mEmitComments = true;
    Map<String, Integer> mCounts = null;
    AttributeNameMapper mMapper;
    private static final String TAB = "\t";
    private static final String NEWLINE = "\n";
    private static final String PARAM_DELIM = ", ";
    public static final String FINAL_PREFIX = "final ";
    public static final int IMPORT_THRESHOLD = 2;
    private static final String BRACKETS = "[]";
    private static int sCounter = 0;

    static String stripBrackets(String name) {
        String result = name;
        while (result.endsWith(BRACKETS)) {
            result = result.substring(0, result.length() - BRACKETS.length());
        }
        return result;
    }

    private static void countType(Map<String, Integer> counts, String typeIn) {
        String type = MBeanGenerator.stripBrackets(ClassUtil.getFriendlyClassname(typeIn));
        Integer count = counts.get(type);
        count = count == null ? new Integer(1) : new Integer(count + 1);
        counts.put(type, count);
    }

    public static void countTypes(Map<String, Integer> counts, MBeanAttributeInfo[] infos) {
        for (int i = 0; i < infos.length; ++i) {
            MBeanGenerator.countType(counts, infos[i].getType());
        }
    }

    private static void countTypes(Map<String, Integer> counts, MBeanOperationInfo[] infos) {
        for (int i = 0; i < infos.length; ++i) {
            MBeanGenerator.countType(counts, infos[i].getReturnType());
            MBeanParameterInfo[] params = infos[i].getSignature();
            for (int p = 0; p < params.length; ++p) {
                MBeanGenerator.countType(counts, params[p].getType());
            }
        }
    }

    String getCodeClassname(String classname) {
        String name = ClassUtil.getFriendlyClassname(classname);
        if (this.typeMayBeAbbreviated(name)) {
            name = ClassUtil.stripPackagePrefix(name);
        }
        return name;
    }

    private Map<String, Integer> countAllTypes(MBeanInfo info) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        MBeanOperationInfo[] operationInfos = info.getOperations();
        if (attrInfos != null) {
            MBeanGenerator.countTypes(counts, attrInfos);
        }
        if (operationInfos != null) {
            MBeanGenerator.countTypes(counts, operationInfos);
        }
        return counts;
    }

    private String getImportBlock(Map counts) {
        StringBuffer buf = new StringBuffer();
        for (String key : counts.keySet()) {
            Integer count = (Integer)counts.get(key);
            if (count < 2 || this.isUnqualifiedType(key)) continue;
            buf.append("import " + key + ";" + NEWLINE);
        }
        return buf.toString();
    }

    protected boolean isUnqualifiedType(String type) {
        return type.indexOf(".") < 0;
    }

    protected boolean typeMayBeAbbreviated(String type) {
        Integer count = this.mCounts.get(type);
        if (count == null) {
            return false;
        }
        return count >= 2;
    }

    public String generate(MBeanInfo info, boolean emitComments) {
        this.mEmitComments = emitComments;
        StringBuffer buf = new StringBuffer();
        if (this.mEmitComments) {
            buf.append(this.getHeaderComment(info) + NEWLINE + NEWLINE);
        }
        buf.append("package " + this.getPackageName(info) + ";" + NEWLINE);
        this.mCounts = this.countAllTypes(info);
        buf.append(NEWLINE + this.getImportBlock(this.mCounts) + NEWLINE);
        if (this.mEmitComments) {
            buf.append(this.getInterfaceComment(info) + NEWLINE + NEWLINE);
        }
        String interfaceName = this.getClassname(info);
        buf.append("public interface " + interfaceName + " \n{\n");
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        MBeanOperationInfo[] operationInfos = info.getOperations();
        if (attrInfos != null) {
            Arrays.sort(attrInfos, MBeanAttributeInfoComparator.INSTANCE);
            buf.append(this.generateAttributes(attrInfos));
        }
        if (operationInfos != null && operationInfos.length != 0) {
            Arrays.sort(operationInfos, MBeanOperationInfoComparator.INSTANCE);
            buf.append("\n// -------------------- Operations --------------------\n");
            buf.append(this.generateOperations(operationInfos));
        }
        buf.append("\n}");
        return buf.toString();
    }

    protected String indent(String contents, String prefix) {
        StringBuffer buf = new StringBuffer();
        if (contents.length() != 0) {
            String[] lines = contents.split(NEWLINE);
            for (int i = 0; i < lines.length; ++i) {
                buf.append(prefix + lines[i] + NEWLINE);
            }
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    protected String indent(String contents) {
        return this.indent(contents, TAB);
    }

    protected String makeJavadocComment(String contents) {
        return "/**\n" + this.indent(contents) + NEWLINE + "*/";
    }

    protected String formMethod(String returnType, String name, String[] params, String[] names) {
        String begin = "public " + this.getCodeClassname(returnType) + TAB + name + "(";
        String paramsString = "";
        if (params != null && params.length != 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(" ");
            for (int i = 0; i < params.length; ++i) {
                buf.append(FINAL_PREFIX);
                buf.append(this.getCodeClassname(params[i]));
                buf.append(" " + names[i]);
                buf.append(PARAM_DELIM);
            }
            buf.setLength(buf.length() - PARAM_DELIM.length());
            buf.append(" ");
            paramsString = buf.toString();
        }
        return begin + paramsString + ");";
    }

    protected String getAttributeNameComment(String attributeName, String javaName) {
        String comment = "";
        if (!attributeName.equals(javaName)) {
            // empty if block
        }
        return comment;
    }

    protected String generateAttributes(MBeanAttributeInfo[] infos) {
        StringBuffer buf = new StringBuffer();
        String[] typeTemp = new String[1];
        String[] nameTemp = new String[1];
        this.mMapper = new AttributeNameMapperImpl(JMXUtil.getAttributeNames(infos));
        for (int i = 0; i < infos.length; ++i) {
            MBeanAttributeInfo info = infos[i];
            String attributeName = info.getName();
            String type = info.getType();
            String comment = "";
            String javaName = this.mMapper.originalToDerived(attributeName);
            if (info.isReadable()) {
                if (this.mEmitComments && (comment = this.getGetterComment(info, javaName)).length() != 0) {
                    buf.append(this.indent(comment) + NEWLINE);
                }
                buf.append(this.indent(this.formMethod(type, "get" + javaName, null, null)));
            }
            if (info.isWritable()) {
                buf.append(NEWLINE);
                if (this.mEmitComments && (comment = this.getSetterComment(info, javaName)).length() != 0) {
                    buf.append(this.indent(comment) + NEWLINE);
                }
                typeTemp[0] = type;
                nameTemp[0] = "value";
                buf.append(this.indent(this.formMethod("void", "set" + javaName, typeTemp, nameTemp)));
            }
            buf.append("\n\n");
        }
        return buf.toString();
    }

    protected String generateOperations(MBeanOperationInfo[] infos) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < infos.length; ++i) {
            String comment;
            MBeanOperationInfo info = infos[i];
            String name = info.getName();
            String returnType = info.getReturnType();
            MBeanParameterInfo[] paramInfos = info.getSignature();
            int impact = info.getImpact();
            String[] paramTypes = new String[paramInfos.length];
            for (int p = 0; p < paramInfos.length; ++p) {
                paramTypes[p] = paramInfos[p].getType();
            }
            String[] paramNames = this.getParamNames(info);
            if (this.mEmitComments && (comment = this.getOperationComment(info, paramNames)).length() != 0) {
                buf.append(NEWLINE + this.indent(comment) + NEWLINE);
            }
            String method = this.formMethod(returnType, name, paramTypes, paramNames);
            buf.append(this.indent(method) + NEWLINE);
        }
        return buf.toString();
    }

    protected boolean isBoilerplateDescription(String description) {
        return description == null || description.length() == 0 || description.indexOf("Attribute exposed for management") >= 0 || description.indexOf("Operation exposed for management") >= 0 || description.indexOf("No Description was available") >= 0;
    }

    @Override
    public String[] getParamNames(MBeanOperationInfo info) {
        MBeanParameterInfo[] params = info.getSignature();
        String[] names = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            names[i] = params[i].getName();
        }
        return names;
    }

    public String getGetterSetterComment(MBeanAttributeInfo info, String actualName) {
        String description;
        String string = description = info.getDescription() == null ? "" : info.getDescription();
        if (this.isBoilerplateDescription(description)) {
            description = "";
        }
        String nameComment = this.getAttributeNameComment(info.getName(), actualName);
        String result = null;
        if (description.length() == 0 && nameComment.length() == 0) {
            result = "";
        } else {
            result = description;
            if (nameComment.length() != 0) {
                if (description.length() != 0) {
                    result = result + NEWLINE;
                }
                result = result + nameComment;
            }
            result = this.makeJavadocComment(result);
        }
        return result;
    }

    @Override
    public String getGetterComment(MBeanAttributeInfo info, String actualName) {
        return this.getGetterSetterComment(info, actualName);
    }

    @Override
    public String getSetterComment(MBeanAttributeInfo info, String actualName) {
        return this.getGetterSetterComment(info, actualName);
    }

    @Override
    public String getOperationComment(MBeanOperationInfo info, String[] paramNames) {
        String description = info.getDescription();
        if (description == null || this.isBoilerplateDescription(description)) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        MBeanParameterInfo[] signature = info.getSignature();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramDescription = signature[i].getDescription();
            buf.append("@param " + paramNames[i] + TAB + paramDescription + NEWLINE);
        }
        String returnType = this.getCodeClassname(info.getReturnType());
        if (!returnType.equals("void")) {
            buf.append("@return " + returnType + NEWLINE);
        }
        return this.makeJavadocComment(buf.toString());
    }

    @Override
    public String getHeaderComment(MBeanInfo info) {
        return this.makeJavadocComment("");
    }

    @Override
    public String getInterfaceComment(MBeanInfo info) {
        String comment = "Implementing class was: " + info.getClassName();
        return this.makeJavadocComment(comment);
    }

    @Override
    public String getPackageName(MBeanInfo info) {
        return "mbeans";
    }

    private static final synchronized int getCounter() {
        return sCounter++;
    }

    @Override
    public String getClassname(MBeanInfo info) {
        return "Interface" + MBeanGenerator.getCounter();
    }

    @Override
    public String getExceptions(MBeanOperationInfo info) {
        return "";
    }
}

