/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developpers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/
/*!
 *\file info.hpp
 */

#ifndef INFO_HPP
#define INFO_HPP


#include "../main_resource.hpp"
class Interface_console;

/*!
 * \brief Class used to store informations.
 *
 * Info class uses static attributes to share informations between ViTE modules. This class cannot be instantiate thus its constructor has a private scope.
 */
class Info{

private:

    /*!
     * \brief The class constructor.
     */
    Info();


public:

    /*!
     * \brief The class destructor.
     */
    virtual ~Info();

  
    /*!
     * \brief Sub structure to store core system informations.
     */
    // struct Core{

//         /*!
//          * \brief Function pointer to the launch_action method of core system.
//          */
//         static void (Interface_console::* launch_action)(int, void*);

//         /***********************************
//          *
//          * The command line parameter processing functions.
//          *
//          **********************************/
        
//         /*!
//          *\brief An error state.
//          */
//         static const int _STATE_UNKNOWN;
        
//         /*!
//          *\brief A state which corresponds to display a help text.
//          */
//         static const int _STATE_DISPLAY_HELP;
        
//         /*!
//          *\brief A state which corresponds to display the trace within a time.
//          */
//         static const int _STATE_IN_AN_INTERVAL; // 2^0
        
//         /*!
//          *\brief A state which corresponds to display a the ViTE window and opening a file.
//          */
//         static const int _STATE_OPEN_FILE; // 2^1
        
//         /*!
//          *\brief A state which corresponds to display the trace within a time.
//          */
//         static const int _STATE_OPEN_FILE_IN_AN_INTERVAL;
        
//         /*!
//          *\brief A state which corresponds to an export of file.
//          */
//         static const int _STATE_EXPORT_FILE; // 2^2
        
//         /*!
//          *\brief A state which corresponds to an export of file.
//          */
//         static const int _STATE_EXPORT_FILE_IN_INTERVAL;
        
//         /*!
//          *\brief A state which corresponds to release the OpenGL render area (display the wait screen).
//          */
//         static const int _STATE_RELEASE_RENDER_AREA;
        
//         /*!
//          *\brief A state which corresponds to change the render area translation.
//          */
//         static const int _STATE_RENDER_AREA_CHANGE_TRANSLATE;
        
//         /*!
//          *\brief A state which corresponds to change the render area scale.
//          */
//         static const int _STATE_RENDER_AREA_CHANGE_SCALE;
        
//         /*!
//          *\brief A state which corresponds to change the render area container/state scale.
//          */
//         static const int _STATE_RENDER_AREA_CHANGE_CONTAINER_SCALE;
        
//         /*!
//          *\brief Informs that a trace has to be parsed and displayed in the main window.
//          */
//         static const int _DRAW_OPENGL;
        
//         /*!
//          *\brief  Informs that a trace has to be exported in svg format.
//          */
//         static const int _DRAW_SVG;
        
//         /*!
//          *\brief A state which corresponds to display the ViTE window.
//          */
//         static const int _STATE_LAUNCH_GRAPHICAL_INTERFACE;
        
//         /*!
//          *\brief A state which corresponds to replace the render area scale.
//          */
//         static const int _STATE_RENDER_AREA_REPLACE_SCALE;
        
//         /*!
//          *\brief A state which corresponds to replace the render area translate.
//          */
//         static const int _STATE_RENDER_AREA_REPLACE_TRANSLATE;
        
//         /*!
//          *\brief A state which corresponds to replace the render area translate.
//          */
//         static const int _STATE_RENDER_AREA_REPLACE_TRANSLATE_Y;
        
//         /*!
//          *\brief A state which corresponds to the registered render area translate.
//          */
//         static const int _STATE_RENDER_AREA_REGISTERED_TRANSLATE;
        
//         /*!
//          *\brief A state which corresponds to change the render area scale.
//          */
//         static const int _STATE_RENDER_AREA_CHANGE_SCALE_Y;
        
//         /*!
//          *\brief A state which corresponds to set new scroll bar length.
//          */
//         static const int _STATE_AJUST_SCROLL_BARS;
        
//         /*!
//          *\brief A state which corresponds to a scroll modification of the render area.
//          */
//         static const int _STATE_REFRESH_SCROLL_BARS;
        
//         /*!
//          *\brief Allow render area to change the graphical interface zoom box value.
//          */
//         static const int _STATE_ZOOM_BOX_VALUE;
        
//         /*!
//          *\brief Display information about a selected entity.
//          */
//         static const int _STATE_RENDER_DISPLAY_INFORMATION;
        
//         /*!
//          *\brief Update the render area.
//          */
//         static const int _STATE_RENDER_UPDATE;
        
//     };


    /*!
     * \brief Sub structure to store container informations.
     */
    struct Container{

        /*!
         * \brief Minimum x position.
         */
        static int x_min;

        /*!
         * \brief Maximum x position.
         */
        static int x_max;

    };
    
    /*!
     * \brief Sub structure to store state informations.
     */
    struct Entity{

        /*!
         * \brief Minimum x position.
         */
        static int x_min;

        /*!
         * \brief Maximum x position.
         */
        static int x_max;

    };

    /*!
     * \brief Sub structure to store render area informations.
     */
    struct Render{

        /*!
         * \brief Contains the state of tke ALT key.
         * true -> key pushed.
         * false -> key released.
         */
        static bool _key_alt;
	
	/*!
         * \brief Contains the state of tke CTRL key.
         * true -> key pushed.
         * false -> key released.
         */
        static bool _key_ctrl;

        /*!
         * \brief Prevent arrows to be displayed (used with Display List since it should highly decreased performance).
         */
        static bool _no_arrows;

        /*!
         * \brief Prevent events to be displayed (used with Display List since it should highly decreased performance).
         */
        static bool _no_events;

	/*!
         * \brief Contains the trace minimum visible time.
         */
        static Element_pos _x_min_visible;

	/*!
         * \brief Contains the trace maximum visible time.
         */
        static Element_pos _x_max_visible;

	/*!
         * \brief Contains the x position of selection.
         */
        static Element_pos _info_x;

	/*!
         * \brief Contains the y position of selection.
         */
        static Element_pos _info_y;

	/*!
         * \brief Contains the accurate position of selection.
         */
        static Element_pos _info_accurate;

        /*!
         * \brief To show the x beginning of the trace.
         */

        static const int X_TRACE_BEGINNING = 0;
        
        /*!
         * \brief To show the y beginning of the trace.
         */
        static const int Y_TRACE_BEGINNING = 1;
        
        /*!
         * \brief To show the x ending of the trace.
         */
        static const int X_TRACE_ENDING = 2;

        /*!
         * \brief To show the y ending of the trace.
         */
        static const int Y_TRACE_ENDING = 3;
        
        /*!
         * \brief To show the horizontal entire trace.
         */
        static const int X_TRACE_ENTIRE = 4;
        
        /*!
         * \brief To show the vertical entire trace.
         */
        static const int Y_TRACE_ENTIRE = 5;
        
        /*!
         * \brief To show the left screen of the current view.
         */
        static const int X_SCREEN_LEFT_MOVE = 6;
        
        /*!
         * \brief To show the right screen of the current view.
         */
        static const int X_SCREEN_RIGHT_MOVE = 7;
    };

    
};

#endif
