/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import rfb.LogWriter;
import rfb.PixelBuffer;
import rfb.PixelFormat;

public class PixelBufferImage
extends PixelBuffer
implements ImageProducer {
    static LogWriter vlog = new LogWriter("PixelBufferImage");
    Image image;
    Graphics graphics;
    ImageConsumer ic;
    ColorModel cm;
    byte[] reds;
    byte[] greens;
    byte[] blues;

    public void resize(int n, int n2, Component component) {
        if (n == this.width() && n2 == this.height()) {
            return;
        }
        this.ic = null;
        int n3 = this.getStride() * (this.format.bpp / 8);
        int n4 = n2 < this.height() ? n2 : this.height();
        int n5 = (n < this.width() ? n : this.width()) * (this.format.bpp / 8);
        byte[] byArray = this.data;
        this.width_ = n;
        this.height_ = n2;
        this.image = component.createImage(this);
        this.data = new byte[this.width() * this.height() * (this.format.bpp / 8)];
        int n6 = this.getStride() * (this.format.bpp / 8);
        int n7 = 0;
        while (n7 < n4) {
            System.arraycopy(byArray, n3 * n7, this.data, n6 * n7, n5);
            ++n7;
        }
    }

    public void put(int n, int n2, int n3, int n4, Graphics graphics) {
        if (this.ic == null) {
            return;
        }
        this.ic.setPixels(n, n2, n3, n4, this.cm, this.data, this.width() * n2 + n, this.width());
        this.ic.imageComplete(2);
        graphics.setClip(n, n2, n3, n4);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void copyRect(int n, int n2, int n3, int n4, int n5, int n6) {
        super.copyRect(n, n2, n3, n4, n5, n6);
        if (this.ic == null) {
            return;
        }
        this.ic.setPixels(n, n2, n3, n4, this.cm, this.data, this.width() * n2 + n, this.width());
        this.ic.imageComplete(2);
    }

    public void setColourMapEntries(int n, int n2, int[] nArray) {
        int n3 = 0;
        while (n3 < n2) {
            this.reds[n + n3] = (byte)(nArray[n3 * 3] >> 8);
            this.greens[n + n3] = (byte)(nArray[n3 * 3 + 1] >> 8);
            this.blues[n + n3] = (byte)(nArray[n3 * 3 + 2] >> 8);
            ++n3;
        }
    }

    public void updateColourMap() {
        this.cm = new IndexColorModel(8, 256, this.reds, this.greens, this.blues);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        vlog.debug("adding consumer " + imageConsumer);
        this.ic = imageConsumer;
        this.ic.setDimensions(this.width(), this.height());
        this.ic.setHints(1);
        this.ic.setPixels(0, 0, this.width(), this.height(), this.cm, this.data, 0, this.width());
        this.ic.imageComplete(2);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        System.err.println("removeConsumer " + imageConsumer);
        if (this.ic == imageConsumer) {
            this.ic = null;
        }
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public PixelBufferImage(int n, int n2, Component component) {
        this.setPF(new PixelFormat(8, 8, false, false, 0, 0, 0, 0, 0, 0));
        this.resize(n, n2, component);
        this.reds = new byte[256];
        this.greens = new byte[256];
        this.blues = new byte[256];
        int n3 = 0;
        while (n3 < 256) {
            this.reds[n3] = (byte)(((n3 & 7) * 255 + 3) / 7);
            this.greens[n3] = (byte)(((n3 >> 3 & 7) * 255 + 3) / 7);
            this.blues[n3] = (byte)(((n3 >> 6 & 3) * 255 + 1) / 3);
            ++n3;
        }
        this.cm = new IndexColorModel(8, 256, this.reds, this.greens, this.blues);
    }
}

