
// vbprefsutil.cpp
// view/set user prefs
// note -- name is due to confusion with libvoxbo/vbprefs.cpp
//         executable is called vbprefs
// Copyright (c) 2006 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
//
// original version written by Dan Kimberg

using namespace std;

#include <stdio.h>
#include <string.h>
#include <sstream>
#include "vbutil.h"
#include "vbio.h"
#include "vbprefs.h"

VBPrefs vbp;

void vbprefs_help();
void vbprefs_version();

int
main(int argc,char *argv[])
{
  vbp.init();
  tokenlist args;
  string email;
  int setflag=0;

  arghandler ah;
  string errstr;
  ah.setArgs("-e","--email",1);
  ah.setArgs("-h","--help",0);
  ah.setArgs("-v","--version",0);
  ah.parseArgs(argc,argv);

  if ((errstr=ah.badArg()).size()) {
    printf("[E] vbprefs: %s\n",errstr.c_str());
    exit(10);
  }
  if (ah.flagPresent("-h")) {
    vbprefs_help();
    exit(0);
  }
  if (ah.flagPresent("-v")) {
    vbprefs_version();
    exit(0);
  }
  args=ah.getFlaggedArgs("-e");
  if (args.size()==1) {
    email=args[0];
    setflag=1;
  }


  // FIXME get email
  if (email.size()) {
    vbp.email=email;
  }

  if (setflag) {
    createfullpath(vbp.userdir);
    string outfile=vbp.userdir+"/prefs.txt";
    FILE *fp=fopen(outfile.c_str(),"w");
    if (fp) {
      // CURRENTLY ONLY EMAIL PREF SUPPORTED
      fprintf(fp,"email %s\n",vbp.email.c_str());
      fclose(fp);
      printf("[I] vbprefs: your email address has been set to %s\n",vbp.email.c_str());
    }
    else {
      printf("[E] vbprefs: couldn't open %s to write your preferences\n",outfile.c_str());
    }
  }
  else {
    printf("\nVoxBo vbprefs (v%s)\n\n",vbversion.c_str());
    printf("    email: %-30.30s   [where messages are sent]\n",vbp.email.c_str());
    printf("  homedir: %-30.30s   [your home directory]\n",vbp.homedir.c_str());
    printf("  rootdir: %-30.30s   [root of global VoxBo]\n",vbp.rootdir.c_str());
    printf("  userdir: %-30.30s   [root of your private VoxBo files]\n",vbp.userdir.c_str());
    printf("\n");
    printf("To set your email address, try \"vbprefs -e <newemail>\"\n");
    printf("\n");
 }

  exit(0);
}

void
vbprefs_help()
{
  printf("\nVoxBo vbprefs (v%s)\n",vbversion.c_str());
  printf("usage:\n");
  printf("  vbprefs  [<flags>] <3D file/dir> <cubname>\n");
  printf("flags:\n");
  printf("  -d          set email address\n");
  printf("  -h          show help\n");
  printf("  -v          show version\n");
  printf("\n");
}

void
vbprefs_version()
{
  printf("VoxBo vbprefs (v%s)\n",vbversion.c_str());
}
