/*---------------------------------------------------------------------------*\

    This program converts raw 8kHz linear audio data to a wav file.


         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 2007 Ron Lee, Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License version 2.1 as published by the Free Software Foundation.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#include "vpbapi.h"

#include <cstdlib>
#include <fcntl.h>

using std::string;


int main(int argc, char *argv[])
{ //{{{
	if(argc < 2) {
		printf("usage: %s file\n\n", argv[0]);
		exit(EXIT_FAILURE);
	}

	int fd = open(argv[1], O_RDONLY);

	if( fd == -1 ) {
		printf("failed to open '%s': %m\n", argv[1]);
		exit(EXIT_FAILURE);
	}

	size_t  NBUF = 65536;
	char	buf[NBUF];
	string	outfile(argv[1]);
	WFILE  *wav;
	int	n;

	outfile.append(".wav");

	vpb_wave_open_write(&wav, outfile, VPB_LINEAR);

	for(;;) {
		n = read(fd, buf, NBUF);
		if( n == 0 ) break;
		if( n == -1 ) {
			printf("Read error from '%s': %m", argv[0]);
			exit(EXIT_FAILURE);
		}

		vpb_wave_write(wav, buf, n);
	}

	vpb_wave_close_write(wav);
	close(fd);

	printf("Wrote '%s'\n", outfile.c_str());

	return EXIT_SUCCESS;
} //}}}

