/****************************************************************************
 *                             VREL COMPONENTS                              *
 *                                                                          *
 *                           Copyright (C) 2000                             *
 *     Yanneck Chevalier, Pascal Belin, Alexis Jeannerod, Julien Dauphin    *
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 ****************************************************************************/

/********** instruction new **********/

#include "vrel.h"

#include "new.h"
#include "data.h"
#include "datalist.h"
#include "var.h"
#include "envvar.h"
#include "envclass.h"

extern Environnement_classe * mere;  // Tableau des classes.


// Mthode : constructeur de la classe New 
// Arguments : nom1 = nom de la classe appele
//             env1 = valeurs des paramtres d'appel 
Creation::Creation(char nom1[30], Data_liste * arg1)
{
  int i, j;
  char nomvar[30];

  ligne = lineNumber;
  kind = 0;
  strcpy (file, vrelfile);

  // Champ nom.
  strcpy(nom,nom1);

  // Vrifie l'existence de la classe.
  i = 0;
  while (strcmp(mere->nom[i], nom) != 0)
    { 
      if (i+1 >= mere->nb_classes) 
	erreur("Classe non dclare");
      i++; 
    }

  // Champ arg.
  arg = arg1;
  // Champ var.
  var = new Environnement_var();

  // Copier les var de classes de la classe associe.
  for (j=1; j < mere->classe[i]->var->count; j++) {
#if 1 //Klaus Foerster <klaus.foerster@motorola.com>
    for (int k=0; k<30 ; k++) {
      nomvar[k] = mere->classe[i]->var->nom[j][k];
    }
#else
    nomvar = mere->classe[i]->var->nom[j];
#endif
    var->declaration(nomvar);
    if (mere->classe[i]->var->donnee[j] != NULL)
      var->affectation(nomvar, mere->classe[i]->var->donnee[j]);
  }
}

// Mthode : constructeur de la classe New 
// Arguments : nom1 = nom de l'objet
//             nom2 = nom de la classe appele
//             env1 = valeurs des paramtres d'appel 
Creation::Creation(Variable * var1, char nom2[30], Data_liste * arg1)
{
  int i, j;
  char nomvar[30];

  kind = 2; // Cas spcial.
  ligne = lineNumber;
  strcpy (file, vrelfile);

  // Champ nameobj.
  strcpy(nameobj, var1->nom);

  // Champ nom. 
  strcpy(nom,nom2);

  // Vrifie l'existence de la classe 
  i = 0;
  while (strcmp(mere->nom[i], nom) != 0)
    { 
      if (i+1>= mere->nb_classes) erreur("Classe non dclare");
      i++; 
    }

  // Champ arg. 
  arg = arg1;

  // Champ var. 
  var = new Environnement_var;

  // Copier les var de classes de la classe associe
  for (j=1; j < mere->classe[i]->var->count; j++) {
    nomvar = mere->classe[i]->var->nom[j];
    var->declaration(nomvar);
    if (mere->classe[i]->var->donnee[j] != NULL)
      affectation(nomvar, mere->classe[i]->var->donnee[j]);
  }
}

// Affecte une valeur  une variable de classe 
void Creation::affectation(char nom[30], Data * flo1)
{
  if (var->affectation2(nom,flo1) == 0) 
    erreur("La variable n'est pas dclare");
}

// Mthode d'excution de l'instruction new 
void Creation::exec()
{
  int i, j;
  char nomvar[30];
  
  i = 0;
  while (strcmp (mere->nom[i], nom) != 0) 
    i++;

  // Transmettre les variables de classes
  for (j = 1; j < var->count; j++)
    {
      strcpy (nomvar, var->nom[j]);
      if (var->donnee[j] != NULL)
	mere->classe[i]->var->affectation(nomvar, var->donnee[j]);
    }

  // Executer la classe
  mere->classe[i]->exec(arg);
}

// Destructeur.
Creation::~Creation ()
{
  delete[] nom;
  delete arg;
  delete var;
  delete[] nameobj;
}
