/*
 * Audio tool
 *
 * Philippe Dax
 * Oct 1997
 */

#include "global.h"
#include "app.h"
#include "base64.h"	// decodeBase64
#include "net.h"	// getGroup getPort

#define DEVAUDIO	"/dev/audio"
#define DEVAUDIOCTL	"/dev/audioctl"


/* global variable */
int audiotool = RAT_TOOL;
int audioactive = 0;

static pid_t audiopid = -1;


static void getaudiomc(const char *mc, char *audiomc)
{
  uint16_t port;
  char group[GROUP_LEN];

  port = getPort(mc);
  port += AUDIO_INCR_PORT;
  if (port % 1)
    port++;	// even port for RTP
  getGroup(mc, group);
  createMc(audiomc, group, port, currentTtl());
  trace(DBG_TOOL, "audiomc=%s", audiomc);
}

void App::startaudio(const char *mc)
{
  char *p, audiomc[CHAN_LEN];
  char ttlstr[4];

  getaudiomc(mc, audiomc);
  sprintf(ttlstr, "%d", currentTtl());
  p = strrchr(audiomc, '/');
  *p = '\0';

#if defined(WIN32) && !defined(CYGWIN32) // _spawn
  if (audiotool == RAT_TOOL) {
    audiopid = _spawnlp(_P_NOWAIT, "rat", "rat", "-t", ttlstr,
                       "-f", "pcm", "-C", "VREng", audiomc, NULL);
  }
  if (audiotool == VAT_TOOL) {
    audiopid = _spawnlp(_P_NOWAIT, "vat", "vat", "-aAsM", "-t", ttlstr,
                       "-C", "VREng", audiomc, NULL);
  }
  if (audiotool == FPHONE_TOOL) {
    audiopid = _spawnlp(_P_NOWAIT, "fphone", "fphone", "-t", ttlstr,
                       audiomc, NULL);
  }
#else // !WIN32
  switch (audiopid = fork()) {
  case -1:
    error("%s audio", e_fork);
    break;
  case 0:
    if (audiotool == RAT_TOOL) {
      execlp("rat", "rat", "-f", "pcm", "-C", "VREng", "-t", ttlstr, audiomc, NULL);
      error("%s rat", e_exec);
    }
    if (audiotool == VAT_TOOL) {
      execlp("vat", "vat", "-aAsM", "-C", "VREng", "-t", ttlstr, audiomc, NULL);
      error("%s vat", e_exec);
    }
    if (audiotool == FPHONE_TOOL) {
      execlp("fphone", "fphone", "/T", ttlstr, audiomc, NULL);
      error("%s fphone", e_exec);
    }
    exit(1);  // child death
  default:
    break;
  }
#endif // !WIN32
}

void App::quitaudio()
{
#if WIN32 /* how to kill a process under Windows ? */
  if (audiopid > 0)
    kill(audiopid, SIGKILL);
#endif // !WIN32
}

int openaudio(void)
{
  int fdaudio;

  if ((fdaudio = open(DEVAUDIO, 1)) < 0)
    perror("open devaudio");
  return fdaudio;
}

/** play a sound */
static
void * playsound(void *snd)
{
  if (audioactive)
    return NULL;

  int fdaudio;
  if ((fdaudio = openaudio()) < 0)
    return NULL;

  char *bufaudio = strdup((const char *) snd);
  int sizeaudio = decodeBase64((const char *) snd, bufaudio);

  //trace(DBG_TOOL, "sizeaudio=%d on fdaudio=%d", sizeaudio, fdaudio);
  write(fdaudio, bufaudio, sizeaudio);
  close(fdaudio);
  free(bufaudio);
#if HAVE_LIBPTHREAD
  pthread_exit(NULL);
#endif
  return NULL;
}

void App::playSound(const char *snd)
{
#if HAVE_LIBPTHREAD
  pthread_t tid;

  pthread_create(&tid, NULL, playsound, (void *) snd);
#else
  if (fork() == 0) {
    playsound((void *) snd);
    exit(0);
  }
#endif
}

#if 0 // TODO

int last_volume = -1;
int getAudioVolumeMin() { return AUDIO_MIN_GAIN; }
int getAudioVolumeMax() { return AUDIO_MAX_GAIN; }

int getAudioVolume(int fdaudio)
{
  if (last_volume < 0) {
    audio_info_t ainfo;
    ioctl(fdaudio, AUDIO_GETINFO, &ainfo);
    last_volume = ainfo.play.gain;
  }
  return last_volume;
}

void setAudioVolume(int fdaudio, int v)
{
  last_volume = v;

  if (fdaudio >= 0) {
    audio_info_t ainfo;

    AUDIO_INITINFO(&ainfo);
    ainfo.play.gain = v;
    ioctl(fdaudio, AUDIO_SETINFO, &ainfo);
  }
}
#endif //~TODO
