/*
 * Browser tool
 *
 * Philippe Dax
 * Nov 1997
 */

#include "global.h"
#include "http.h"	// urlAbs
#include "app.h"

#include "net.h"	// getGroup getPort
#include "world.h"	// World::getChannelName

extern char **env;

#if DARWIN
#define MOZILLA_APP	"'tell app \"Mozilla\"'"
#define SAFARI_APP	"osascript -e 'tell app \"Safari\"' -e activate -e 'end tell'"
#endif

/* global variable */
int browsertool = MOZILLA_TOOL;

static pid_t browserpid = -1;
static int newwindow = 0;

static void getbrowsermc(char *browsermc)
{
  char group[GROUP_LEN];

  uint16_t port = getPort(World::getChannelName());
  getGroup(World::getChannelName(), group);
  createMc(browsermc, group, port, currentTtl());
}

void startmozilla(const char *browser, const char *url)
{
  char openurl[URL_LEN + 20];

  if (! newwindow)
    sprintf(openurl, "openURL(%s, new-window)", url);
  else
    sprintf(openurl, "openURL(%s)", url);
  newwindow++;
  pid_t pid = fork();
  switch (pid) {
  case -1:
    error("%s %s", e_fork, browser);
    break;
  case 0:
#if DARWIN
    execlp("open", "open", url, NULL);
    //execlp("osascript", "osascript", "-e", MOZILLA_APP, "-e", "activate", "-e", "'end tell'", /*"-remote", openurl,*/ NULL);
#else
    execlp(browser, browser, "-remote", openurl, NULL);
    execlp("netscape", "netscape", "-remote", openurl, NULL);
#endif
    error("%s %s", e_exec, browser);
    exit(1);
  default:
    break;
  }
}

void startnetscape(const char *browser, const char *url)
{
#ifdef LAUNCHNETSCAPE
  if (browserpid < 0) {
    switch (browserpid = fork()) {
    case -1:
      error("%s %s", e_fork, browser);
      break;
    case 0:
#if DARWIN
      execlp("open", "open", url, NULL);
#else
      execlp(browser, browser, url, NULL);
#endif
      error("%s %s", e_exec, browser);
      exit(1);
    default:
      break;
    }
  }
  else {
#endif
    char openurl[URL_LEN];

    if (! newwindow)
      sprintf(openurl, "openURL(%s, new-window)", url);
    else
      sprintf(openurl, "openURL(%s)", url);
    newwindow++;
    pid_t pid = fork();
    switch (pid) {
    case -1:
      error("%s %s", e_fork, browser);
      break;
    case 0:
#if DARWIN
      execlp("open", "open", url, NULL);
#else
      execlp(browser, browser, "-remote", openurl, NULL);
#endif
      error("%s %s", e_exec, browser);
      exit(1);
    default:
      break;
    }
#ifdef LAUNCHNETSCAPE
  }
#endif
}

void startmMosaic(const char *browser, const char *url)
{
  char *p, *ttl;
  char mmosaicmc[CHAN_LEN];

  getbrowsermc(mmosaicmc);
  p = strrchr(mmosaicmc, '/');
  *p = '\0';
  ttl = ++p;
  switch (browserpid = fork()) {
  case -1:
    error("%s %s", e_fork, browser);
    break;
  case 0:
    execlp(browser, browser, "-S", "VREng", "-t", ttl, "-mcDest", mmosaicmc, url, NULL);
    error("%s %s", e_exec, browser);
    exit(1);
  default:
    break;
  }
}

void App::startbrowser(const char *_url, bool rewrite)
{
  char url[URL_LEN];
  if (rewrite)
    urlAbs(_url, url);
  else
    strcpy(url, _url);

  //trace(DBG_TOOL, "browsertool=%d url=%s", browsertool, url);
  switch (browsertool) {
  case MOZILLA_TOOL:
    startmozilla("mozilla", url); break;
  case NETSCAPE_TOOL:
    startnetscape("netscape", url); break;
  case MMOSAIC_TOOL:
    startmMosaic("mMosaic", url); break;
  default:
    error("%s browser", e_tool);
  }
}

void App::quitbrowser()
{
  if (browserpid > 0) {
    kill(browserpid, SIGKILL);
    browserpid = -1;
  }
}
