/*
 * Midi tool
 *
 * Philippe Dax
 * Jan 2003
 */

#include "global.h"
#include "http.h"	// urlAbs
#include "app.h"


/* global variable */
int miditool = TIMIDITY_TOOL;

static pid_t midipid = -1;


static void loadmidi(const char *tool, const char *url)
{
  switch (midipid = fork()) {
  case -1:
    error("%s %s", e_fork, tool);
    break;
  case 0:
    switch (miditool) {
    case TIMIDITY_TOOL:
      execlp(tool, tool, "-idqql", "-j", url, NULL);
      break;
    }
    error("%s %s", e_exec, tool);
    exit(1);
  default:
    break;
  }
}

void App::startmidi(const char *_url)
{
  char url[URL_LEN];
  urlAbs(_url, url);

  switch (miditool) {
  case TIMIDITY_TOOL:
    loadmidi("timidity", url);
    break;
  default:
    error("%s midi", e_tool);
  }
}

void App::stopmidi()
{
  if (midipid > 0)
    kill(midipid, SIGKILL);
}

void App::pausemidi()
{
  if (midipid > 0)
    kill(midipid, SIGSTOP);
}

void App::contmidi()
{
  if (midipid > 0)
    kill(midipid, SIGCONT);
}
