/*
 * MP3 tool
 *
 * Philippe Dax
 * May 2000
 */

#include "global.h"
#include "http.h"	// urlAbs
#include "app.h"


/* global variable */
int mp3tool = MPG123_TOOL;

static pid_t mp3pid = -1;


static void loadmp3(const char *tool, const char *url)
{
  switch (mp3pid = fork()) {
  case -1:
    error("%s %s", e_fork, tool);
    break;
  case 0:
    switch (mp3tool) {
    case MPG123_TOOL:
      execlp(tool, tool, "-qy", url, NULL);
      break;
    case XAUDIO_TOOL:
      execlp(tool, tool, url, NULL);
      break;
    case FREEAMP_TOOL:
      execlp(tool, tool, url, NULL);
      break;
    }
    error("%s %s", e_exec, tool);
    exit(1);
  default:
    break;
  }
}

void App::startmp3(const char *_url)
{
  char url[URL_LEN];
  urlAbs(_url, url);

  //trace(DBG_TOOL, "mp3tool=%x url=%s", mp3tool, url);
  switch (mp3tool) {
  case MPG123_TOOL:
    loadmp3("mpg123", url);
    break;
  case XAUDIO_TOOL:
    loadmp3("xaudio", url);
    break;
  case FREEAMP_TOOL:
    loadmp3("freeamp", url);
    break;
  default:
    error("%s mp3", e_tool);
  }
}

void App::stopmp3()
{
  if (mp3pid > 0)
    kill(mp3pid, SIGKILL);
}

void App::pausemp3()
{
  if (mp3pid > 0)
    kill(mp3pid, SIGSTOP);
}

void App::contmp3()
{
  if (mp3pid > 0)
    kill(mp3pid, SIGCONT);
}
