/*
 * MPG tool
 *
 * Philippe Dax
 * May 2000
 */

#include "global.h"
#include "http.h"
#include "app.h"


/* global variable */
int mpgtool = MTVP_TOOL;

static pid_t mpgpid = -1;


static void loadmpg(const char *tool, const char *url, char *cachempg)
{
  switch (mpgpid = fork()) {
  case -1:
    error("%s %s", e_fork, tool);
    break;
  case 0:
    switch (mpgtool) {
    case MTVP_TOOL:
      //trace(DBG_TOOL, "tool=%s url=%s", tool, url);
      execlp(tool, tool, url, NULL);
      break;
    case MPEGPLAY_TOOL:
      execlp(tool, tool, cachempg, NULL);
      break;
    }
    error("%s %s", e_exec, tool);
    exit(1);
  default:
    break;
  }
}

void App::startmpg(const char *_url)
{
  char url[URL_LEN];
  urlAbs(_url, url);
  //trace(DBG_TOOL, "mpgtool=%x url=%s", mpgtool, url);

  char * cachempg = new char[64];
  switch (mpgtool) {
  case MTVP_TOOL:
    loadmpg("mtvp", url, cachempg);
    break;
  case MPEGPLAY_TOOL:
    if (App::startwget(url, cachempg) != 0)
      loadmpg("mpeg_play", url, cachempg);
    break;
  default:
    error("%s mpg", e_tool);
  }
  delete[] cachempg;
}

void App::stopmpg()
{
  if (mpgpid > 0)
    kill(mpgpid, SIGKILL);
  //pd unlinktmp(cachempg);
}

void App::pausempg()
{
  if (mpgpid > 0)
    kill(mpgpid, SIGSTOP);
}

void App::contmpg()
{
  if (mpgpid > 0)
    kill(mpgpid, SIGCONT);
}
