/*
 * Slidecast tool
 *
 * Philippe Dax
 * Sep 2000
 */

#include "global.h"
#include "app.h"

#include "net.h"	// getGroup getPort


/* global variable */
int slidecasttool = SLIDECAST_TOOL;

static pid_t slidecastpid = -1;


static void getslidecastmc(const char *mc, char *slidecastmc)
{
  uint16_t port;
  char group[GROUP_LEN];

  port = getPort(mc);
  port += SLIDECAST_INCR_PORT;
  getGroup(mc, group);
  createMc(slidecastmc, group, port, currentTtl());
  trace(DBG_TOOL, "slidecastmc=%s", slidecastmc);
}

void App::startslidecast(const char *mc)
{
  char slidecastmc[CHAN_LEN];
  getslidecastmc(mc, slidecastmc);

#if defined(WIN32) && !defined(CYGWIN32) // _spawn
  if (slidecasttool == SLIDECAST_TOOL) {
    slidecastpid = _spawnlp(_P_NOWAIT, "slide-cast", "slide-cast",
                           slidecastmc, NULL);
  }
#else // !WIN32
  switch (slidecastpid = fork()) {
  case -1:
    error("%s slide-cast", e_fork);
    break;
  case 0:
    if (slidecasttool == SLIDECAST_TOOL) {
      execlp("slide-cast", "slide-cast", slidecastmc, NULL);
      error("%s slide-cast", e_exec);
    }
    exit(1);
  default:
    break;
  }
#endif // !WIN32
}

void App::quitslidecast()
{
#ifndef WIN32 // can't killer under windows
  if (slidecastpid > 0)
    kill(slidecastpid, SIGKILL);
#endif // !WIN32
}
