#ifndef VNCSOCKETS_H
#define VNCSOCKETS_H

#define VNC_BUF_SIZE	8192

/**
 * VNCSocket class
 */
class VNCSockets {
 private:
  
  char ServerName[MAXHOSTNAMELEN];
  ///< name of the server
  
  uint16_t port;
  ///< port

  uint32_t ipaddr;
  ///< IP address of the server

  int rfbsock;
  ///< the used socket

  uint32_t buffered;
  uint8_t buf[VNC_BUF_SIZE];
  uint8_t *bufoutptr;
  ///< buffer

  bool StringToIPAddr();
  ///< stores the IP address of the server in ipaddr, returns false if unknown
  
 public:

  VNCSockets();
  VNCSockets(const char *_servername, uint16_t _port);
  VNCSockets(uint32_t IPAddr, uint16_t _port);
  ///< constructors

  void PrintInHex(char *buf, int len);
  ///< Print out the contents of a packet for debugging.

  signed int ConnectToTcpAddr();
  /**<
   * Connects to the given TCP port.
   * Returns the socket if connected, -1 if connection failed */

  bool SameMachine();
  ///< Test if the other end of a socket is on the same machine.

  bool SetNonBlocking();
  ///< sets a socket into non-blocking mode.

  bool ReadFromRFBServer(char *out, unsigned int n);
  ///< Read bytes from the sever and stores it in the buffer

  bool WriteExact(char *buf, int n);
  ///< Write an exact number of bytes, and don't return until you've sent them.

  int GetSock();
  ///< get the socket used

};

#endif // VNCSOCKETS_H
