#ifndef DEFAULTS_H
#define DEFAULTS_H

/* default servers */
#if STANDALONE
#define IPMC_ENABLED		0
#define DEF_HTTP_SERVER		"localhost"
#define DEF_MYSQL_SERVER	"localhost"
#define DEF_VJS_SERVER		"localhost"
#define DEF_VAPS_SERVER		"localhost"
#define DEF_VACS_SERVER		"localhost"
#else
#define IPMC_ENABLED		1
#define DEF_HTTP_SERVER		"vreng.enst.fr"
#define DEF_MYSQL_SERVER	"mysql.infres.enst.fr"
#define DEF_VJS_SERVER		"vreng.enst.fr"
#define DEF_VAPS_SERVER		"vaps.enst.fr"
#define DEF_VACS_SERVER		"vacs.enst.fr"
#endif
#define DEF_VRUM_SERVER		"vrum.enst.fr"
#define DEF_VRUM_ADDR		"137.194.160.2"

/* default URLs */
#define GEN_URL(u, p) 	("http://" u p)
#define DEF_URL_PREFIX	"/net/vreng/"
#define DEF_URL_CFG	GEN_URL(DEF_HTTP_SERVER,"/net/vreng/vre/v5/Rendezvous.vre")
#define DEF_FRONT_GIF	GEN_URL(DEF_HTTP_SERVER,"/net/vreng/gif/default.gif")
#define DEF_BACK_GIF	GEN_URL(DEF_HTTP_SERVER,"/net/vreng/gif/default.1.gif")
#define DEF_BALL_GIF	GEN_URL(DEF_HTTP_SERVER,"/net/vreng/gif/ball.gif")
#define VRE_VERSION	5
#define VACS_PORT	4150 + VRE_VERSION

/* default IPmc addresses & ports */
#define DEF_VRE_MPORT		52666
#define DEF_VRE_TTL		127
#define DEF_VRE_MADDR		"224.255.0.1"
#define DEF_VRE_CHANNEL		"224.255.0.1/52666/127"
#define DEF_MANAGER_CHANNEL	"224.255.0.0/52656/127"

#define SAP_ADDR		"224.2.127.254"
#define SAP_PORT		9875
#define DEF_SPIF_MADDR		"225.235.0.1"
#define DEF_SPIF_MPORT		52650

#define WELCOMESTRING	"Welcome to VREng!\n"
#define DEF_WIDTH3D	480
#define DEF_HEIGHT3D	270
#define DEF_MAXSIMCON	4	// MAX simultaneous threaded connections
#define DEF_REFRESH_TIMEOUT 1.5 // orig: 1.5

#endif // DEFAULTS_H
