#include "global.h"
#include "format.h"

static const struct _imgs imgs[] = {
  { EXT_GIF,  MIME_GIF,  LOADER_GIF },
  { EXT_PNG,  MIME_PNG,  LOADER_PNG },
  { EXT_JPG,  MIME_JPEG, LOADER_JPG },
  { EXT_JPEG, MIME_JPEG, LOADER_JPG },
  { EXT_PPM,  MIME_PPM,  LOADER_PPM },
  { EXT_PGM,  MIME_PGM,  LOADER_PGM },
  { EXT_BMP,  MIME_BMP,  LOADER_BMP },
  { EXT_PCX,  MIME_PCX,  LOADER_PCX },
  { EXT_XPM,  MIME_XPM,  LOADER_XPM },
  { EXT_RGB,  MIME_RGB,  LOADER_SGI },
  { EXT_RGBA, MIME_RGBA, LOADER_SGI },
  { EXT_LA,   MIME_LA,   LOADER_SGI },
  { EXT_BW,   MIME_BW,   LOADER_SGI },
  { EXT_PHP,  MIME_PLAIN,LOADER_NULL },
  { NULL,     NULL,      0 }
};

static const struct _icons icons[] = {
  { EXT_HTML, IMG_HTML, PLAYER_WEB }, 
  { EXT_HTM,  IMG_HTML, PLAYER_WEB }, 
  { EXT_XML,  IMG_XML,  PLAYER_WEB }, 
  { EXT_URL,  IMG_URL,  PLAYER_WEB }, 
  { EXT_TXT,  IMG_TXT,  PLAYER_WEB }, 
  { EXT_PHP,  IMG_PHP,  PLAYER_WEB }, 
  { EXT_GIF,  IMG_GIF,  PLAYER_WEB }, 
  { EXT_JPG,  IMG_JPG,  PLAYER_WEB }, 
  { EXT_JPEG, IMG_JPG,  PLAYER_WEB }, 
  { EXT_PNG,  IMG_PNG,  PLAYER_WEB }, 
  { EXT_PDF,  IMG_PDF,  PLAYER_PDF }, 
  { EXT_PS,   IMG_PS,   PLAYER_PS }, 
  { EXT_DOC,  IMG_WORD, PLAYER_OFFICE }, 
  { EXT_XLS,  IMG_XLS,  PLAYER_OFFICE }, 
  { EXT_RTF,  IMG_RTF,  PLAYER_OFFICE }, 
  { EXT_PPT,  IMG_PPT,  PLAYER_OFFICE }, 
  { EXT_MP2,  IMG_MP3,  PLAYER_MP3 }, 
  { EXT_MP3,  IMG_MP3,  PLAYER_MP3 }, 
  { EXT_MPG,  IMG_MPG,  PLAYER_MPG }, 
  { EXT_MIDI, IMG_MIDI, PLAYER_MIDI }, 
  { EXT_MID,  IMG_MIDI, PLAYER_MIDI }, 
  { EXT_C,    IMG_C,    PLAYER_WEB }, 
  { EXT_H,    IMG_H,    PLAYER_WEB }, 
  { EXT_CC,   IMG_CPP,  PLAYER_WEB }, 
  { EXT_CPP,  IMG_CPP,  PLAYER_WEB }, 
  { EXT_HPP,  IMG_H,    PLAYER_WEB }, 
  { EXT_HH,   IMG_H,    PLAYER_WEB }, 
  { EXT_SMIL, IMG_SMIL, PLAYER_WEB }, 
  { EXT_SVG,  IMG_SVG,  PLAYER_WEB }, 
  { EXT_TGZ,  IMG_TGZ,  PLAYER_WGET }, 
  { EXT_TAR,  IMG_TGZ,  PLAYER_WGET }, 
  { EXT_TARGZ,IMG_TGZ,  PLAYER_WGET }, 
  { NULL,     IMG_TXT,  PLAYER_WEB } 
};


uint8_t getLoaderByMime(const char *mime)
{
  const struct _imgs *t = imgs;
  for ( ; t->ext ; t++) {
    if (!strcmp(mime, t->mime))
      break;
  }
  return t->loader;
}

uint8_t getLoaderByExt(char *ext)
{
  char *p = ext + strlen(ext)-1;
  const struct _imgs *t = imgs;

  while (p>ext && *p != '.') p--;
  if (*p == '.') {
    p++;
    for ( ; t->ext ; t++) {
      if (!strcmp(p, t->ext))
        break;
    }
  }
  return t->loader;
}

/* fills ext */
bool getExt(char *str, char *ext)
{
  char *p, *pdot = NULL;

  if (str[strlen(str) - 1] == '/') {
    strcpy(ext, EXT_HTML);
  }
  else if ((p = strrchr(str, '.')) == 0)
    return false;
  else {
    p++;
    if (! strncmp(p, EXT_GZ, 2)) {
      pdot = --p;
      *pdot = 0;
      if ((p = strrchr(str, '.')) == 0)
        return false;
      else {
        p++;
        strncpy(ext, p, sizeof(ext) - 1);
        *pdot = '.';
      }
    }
    else {
      strncpy(ext, p, sizeof(ext) - 1);
    }
  }
  return true;
}

/* fills img */
void getImgByExt(const char *ext, char *img)
{
  const struct _icons *t = icons;
  for ( ; t->ext ; t++) {
    if (!strcasecmp(t->ext, ext))
      break;
  }
  strcpy(img, t->img);
  return;
}

uint8_t getPlayerByExt(const char *ext)
{
  const struct _icons *t = icons;
  for ( ; t->ext ; t++) {
    if (!strcasecmp(t->ext, ext))
      break;
  }
  return t->player;
}
