#ifndef HTTP_H
#define HTTP_H

#include "global.h"
#include "thread.h"
#include "images.h"	// ImageReader


#define URLBAD  0
#define URLHTTP 1
#define URLFTP  2
#define URLFILE 3
#define URLTELNET 4
#define URLSIP	5
#define URLRTSP	6
#define URLSMIL	7

#define MAXNCBUF	512
#define MAXBUF		256
#define MAXREAD		4096

#define TELNETPORT	23
#define HTTPPORT	80

#define TCPEOF		0
#define BADSEND		-1
#define BADREAD 	-2
#define BADSOCKET	-3
#define BADCONNECT	-4
#define BADURL		-5
#define BADNAME		-6
#define BADSERV		-7
#define BADHANDLE	-8

#define HTTP_OK		200

#define HTTP_PROXY	"http_proxy"
#define NO_PROXY	"no_proxy"


/**
 * Http Class
 */
class Http {
 public:
  int fd;
  int offset;
  int len;
  char buf[MAXNCBUF];

  Http();
  virtual ~Http();

  virtual int Read(char *buf, int size);
  virtual int GetChar();
  virtual uint8_t GetByte();
  virtual int GetInt();
  virtual float GetFloat();
  virtual int NextLine(char *line);
  virtual int GetLine(char *line);
  virtual int Fread(char *ptr, int size, int nitems);
  virtual uint32_t GetBuf(char *buf, int maxlen);
  virtual uint32_t Skip(int32_t skiplen);
};

void httpClearBuf(void);

void * httpThread(void *_tl);
int resolve(char *hoststr, char *portstr, struct sockaddr_in *sa);
int httpOpen(const char *url, void (*httpReader)(void *, Http *), void *infos, int blocking);
void urlAbs(const char *oldurl, char *newurl);
int url2cache(const char *url, char *cachefile);
void url2filename(const char *url, char *filename);
void filename2url(const char *filename, char *url);

#endif  // HTTP_H
