#ifndef LOG_H
#define LOG_H

extern const char *e_fork;
extern const char *e_exec;
extern const char *e_tool;
extern const char *e_not_implemented;
extern const char *e_bad_type;


void fatal(const char *s, ...);
void warning(const char *s, ...);
void notice(const char *s, ...);
void trace(int mask, const char *s, ...);
void error(const char *s, ...);

void gl_printf(GLfloat r, GLfloat g, GLfloat b, GLfloat a,
               GLint x, GLint y, GLuint font, const char *s, ...);
FILE * writelog(const char *s, ...);
void closelog(FILE *fl);
void printlog(void);

#endif  // LOG_H
