/*
 * Generate a random 32-bit quantity
 *
 * RFC 1889
 */
#include "sysdep.h"
#include "md5.h"	// from RFC 1321


#define MD_CTX MD5_CTX
#define MDInit MD5Init
#define MDUpdate MD5Update
#define MDFinal MD5Final


static uint32_t md_32(char *string, int length)
{
	MD_CTX context;
	union {
		char	c[16];
		uint32_t	x[4];
	} digest;
	uint32_t r;
	int i;

	MDInit(&context);
	MDUpdate(&context, (uint8_t *) string, length);
	MDFinal((unsigned char *)&digest, &context);
	r = 0;
	for (i = 0; i < 3; i++) {
		r ^= digest.x[i];
	}
	return r;
}

/*
 * Return random unsigned 32-bit quantity. Use 'type' argument if you
 * need to generate several different values in close succession.
 */
unsigned int random32(const int type)
{
	struct {
		int	type;
		struct	timeval tv;
		clock_t	cpu;
		pid_t	pid;
		uint32_t	hid;
#if HAVE_GETUID
		uid_t	uid;
		gid_t	gid;
#endif
#if HAVE_UNAME
		struct	utsname name;
#endif
	} s;

	gettimeofday(&s.tv, 0);
#if HAVE_UNAME
	uname(&s.name);
#endif
	s.type	= type;
	s.cpu	= clock();
	s.pid	= getpid();
#if HAVE_GETHOSTID
	s.hid	= gethostid();
#else
	s.hid	= 1;
#endif
#if HAVE_GETUID
	s.uid	= getuid();
	s.gid	= getgid();
#endif

	return md_32((char *)&s, sizeof(s));
}
