#ifndef STAT_H
#define STAT_H


/*** network counters ***/
extern uint32_t pkts_sent;
extern uint32_t sum_pkts_lost;

/*** timers ***/
typedef struct profiletime {
  struct timeval start;
  struct timeval stop;
  double cumul;
} ProfileTime;

extern ProfileTime ptime_init;
extern ProfileTime ptime_net;
extern ProfileTime ptime_events;
extern ProfileTime ptime_world;
extern ProfileTime ptime_render;
extern ProfileTime ptime_textures;
extern ProfileTime ptime_solids;
extern ProfileTime ptime_buffer;

/*** memory ***/
extern int new_wobject;
extern int del_wobject;
extern int new_world;
extern int del_world;
extern int new_solid;
extern int del_solid;
extern int new_texture;
extern int del_texture;
extern int new_image;
extern int del_image;
extern int new_channel;
extern int del_channel;
extern int new_session;
extern int del_session;
extern int new_source;
extern int del_source;
extern int new_payload;
extern int del_payload;
extern int new_netobject;
extern int del_netobject;
extern int new_objectlist;
extern int del_objectlist;
extern int new_netproperty;
extern int del_netproperty;

float getRate(void);
bool checkRate(const uint16_t rate);

void clearTime(ProfileTime *);
void startTime(ProfileTime *);
double stopTime(ProfileTime *);

void statAdjust(void);
void statNetwork(void);
void statSendPacket(int);
void statSendRTP(int);
void statSendRTCP(int);
void statReceivePacket(int);

void statRTP(class Session *session);


#endif // STAT_H
