#include "global.h"
#include "http.h"	// httpThread
#include "gui.h"	// options


int maxsimcon;				// Nb max of simultaneous connections

static int nbsimcon;			// Nb actual of simultaneous connections
static Vpthread_mutex_t nbsimcon_mutex;	// lock on the global variable simcon
#if defined(HAVE_LIBPTHREAD)
static WaitFIFO *fifofirst, *fifolast;	// variables protected by nbsimcon_mutex
#endif


void initThreads()
{
  maxsimcon = options->maxsimcon;
  initMutex(&nbsimcon_mutex);
  nbsimcon = 0;
}

#if 0
void createThread(void *func, ThreadLaunch *tl)
{
#if defined(HAVE_LIBPTHREAD)
  Vpthread_t dummy;

  pthread_create(&dummy, NULL, func, (void *) tl);
#endif
}
#endif

void initMutex(Vpthread_mutex_t *pmutex)
{
#if defined(HAVE_LIBPTHREAD)
  pthread_mutex_init(pmutex, NULL);
#endif
}

void lockMutex(Vpthread_mutex_t *pmutex)
{
#if defined(HAVE_LIBPTHREAD)
  pthread_mutex_lock(pmutex);
#endif
}

void unlockMutex(Vpthread_mutex_t *pmutex)
{
#if defined(HAVE_LIBPTHREAD)
  pthread_mutex_unlock(pmutex);
#endif
}

ThreadLaunch::ThreadLaunch()
{
  waitfifo = NULL;
  beginThread();
}

ThreadLaunch::~ThreadLaunch()
{
  endThread();
}

void ThreadLaunch::beginThread()
{
#if defined(HAVE_LIBPTHREAD) && defined(WITH_PTHREAD)
  if (mode == THREAD_BLOCK) {
    trace(DBG_THRD, "-> beginThread %s", url);
    // Wait authorization to begin
    if (waitfifo) {
      trace(DBG_THRD, "-> waitfifo unblock %s", url);
      lockMutex(&nbsimcon_mutex);
      pthread_cond_wait(&waitfifo->cond, &nbsimcon_mutex);
      trace(DBG_THRD, "-> waitfifo block %s", url);

      nbsimcon++; // update nbsimcon
      
      /* remove element from FIFO */
      fifofirst = waitfifo->next;
      delete[] waitfifo;
      waitfifo = NULL;
      unlockMutex(&nbsimcon_mutex); // free FIFO handling
    }
  }
#endif // WITH_PTHREAD 
}

void ThreadLaunch::endThread()
{
#if defined(HAVE_LIBPTHREAD) && defined(WITH_PTHREAD)
  if (mode == THREAD_BLOCK) {
    lockMutex(&nbsimcon_mutex); // access to global variable nbsimcon

    nbsimcon--;

    if (fifofirst) {	// if something in FIFO, awake it
      trace(DBG_THRD, "-> awake an (%d) %s", nbsimcon, url);
      pthread_cond_signal(&fifofirst->cond);
    }
    unlockMutex(&nbsimcon_mutex);
  }
#endif // WITH_PTHREAD
}

int ThreadLaunch::fifoThread()
{
#if defined(HAVE_LIBPTHREAD) && defined(WITH_PTHREAD)

  lockMutex(&nbsimcon_mutex);	// access to global variable nbsimcon
  if (nbsimcon == maxsimcon) {	// test number of active connections
    trace(DBG_THRD, "Nb threads: %d %s", nbsimcon, url);

    WaitFIFO *wf = new WaitFIFO[1];		// new thread

    pthread_cond_init(&(wf->cond), NULL);	// Put thread into FIFO
    wf->next = NULL;
    if (fifofirst == NULL)
      fifofirst = wf;
    if (fifolast)
      fifolast->next = wf;
    fifolast = wf;

    unlockMutex(&nbsimcon_mutex);	// unlock the global variable
    waitfifo = wf;	// Block the thread
    trace(DBG_THRD, "Too many threads, waiting... %s", url);
  }
  else {
    /* Add a connection */
    nbsimcon++;
    trace(DBG_THRD, "-> going now (%d) %s", nbsimcon, url);
    unlockMutex(&nbsimcon_mutex);
    waitfifo = NULL;	// thread not blocked
  }

  /* Start new Thread */
  Vpthread_t dummy;
  return pthread_create(&dummy, NULL, httpThread, (void *) this);

#else
  httpThread((void *) this);
  return 0;
#endif // WITH_PTHREAD
}
