#ifndef THREAD_H
#define THREAD_H

#include "vrdefs.h"

#define THREAD_NO_BLOCK	1
#define THREAD_BLOCK	0

#if defined(HAVE_LIBPTHREAD)
typedef pthread_t Vpthread_t;
typedef pthread_cond_t Vpthread_cond_t;
typedef pthread_mutex_t Vpthread_mutex_t;
#else
typedef int Vpthread_t;
typedef int Vpthread_cond_t;
typedef int Vpthread_mutex_t;
#endif // WITH_PTHREAD

class Http;

/* FIFO if max connections is reached */
typedef struct _waitfifo {
  Vpthread_cond_t cond;
  struct _waitfifo *next;
} WaitFIFO;

/**
 * ThreadLaunch Class
 * to launch a thread
 */
class ThreadLaunch {
 private:
  WaitFIFO *waitfifo;
  void beginThread();
  void endThread();

 public:
  void *handle;
  bool mode;
  char url[URL_LEN];
  void (*httpReader) (void *pinfos, Http *http);

  ThreadLaunch();
  virtual ~ThreadLaunch();

  virtual int fifoThread();
};

/* global variables */
extern int maxsimcon;


void initThreads(void);
void initMutex(Vpthread_mutex_t *pmutex);
void lockMutex(Vpthread_mutex_t *pmutex);
void unlockMutex(Vpthread_mutex_t *pmutex);


#endif // THREAD_H
